/*
 * Decompiled with CFR 0.152.
 */
package aida.io.grpc.util;

import aida.io.grpc.Attributes;
import aida.io.grpc.ConnectivityStateInfo;
import aida.io.grpc.Internal;
import aida.io.grpc.LoadBalancer;
import aida.io.grpc.util.ForwardingLoadBalancerHelper;
import aida.io.grpc.util.ForwardingSubchannel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

@Internal
public final class HealthProducerHelper
extends ForwardingLoadBalancerHelper {
    private final LoadBalancer.Helper delegate;

    public HealthProducerHelper(LoadBalancer.Helper helper) {
        this.delegate = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
    }

    @Override
    public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
        boolean alreadyParent;
        LoadBalancer.SubchannelStateListener healthConsumerListener = args.getOption(LoadBalancer.HEALTH_CONSUMER_LISTENER_ARG_KEY);
        LoadBalancer.Subchannel delegateSubchannel = super.createSubchannel(args);
        boolean bl = alreadyParent = healthConsumerListener != null && delegateSubchannel.getAttributes().get(LoadBalancer.HAS_HEALTH_PRODUCER_LISTENER_KEY) == null;
        if (!alreadyParent) {
            return delegateSubchannel;
        }
        return new HealthProducerSubchannel(delegateSubchannel, healthConsumerListener);
    }

    @Override
    protected LoadBalancer.Helper delegate() {
        return this.delegate;
    }

    @VisibleForTesting
    static final class HealthProducerSubchannel
    extends ForwardingSubchannel {
        private final LoadBalancer.Subchannel delegate;
        private final LoadBalancer.SubchannelStateListener healthListener;

        HealthProducerSubchannel(LoadBalancer.Subchannel delegate, LoadBalancer.SubchannelStateListener healthListener) {
            this.delegate = (LoadBalancer.Subchannel)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
            this.healthListener = (LoadBalancer.SubchannelStateListener)Preconditions.checkNotNull((Object)healthListener, (Object)"healthListener");
        }

        @Override
        public LoadBalancer.Subchannel delegate() {
            return this.delegate;
        }

        @Override
        public void start(final LoadBalancer.SubchannelStateListener listener) {
            this.delegate.start(new LoadBalancer.SubchannelStateListener(){

                @Override
                public void onSubchannelState(ConnectivityStateInfo newState) {
                    listener.onSubchannelState(newState);
                    healthListener.onSubchannelState(newState);
                }
            });
        }

        @Override
        public Attributes getAttributes() {
            return super.getAttributes().toBuilder().set(LoadBalancer.HAS_HEALTH_PRODUCER_LISTENER_KEY, Boolean.TRUE).build();
        }
    }
}

