/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.effect;

import com.android.tools.pixelprobe.BlendMode;
import java.awt.Color;

public final class Shadow {
    private final Type type;
    private final float blur;
    private final float angle;
    private final float distance;
    private final float opacity;
    private final Color color;
    private final BlendMode blendMode;

    Shadow(Builder builder) {
        this.type = builder.type;
        this.blur = builder.blur;
        this.angle = builder.angle;
        this.distance = builder.distance;
        this.opacity = builder.opacity;
        this.color = builder.color;
        this.blendMode = builder.blendMode;
    }

    public float getBlur() {
        return this.blur;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getDistance() {
        return this.distance;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public Color getColor() {
        return this.color;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public Type getType() {
        return this.type;
    }

    public static final class Builder {
        private float blur;
        private float angle;
        private float distance;
        private float opacity;
        private Color color = Color.BLACK;
        private BlendMode blendMode = BlendMode.NORMAL;
        private final Type type;

        public Builder(Type type) {
            this.type = type;
        }

        public Builder blur(float blur) {
            this.blur = blur;
            return this;
        }

        public Builder angle(float angle) {
            this.angle = angle;
            return this;
        }

        public Builder distance(float distance) {
            this.distance = distance;
            return this;
        }

        public Builder opacity(float opacity) {
            this.opacity = opacity;
            return this;
        }

        public Builder color(Color color) {
            this.color = color;
            return this;
        }

        public Builder blendMode(BlendMode blendMode) {
            this.blendMode = blendMode;
            return this;
        }

        public Shadow build() {
            return new Shadow(this);
        }
    }

    public static enum Type {
        INNER,
        OUTER;

    }
}

