/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.color;

import java.awt.color.ColorSpace;
import java.awt.image.IndexColorModel;

public class CsIndexColorModel
extends IndexColorModel {
    private CsIndexColorModel(int bits, int size, int[] cmap, int start, boolean hasalpha, int trans, int transferType) {
        super(bits, size, cmap, start, hasalpha, trans, transferType);
    }

    public static CsIndexColorModel createInvertedBitmap() {
        int[] bwMap = new int[]{0xFFFFFF, 0};
        return new CsIndexColorModel(1, 2, bwMap, 0, false, -1, 0);
    }

    public static CsIndexColorModel createIndexed(int size, byte[] map, int transparency, ColorSpace colorSpace) {
        int[] sRgbMap = new int[size];
        CsIndexColorModel.convert(size, map, sRgbMap, colorSpace);
        return new CsIndexColorModel(8, size, sRgbMap, 0, false, transparency, 0);
    }

    private static void convert(int size, byte[] srcMap, int[] dstMap, ColorSpace colorSpace) {
        float[] src = new float[3];
        for (int i = 0; i < size; ++i) {
            src[0] = (float)srcMap[i] / 255.0f;
            src[1] = (float)srcMap[i + 256] / 255.0f;
            src[2] = (float)srcMap[i + 512] / 255.0f;
            float[] dst = colorSpace.toRGB(src);
            dstMap[i] = ((int)(dst[0] * 255.0f) & 0xFF) << 16 | ((int)(dst[1] * 255.0f) & 0xFF) << 8 | (int)(dst[2] * 255.0f) & 0xFF;
        }
    }
}

