/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe;

import com.android.tools.pixelprobe.BlendMode;
import com.android.tools.pixelprobe.util.Lists;
import com.android.tools.pixelprobe.util.Strings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;

public final class ShapeInfo {
    private final Style style;
    private final List<Path> paths;
    private final Paint fillPaint;
    private final float fillOpacity;
    private final Stroke stroke;
    private final Paint strokePaint;
    private final float strokeOpacity;
    private final BlendMode strokeBlendMode;
    private final Alignment strokeAlignment;

    ShapeInfo(Builder builder) {
        this.style = builder.style;
        this.paths = Lists.immutableCopy(builder.paths);
        this.fillPaint = builder.fillPaint;
        this.fillOpacity = builder.fillOpacity;
        this.stroke = builder.stroke;
        this.strokePaint = builder.strokePaint;
        this.strokeOpacity = builder.strokeOpacity;
        this.strokeBlendMode = builder.strokeBlendMode;
        this.strokeAlignment = builder.strokeAlignment;
    }

    public Style getStyle() {
        return this.style;
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public float getFillOpacity() {
        return this.fillOpacity;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public float getStrokeOpacity() {
        return this.strokeOpacity;
    }

    public BlendMode getStrokeBlendMode() {
        return this.strokeBlendMode;
    }

    public Alignment getStrokeAlignment() {
        return this.strokeAlignment;
    }

    public String toString() {
        return "ShapeInfo{style=" + (Object)((Object)this.style) + ", paths={" + Strings.join(this.paths, ",") + "}, fillPaint=" + this.fillPaint + ", fillOpacity=" + this.fillOpacity + ", stroke=" + (this.stroke != null) + ", strokePaint=" + this.strokePaint + ", strokeOpacity=" + this.strokeOpacity + ", strokeBlendMode=" + (Object)((Object)this.strokeBlendMode) + ", strokeAlignment=" + (Object)((Object)this.strokeAlignment) + '}';
    }

    public static final class Builder {
        Style style = Style.FILL;
        final List<Path> paths = new ArrayList<Path>();
        Paint fillPaint = Color.BLACK;
        float fillOpacity = 1.0f;
        Stroke stroke = new BasicStroke(0.0f);
        Paint strokePaint = Color.BLACK;
        float strokeOpacity = 1.0f;
        BlendMode strokeBlendMode = BlendMode.NORMAL;
        Alignment strokeAlignment = Alignment.CENTER;

        public Builder style(Style style) {
            this.style = style;
            return this;
        }

        public Builder addPath(Path path) {
            this.paths.add(path);
            return this;
        }

        public Builder fillPaint(Paint paint) {
            this.fillPaint = paint;
            return this;
        }

        public Builder fillOpacity(float opacity) {
            this.fillOpacity = opacity;
            return this;
        }

        public Builder stroke(Stroke stroke) {
            this.stroke = stroke;
            return this;
        }

        public Builder strokePaint(Paint paint) {
            this.strokePaint = paint;
            return this;
        }

        public Builder strokeOpacity(float opacity) {
            this.strokeOpacity = opacity;
            return this;
        }

        public Builder strokeBlendMode(BlendMode blendMode) {
            this.strokeBlendMode = blendMode;
            return this;
        }

        public Builder strokeAlignment(Alignment alignment) {
            this.strokeAlignment = alignment;
            return this;
        }

        public ShapeInfo build() {
            return new ShapeInfo(this);
        }
    }

    public static enum Style {
        FILL,
        STROKE,
        FILL_AND_STROKE,
        NONE;


        public static Style from(boolean fillEnabled, boolean strokeEnabled) {
            if (fillEnabled) {
                return strokeEnabled ? FILL_AND_STROKE : FILL;
            }
            if (strokeEnabled) {
                return STROKE;
            }
            return NONE;
        }
    }

    public static enum Alignment {
        INSIDE,
        CENTER,
        OUTSIDE;

    }

    public static final class Path {
        private final Path2D path;
        private final PathOp op;
        private final PathType type;

        Path(Builder builder) {
            this.path = builder.path;
            this.op = builder.op;
            this.type = builder.type;
        }

        public Path2D getPath() {
            return (Path2D)this.path.clone();
        }

        public PathOp getOp() {
            return this.op;
        }

        public PathType getType() {
            return this.type;
        }

        public String toString() {
            return "Path{path=" + this.path + ", type=" + (Object)((Object)this.type) + ", op=" + (Object)((Object)this.op) + '}';
        }

        public static final class Builder {
            private Path2D path = new Path2D.Float();
            private PathOp op = PathOp.ADD;
            private PathType type = PathType.CLOSED;

            public Builder type(PathType type) {
                this.type = type;
                return this;
            }

            public Builder op(PathOp op) {
                this.op = op;
                return this;
            }

            public Builder path(Path2D path) {
                this.path = path;
                return this;
            }

            public Path build() {
                return new Path(this);
            }
        }
    }

    public static enum PathType {
        OPEN,
        CLOSED,
        UNKNOWN;

    }

    public static enum PathOp {
        ADD,
        SUBTRACT,
        INTERSECT,
        EXCLUSIVE_OR;

    }
}

