/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.util;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class ImageHelper {
    public static BufferedImage rotateImage(BufferedImage image, int rotation) {
        if (rotation == 0) {
            return image;
        }
        AffineTransform transform = new AffineTransform();
        transform.translate(image.getHeight() / 2, image.getWidth() / 2);
        transform.rotate(ImageHelper.getTheta(rotation));
        transform.translate(-image.getWidth() / 2, -image.getHeight() / 2);
        AffineTransformOp op = new AffineTransformOp(transform, 1);
        return op.filter(image, null);
    }

    private static double getTheta(int rotation) {
        switch (rotation) {
            case 1: {
                return -1.5707963267948966;
            }
            case 2: {
                return Math.PI;
            }
            case 3: {
                return 1.5707963267948966;
            }
        }
        return 0.0;
    }
}

