/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.other.automotiveMessagingService.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"messagingServiceKt", "", "packageName", "serviceName", "useAndroidX", "", "intellij.android.wizardTemplate.impl"})
public final class MessagingServiceKtKt {
    @NotNull
    public static final String messagingServiceKt(@NotNull String packageName, @NotNull String serviceName, boolean useAndroidX) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + "\n\nimport android.app.PendingIntent\nimport android.app.Service\nimport android.content.Intent\nimport android.os.Handler\nimport android.os.Looper\nimport android.os.IBinder\nimport android.os.Message\nimport android.os.Messenger\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.NotificationChannelCompat", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.NotificationCompat", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.NotificationCompat.CarExtender", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.NotificationCompat.CarExtender.UnreadConversation", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.NotificationManagerCompat", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.RemoteInput", useAndroidX) + "\n\nconst val CHANNEL_ID = \"" + packageName + ".CHANNEL_ID\"\nconst val READ_ACTION = \"" + packageName + ".ACTION_MESSAGE_READ\"\nconst val REPLY_ACTION = \"" + packageName + ".ACTION_MESSAGE_REPLY\"\nconst val CONVERSATION_ID = \"conversation_id\"\nconst val EXTRA_VOICE_REPLY = \"extra_voice_reply\"\n\nclass " + serviceName + " : Service() {\n\n    private val mMessenger = Messenger(IncomingHandler())\n    private lateinit var mNotificationManager: NotificationManagerCompat\n\n    override fun onCreate() {\n        mNotificationManager = NotificationManagerCompat.from(applicationContext)\n    }\n\n    override fun onBind(intent: Intent): IBinder? {\n        return mMessenger.binder\n    }\n\n    override fun onStartCommand(intent: Intent, flags: Int, startId: Int): Int {\n        return Service.START_STICKY\n    }\n\n    private fun createIntent(conversationId: Int, action: String): Intent {\n        return Intent().apply {\n                addFlags(Intent.FLAG_INCLUDE_STOPPED_PACKAGES)\n                setAction(action)\n                putExtra(CONVERSATION_ID, conversationId)\n        }\n    }\n\n    private fun sendNotification(conversationId: Int,\n                                 message: String,\n                                 participant: String,\n                                 timestamp: Long) {\n        // A pending Intent for reads\n        val readPendingIntent = PendingIntent.getBroadcast(applicationContext,\n                conversationId,\n                createIntent(conversationId, READ_ACTION),\n                PendingIntent.FLAG_UPDATE_CURRENT)\n\n        // Build a RemoteInput for receiving voice input in a Car Notification\n        val remoteInput = RemoteInput.Builder(EXTRA_VOICE_REPLY)\n                .setLabel(\"Reply by voice\")\n                .build()\n\n        // Building a Pending Intent for the reply action to trigger\n        val replyIntent = PendingIntent.getBroadcast(applicationContext,\n                conversationId,\n                createIntent(conversationId, REPLY_ACTION),\n                PendingIntent.FLAG_UPDATE_CURRENT)\n\n        // Create the UnreadConversation and populate it with the participant name,\n        // read and reply intents.\n        val unreadConversationBuilder = UnreadConversation.Builder(participant)\n                .setLatestTimestamp(timestamp)\n                .setReadPendingIntent(readPendingIntent)\n                .setReplyAction(replyIntent, remoteInput)\n\n        val channel = NotificationChannelCompat\n                .Builder(CHANNEL_ID, NotificationManagerCompat.IMPORTANCE_DEFAULT)\n                .setName(resources.getText(R.string.app_name))\n                .build()\n        NotificationManagerCompat.from(applicationContext).createNotificationChannel(channel)\n\n        val builder = NotificationCompat.Builder(applicationContext, CHANNEL_ID)\n                // Set the application notification icon:\n                //.setSmallIcon(R.drawable.notification_icon)\n\n                // Set the large icon, for example a picture of the other recipient of the message\n                //.setLargeIcon(personBitmap)\n\n                .setContentText(message)\n                .setWhen(timestamp)\n                .setContentTitle(participant)\n                .setContentIntent(readPendingIntent)\n                .extend(CarExtender()\n                        .setUnreadConversation(unreadConversationBuilder.build()))\n\n        mNotificationManager.notify(conversationId, builder.build())\n    }\n\n    /**\n     * Handler of incoming messages from clients.\n     */\n    internal inner class IncomingHandler : Handler(Looper.myLooper()!!) {\n        override fun handleMessage(msg: Message) {\n            sendNotification(1, \"This is a sample message\", \"John Doe\", System.currentTimeMillis())\n        }\n    }\n}\n";
    }
}

