/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.fragments.loginFragment.src.app_package.data;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"loginRepositoryKt", "", "packageName", "intellij.android.wizardTemplate.impl"})
public final class LoginRepositoryKtKt {
    @NotNull
    public static final String loginRepositoryKt(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + ".data\n\nimport " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + ".data.model.LoggedInUser\n\n/**\n * Class that requests authentication and user information from the remote data source and\n * maintains an in-memory cache of login status and user credentials information.\n */\n\nclass LoginRepository(val dataSource: LoginDataSource) {\n\n    // in-memory cache of the loggedInUser object\n    var user: LoggedInUser? = null\n        private set\n\n    val isLoggedIn: Boolean\n        get() = user != null\n\n    init {\n        // If user credentials will be cached in local storage, it is recommended it be encrypted\n        // @see https://developer.android.com/training/articles/keystore\n        user = null\n    }\n\n    fun logout() {\n        user = null\n        dataSource.logout()\n    }\n\n    fun login(username: String, password: String): Result<LoggedInUser> {\n        // handle login\n        val result = dataSource.login(username, password)\n\n        if (result is Result.Success) {\n            setLoggedInUser(result.data)\n        }\n\n        return result\n    }\n\n    private fun setLoggedInUser(loggedInUser: LoggedInUser) {\n        this.user = loggedInUser\n        // If user credentials will be cached in local storage, it is recommended it be encrypted\n        // @see https://developer.android.com/training/articles/keystore\n    }\n}\n";
    }
}

