/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.aiGlassesActivity.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\u0006"}, d2={"mainActivityKt", "", "activityClass", "glassesActivityClass", "packageName", "themeName", "intellij.android.wizardTemplate.impl"})
public final class MainActivityKtKt {
    @NotNull
    public static final String mainActivityKt(@NotNull String activityClass, @NotNull String glassesActivityClass, @NotNull String packageName, @NotNull String themeName) {
        Intrinsics.checkNotNullParameter((Object)activityClass, (String)"activityClass");
        Intrinsics.checkNotNullParameter((Object)glassesActivityClass, (String)"glassesActivityClass");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)themeName, (String)"themeName");
        return "\n@file:OptIn(ExperimentalProjectedApi::class)\n\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + "\n\nimport android.content.Intent\nimport android.os.Build\nimport android.os.Bundle\nimport androidx.activity.ComponentActivity\nimport androidx.activity.compose.setContent\nimport androidx.activity.enableEdgeToEdge\nimport androidx.compose.foundation.layout.Arrangement\nimport androidx.compose.foundation.layout.Column\nimport androidx.compose.foundation.layout.Spacer\nimport androidx.compose.foundation.layout.fillMaxSize\nimport androidx.compose.foundation.layout.height\nimport androidx.compose.foundation.layout.padding\nimport androidx.compose.material3.Button\nimport androidx.compose.material3.ButtonDefaults\nimport androidx.compose.material3.MaterialTheme\nimport androidx.compose.material3.Scaffold\nimport androidx.compose.material3.Text\nimport androidx.compose.runtime.Composable\nimport androidx.compose.runtime.getValue\nimport androidx.compose.runtime.rememberCoroutineScope\nimport androidx.compose.ui.Alignment\nimport androidx.compose.ui.Modifier\nimport androidx.compose.ui.platform.LocalContext\nimport androidx.compose.ui.res.stringResource\nimport androidx.compose.ui.tooling.preview.Preview\nimport androidx.compose.ui.unit.dp\nimport androidx.lifecycle.compose.collectAsStateWithLifecycle\nimport androidx.xr.projected.ProjectedContext\nimport androidx.xr.projected.experimental.ExperimentalProjectedApi\nimport " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + ".ui.theme." + themeName + "\n\nclass " + activityClass + " : ComponentActivity() {\n    override fun onCreate(savedInstanceState: Bundle?) {\n        super.onCreate(savedInstanceState)\n        enableEdgeToEdge()\n        setContent {\n            " + themeName + " {\n                ConnectionScreen()\n            }\n        }\n    }\n}\n\n@Composable\nfun ConnectionScreen() {\n    val context = LocalContext.current\n    Scaffold { paddingValues ->\n        Column(\n            modifier = Modifier\n                .fillMaxSize()\n                .padding(paddingValues),\n            horizontalAlignment = Alignment.CenterHorizontally,\n            verticalArrangement = Arrangement.Center\n        ) {\n            Text(\n                text = stringResource(id = R.string.hello_ai_glasses),\n                style = MaterialTheme.typography.titleLarge\n            )\n            Spacer(modifier = Modifier.height(32.dp))\n            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.VANILLA_ICE_CREAM){\n                val scope = rememberCoroutineScope()\n                val isGlassesConnected by ProjectedContext.isProjectedDeviceConnected(context, scope.coroutineContext).collectAsStateWithLifecycle(initialValue = false)\n                Button(\n                    onClick = {\n                        val options = ProjectedContext.createProjectedActivityOptions(context)\n                        val intent = Intent(context, " + glassesActivityClass + "::class.java)\n                        context.startActivity(intent, options.toBundle())\n                    },\n                    colors = ButtonDefaults.buttonColors(\n                        containerColor = if (isGlassesConnected) MaterialTheme.colorScheme.primary else MaterialTheme.colorScheme.error\n                    ),\n                    enabled = isGlassesConnected\n                ) {\n                    Text(\n                        text = stringResource(id = R.string.launch),\n                        style = MaterialTheme.typography.headlineMedium\n                    )\n                }\n                Spacer(modifier = Modifier.height(32.dp))\n                Text(\n                    text = stringResource(id = R.string.status_prefix) + if (isGlassesConnected) stringResource(id = R.string.status_connected) else stringResource(id = R.string.status_disconnected),\n                    style = MaterialTheme.typography.titleMedium\n                )\n            }else {\n                Text(\n                    text = stringResource(id = R.string.unsupported_android_version),\n                    style = MaterialTheme.typography.titleMedium)\n            }\n        }\n    }\n}\n@Preview(showBackground = true)\n@Composable\nfun ConnectionScreenPreview() {\n    ConnectionScreen()\n}\n";
    }
}

