/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.aiGlassesActivity.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u00a8\u0006\u0004"}, d2={"glassesActivityKt", "", "activityClass", "packageName", "intellij.android.wizardTemplate.impl"})
public final class GlassesActivityKtKt {
    @NotNull
    public static final String glassesActivityKt(@NotNull String activityClass, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)activityClass, (String)"activityClass");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + "\n\nimport android.os.Bundle\nimport androidx.activity.ComponentActivity\nimport androidx.activity.compose.setContent\nimport androidx.compose.foundation.layout.Box\nimport androidx.compose.foundation.layout.fillMaxSize\nimport androidx.compose.runtime.Composable\nimport androidx.compose.ui.Alignment\nimport androidx.compose.ui.Modifier\nimport androidx.compose.ui.res.stringResource\nimport androidx.compose.ui.tooling.preview.Preview\nimport androidx.xr.glimmer.Button\nimport androidx.xr.glimmer.Card\nimport androidx.xr.glimmer.GlimmerTheme\nimport androidx.xr.glimmer.Text\nimport androidx.xr.glimmer.surface\n\nclass " + activityClass + " : ComponentActivity() {\n    private lateinit var audioInterface : AudioInterface\n    override fun onCreate(savedInstanceState: Bundle?) {\n        super.onCreate(savedInstanceState)\n        audioInterface = AudioInterface(\n            this,\n            getString(R.string.hello_ai_glasses))\n        lifecycle.addObserver(audioInterface)\n        setContent {\n            GlimmerTheme {\n                HomeScreen(onClose = {\n                    audioInterface.speak(\"Goodbye!\")\n                    finish()\n                })\n            }\n        }\n    }\n    override fun onStart() {\n        super.onStart()\n        // Do things to make the user aware that this activity is active (for\n        // example, play audio), when the display state is off\n    }\n    override fun onStop() {\n        super.onStop()\n        //Stop all the data source access\n    }\n}\n@Composable\nfun HomeScreen(modifier: Modifier = Modifier, onClose: () -> Unit ) {\n    Box(\n        modifier = modifier\n            .surface(focusable = false).fillMaxSize(),\n        contentAlignment = Alignment.Center\n    ) {\n        Card(\n            title = {  Text(stringResource(id = R.string.app_name)) },\n            action = {\n                Button(onClick = {\n                    onClose()\n                }) {\n                    Text(stringResource(id = R.string.close))\n                }\n            }\n        ) {\n            Text(stringResource(id = R.string.hello_ai_glasses))\n        }\n    }\n}\n@Preview(device = \"id:ai_glasses_device\", backgroundColor = 0x00FF00)\n@Composable\nfun DefaultPreview() {\n    GlimmerTheme {\n        HomeScreen(onClose = {})\n    }\n}\n";
    }
}

