/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.aiGlassesActivity.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"audioInterfaceKt", "", "packageName", "intellij.android.wizardTemplate.impl"})
public final class AudioInterfaceKtKt {
    @NotNull
    public static final String audioInterfaceKt(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + "\n\nimport android.content.Context\nimport android.speech.tts.TextToSpeech\nimport android.util.Log\nimport androidx.lifecycle.DefaultLifecycleObserver\nimport androidx.lifecycle.LifecycleOwner\n\nclass AudioInterface(\n    private val context: Context,\n    private val initializationMessage: String\n) : DefaultLifecycleObserver {\n    private lateinit var tts : TextToSpeech\n    override fun onStart(owner: LifecycleOwner) {\n        super.onStart(owner)\n        tts = TextToSpeech(context) { status ->\n            if (status == TextToSpeech.SUCCESS) {\n                speak(initializationMessage)\n            } else {\n                Log.e(TAG, \"Initialization failed with status: $status\")\n            }\n        }\n    }\n    fun speak(textToSpeak: String){\n        tts.speak(textToSpeak,\n            TextToSpeech.QUEUE_ADD,\n            null,\n            initializationMessage.lowercase().replace(\" \", \"_\"))\n    }\n    override fun onStop(owner: LifecycleOwner) {\n        super.onStop(owner)\n        tts.shutdown()\n    }\n\n    companion object {\n        private const val TAG = \"AudioInterface\"\n    }\n}\n";
    }
}

