/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.compose.code.state;

import com.android.tools.compose.ComposeBundle;
import com.intellij.codeInsight.hints.declarative.DeclarativeInlayHintsSettings;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayHintsPassFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016J \u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0097\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/compose/code/state/ComposeStateReadInlayHintsAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "enable", "", "<init>", "(Z)V", "msgText", "", "getFamilyName", "getText", "startInWriteAction", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "hintsEnabled", "intellij.android.compose-ide-plugin"})
final class ComposeStateReadInlayHintsAction
implements IntentionAction {
    private final boolean enable;
    @NotNull
    private final String msgText;

    public ComposeStateReadInlayHintsAction(boolean enable) {
        this.enable = enable;
        this.msgText = this.enable ? ComposeBundle.Companion.message("state.read.inlay.provider.enable", new Object[0]) : ComposeBundle.Companion.message("state.read.inlay.provider.disable", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return this.msgText;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @RequiresReadLock
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.hintsEnabled() != this.enable;
    }

    @RequiresWriteLock
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DeclarativeInlayHintsSettings.Companion.getInstance().setProviderEnabled("compose.state.read", this.enable);
        DeclarativeInlayHintsPassFactory.Companion.scheduleRecompute(editor, project);
    }

    private final boolean hintsEnabled() {
        Boolean bl = DeclarativeInlayHintsSettings.Companion.getInstance().isProviderEnabled("compose.state.read");
        return bl != null ? bl : false;
    }
}

