/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.modulemap.ModuleMapParserTypes;
import com.jetbrains.cidr.lang.modulemap.psi.ModuleMapModuleDeclaration;
import com.jetbrains.cidr.lang.modulemap.psi.ModuleMapRecursiveVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J.\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J.\u0010\u0017\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0013*\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u001c\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\u00130\u0013*\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\f\u0010\u001f\u001a\u00020\u000f*\u00020\u0013H\u0002J\u001c\u0010 \u001a\n \u001e*\u0004\u0018\u00010\u00130\u0013*\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u000fH\u0002\u00a8\u0006!"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/editor/ModuleMapFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "buildLanguageFoldRegions", "", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "getLanguagePlaceholderText", "", "node", "Lcom/intellij/lang/ASTNode;", "range", "Lcom/intellij/openapi/util/TextRange;", "isRegionCollapsedByDefault", "addDescriptor", "start", "finish", "findLastEolCommentNode", "forward", "nextEolCommentNode", "skipWhiteSpaceWithOneLineFeed", "kotlin.jvm.PlatformType", "isWhitespaceWithOneLineFeed", "next", "intellij.cidr.modulemap.language"})
@SourceDebugExtension(value={"SMAP\nModuleMapFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapFoldingBuilder.kt\ncom/jetbrains/cidr/lang/modulemap/editor/ModuleMapFoldingBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,76:1\n1#2:77\n1104#3,3:78\n*S KotlinDebug\n*F\n+ 1 ModuleMapFoldingBuilder.kt\ncom/jetbrains/cidr/lang/modulemap/editor/ModuleMapFoldingBuilder\n*L\n74#1:78,3\n*E\n"})
public final class ModuleMapFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        root.accept((PsiElementVisitor)new ModuleMapRecursiveVisitor(this, descriptors){
            final /* synthetic */ ModuleMapFoldingBuilder this$0;
            final /* synthetic */ List<FoldingDescriptor> $descriptors;
            {
                this.this$0 = $receiver;
                this.$descriptors = $descriptors;
            }

            public void visitModuleDeclaration(ModuleMapModuleDeclaration o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitModuleDeclaration(o);
                ASTNode node = o.getNode();
                ASTNode aSTNode = node.findChildByType(ModuleMapParserTypes.L_CURLY);
                if (aSTNode == null) {
                    return;
                }
                ASTNode lcurly = aSTNode;
                ASTNode rcurly = node.findChildByType(ModuleMapParserTypes.R_CURLY);
                Intrinsics.checkNotNull((Object)node);
                ASTNode aSTNode2 = rcurly;
                if (aSTNode2 == null) {
                    aSTNode2 = node;
                }
                ModuleMapFoldingBuilder.access$addDescriptor(this.this$0, this.$descriptors, node, lcurly, aSTNode2);
            }

            public void visitComment(PsiComment comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                super.visitComment(comment);
                ASTNode node = comment.getNode();
                IElementType iElementType = node.getElementType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)ModuleMapParserTypes.BLOCK_COMMENT)) {
                    if (node.textContains('\n')) {
                        Intrinsics.checkNotNull((Object)node);
                        ModuleMapFoldingBuilder.access$addDescriptor(this.this$0, this.$descriptors, node, node, node);
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)ModuleMapParserTypes.EOL_COMMENT)) {
                    Intrinsics.checkNotNull((Object)node);
                    ASTNode first = ModuleMapFoldingBuilder.access$findLastEolCommentNode(this.this$0, node, false);
                    ASTNode last = ModuleMapFoldingBuilder.access$findLastEolCommentNode(this.this$0, node, true);
                    if (first != last) {
                        ModuleMapFoldingBuilder.access$addDescriptor(this.this$0, this.$descriptors, node, first, last);
                    }
                }
            }
        });
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return Intrinsics.areEqual((Object)node.getElementType(), (Object)ModuleMapParserTypes.MODULE_DECLARATION) ? "{\u2026}" : "\u2026";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return false;
    }

    private final void addDescriptor(List<FoldingDescriptor> descriptors, ASTNode node, ASTNode start, ASTNode finish) {
        descriptors.add(new FoldingDescriptor(node, new TextRange(start.getTextRange().getStartOffset(), finish.getTextRange().getEndOffset())));
    }

    private final ASTNode findLastEolCommentNode(ASTNode node, boolean forward) {
        return (ASTNode)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)node, arg_0 -> ModuleMapFoldingBuilder.findLastEolCommentNode$lambda$0(this, forward, arg_0)));
    }

    private final ASTNode nextEolCommentNode(ASTNode $this$nextEolCommentNode, boolean forward) {
        Object object;
        ASTNode aSTNode;
        ASTNode aSTNode2 = this.next($this$nextEolCommentNode, forward);
        if (aSTNode2 != null && (aSTNode = this.skipWhiteSpaceWithOneLineFeed(aSTNode2, forward)) != null) {
            ASTNode aSTNode3;
            ASTNode it = aSTNode3 = aSTNode;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getElementType(), (Object)ModuleMapParserTypes.EOL_COMMENT) ? aSTNode3 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final ASTNode skipWhiteSpaceWithOneLineFeed(ASTNode $this$skipWhiteSpaceWithOneLineFeed, boolean forward) {
        return this.isWhitespaceWithOneLineFeed($this$skipWhiteSpaceWithOneLineFeed) ? this.next($this$skipWhiteSpaceWithOneLineFeed, forward) : $this$skipWhiteSpaceWithOneLineFeed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isWhitespaceWithOneLineFeed(ASTNode $this$isWhitespaceWithOneLineFeed) {
        if (!Intrinsics.areEqual((Object)$this$isWhitespaceWithOneLineFeed.getElementType(), (Object)TokenType.WHITE_SPACE)) return false;
        String string = $this$isWhitespaceWithOneLineFeed.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence $this$count$iv = string;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        if (count$iv != true) return false;
        return true;
    }

    private final ASTNode next(ASTNode $this$next, boolean forward) {
        return forward ? $this$next.getTreeNext() : $this$next.getTreePrev();
    }

    private static final ASTNode findLastEolCommentNode$lambda$0(ModuleMapFoldingBuilder this$0, boolean $forward, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.nextEolCommentNode(it, $forward);
    }

    public static final /* synthetic */ void access$addDescriptor(ModuleMapFoldingBuilder $this, List descriptors, ASTNode node, ASTNode start, ASTNode finish) {
        $this.addDescriptor(descriptors, node, start, finish);
    }

    public static final /* synthetic */ ASTNode access$findLastEolCommentNode(ModuleMapFoldingBuilder $this, ASTNode node, boolean forward) {
        return $this.findLastEolCommentNode(node, forward);
    }
}

