/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.asm;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.asm._AsmLexer;
import org.jetbrains.annotations.NotNull;

public class AsmLexer
extends FlexAdapter {
    public static final String DEFAULT_COMMENT_START_CHARS = "#";
    private boolean myDetectNonCommentHashUsages;
    private static final int NON_COMMENT_HASH_USAGE_THRESHOLD = 8192;
    private int myNonCommentHashUsagesSampleSize;

    public AsmLexer() {
        this(DEFAULT_COMMENT_START_CHARS, true);
    }

    public AsmLexer(@NotNull String commentStartChars, boolean detectNonCommentHashUsages) {
        if (commentStartChars == null) {
            AsmLexer.$$$reportNull$$$0(0);
        }
        super((FlexLexer)new _AsmLexer(null, commentStartChars));
        this.myDetectNonCommentHashUsages = detectNonCommentHashUsages;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            AsmLexer.$$$reportNull$$$0(1);
        }
        super.start(buffer, startOffset, endOffset, initialState);
        if (this.myDetectNonCommentHashUsages && this.myNonCommentHashUsagesSampleSize < 8192) {
            _AsmLexer lexer = (_AsmLexer)this.getFlex();
            String commentStartChars = lexer.getCommentStartChars();
            if (commentStartChars.contains(DEFAULT_COMMENT_START_CHARS) && AsmLexer.hasNonCommentHashUsages(buffer, startOffset, endOffset)) {
                String updatedCommentStartChars = commentStartChars.replace(DEFAULT_COMMENT_START_CHARS, "");
                lexer.setCommentStartChars(updatedCommentStartChars);
                this.myDetectNonCommentHashUsages = false;
            }
            this.myNonCommentHashUsagesSampleSize += endOffset - startOffset;
        }
    }

    private static boolean hasNonCommentHashUsages(@NotNull CharSequence buffer, int startOffset, int endOffset) {
        if (buffer == null) {
            AsmLexer.$$$reportNull$$$0(2);
        }
        int i = startOffset;
        while (i < endOffset) {
            char c = buffer.charAt(i);
            if (c == ';' || c == '/' && i > 0 && buffer.charAt(i - 1) == '/') {
                int endOfLine = StringUtil.indexOf((CharSequence)buffer, (char)'\n', (int)i);
                if (endOfLine == -1) break;
                i = endOfLine + 1;
                continue;
            }
            if (c == '*' && i > 0 && buffer.charAt(i - 1) == '/') {
                String blockCommentEnd = "*/";
                int endOfComment = StringUtil.indexOf((CharSequence)buffer, (CharSequence)blockCommentEnd, (int)i);
                if (endOfComment == -1) break;
                i = endOfComment + blockCommentEnd.length();
                continue;
            }
            if (c == '#' && AsmLexer.prevNonWhitespaceCharOnLine(buffer, i) == ',') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static char prevNonWhitespaceCharOnLine(@NotNull CharSequence buffer, int index) {
        char c;
        if (buffer == null) {
            AsmLexer.$$$reportNull$$$0(3);
        }
        for (int i = index - 1; i >= 0 && (c = buffer.charAt(i)) != '\n' && c != '\r'; --i) {
            if (Character.isWhitespace(c)) continue;
            return c;
        }
        return '\u0000';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentStartChars";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/asm/AsmLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonCommentHashUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prevNonWhitespaceCharOnLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

