/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.ToolContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ToolWindowDefinition<T> {
    public static final int DEFAULT_SIDE_WIDTH = JBUI.scale((int)225);
    public static final Dimension DEFAULT_BUTTON_SIZE = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
    public static final int ALLOW_BASICS = 0;
    public static final int ALLOW_FLOATING = 1;
    public static final int ALLOW_AUTO_HIDE = 2;
    public static final int ALLOW_SPLIT_MODE = 4;
    public static final int ALLOW_ALL = 7;
    private final String myTitle;
    private final Icon myIcon;
    private final String myName;
    private final Side mySide;
    private final Split mySplit;
    private final AutoHide myAutoHide;
    private final int myMinimumSize;
    private final Dimension myButtonSize;
    private final int myFeatures;
    private final Function<Disposable, ToolContent<T>> myFactory;
    private final boolean myShowGearAction;
    private final boolean myShowHideAction;
    private final boolean myOverrideSide;
    private final boolean myOverrideSplit;

    public ToolWindowDefinition(@NotNull String title, @NotNull Icon icon, @NotNull String name, @NotNull Side side, @NotNull Split split, @NotNull AutoHide autoHide, @NotNull Function<Disposable, ToolContent<T>> factory) {
        this(title, icon, name, side, split, autoHide, DEFAULT_SIDE_WIDTH, DEFAULT_BUTTON_SIZE, 5, true, true, false, false, factory);
    }

    public ToolWindowDefinition(@NotNull String title, @NotNull Icon icon, @NotNull String name, @NotNull Side side, @NotNull Split split, @NotNull AutoHide autoHide, int minimumSize, @NotNull Dimension buttonSize, int features, @NotNull Function<Disposable, ToolContent<T>> factory) {
        this(title, icon, name, side, split, autoHide, minimumSize, buttonSize, features, true, true, false, false, factory);
    }

    public ToolWindowDefinition(@NotNull String title, @NotNull Icon icon, @NotNull String name, @NotNull Side side, @NotNull Split split, @NotNull AutoHide autoHide, int minimumSize, @NotNull Dimension buttonSize, int features, boolean showGearAction, boolean showHideAction, boolean overrideSide, boolean overrideSplit, @NotNull Function<Disposable, ToolContent<T>> factory) {
        this.myTitle = title;
        this.myIcon = icon;
        this.myName = name;
        this.mySide = side;
        this.mySplit = split;
        this.myAutoHide = autoHide;
        this.myMinimumSize = minimumSize;
        this.myButtonSize = buttonSize;
        this.myFeatures = features;
        this.myFactory = factory;
        this.myShowGearAction = showGearAction;
        this.myShowHideAction = showHideAction;
        this.myOverrideSide = overrideSide;
        this.myOverrideSplit = overrideSplit;
    }

    @NotNull
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public Function<Disposable, ToolContent<T>> getFactory() {
        return this.myFactory;
    }

    public int getInitialMinimumWidth() {
        return this.myMinimumSize;
    }

    @NotNull
    public Dimension getButtonSize() {
        return this.myButtonSize;
    }

    public Side getSide() {
        return this.mySide;
    }

    public Split getSplit() {
        return this.mySplit;
    }

    public AutoHide getAutoHide() {
        return this.myAutoHide;
    }

    public boolean isFloatingAllowed() {
        return (this.myFeatures & 1) != 0;
    }

    public boolean isAutoHideAllowed() {
        return (this.myFeatures & 2) != 0;
    }

    public boolean isSplitModeChangesAllowed() {
        return (this.myFeatures & 4) != 0;
    }

    boolean showGearAction() {
        return this.myShowGearAction;
    }

    boolean showHideAction() {
        return this.myShowHideAction;
    }

    boolean overrideSide() {
        return this.myOverrideSide;
    }

    boolean overrideSplit() {
        return this.myOverrideSplit;
    }
}

