/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.validation;

import com.android.tools.adtui.validation.ErrorDetailDialog;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.validators.TrueValidator;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.SwingHelper;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class ValidatorPanel
extends JPanel
implements Disposable {
    private static final String BLANK_HTML = "<html></html>";
    private final ListenerManager myListeners = new ListenerManager();
    private final List<Validator.Result> myResults = new ArrayList<Validator.Result>();
    private final ObjectProperty<Validator.Result> myValidationResult = new ObjectValueProperty((Object)Validator.Result.OK);
    private final BooleanExpression myHasErrorsExpression = new BooleanExpression(new ObservableValue[]{this.myValidationResult}){

        @NotNull
        public Boolean get() {
            return ((Validator.Result)ValidatorPanel.this.myValidationResult.get()).getSeverity() == Validator.Severity.ERROR;
        }
    };
    private final boolean myHideOnSuccess;
    private JPanel myRootPanel;
    private JPanel mySouthPanel;
    private JBLabel mySeverityIcon;
    private JEditorPane myValidationText;
    private ErrorDetailDialog myErrorDetailDialog;

    public ValidatorPanel(@NotNull Disposable parentDisposable, @NotNull JComponent innerPanel, boolean hideOnSuccess, @NotNull String errorDetailDialogTitle, @NotNull String errorDetailHeader) {
        super(new BorderLayout());
        this.myHideOnSuccess = hideOnSuccess;
        this.setupUI();
        this.add(this.myRootPanel);
        this.myRootPanel.add(innerPanel);
        this.myValidationText.setName("ValidationText");
        this.myValidationText.setText(BLANK_HTML);
        this.myValidationText.addHyperlinkListener(event -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String detailedMessage = ((Validator.Result)this.myValidationResult.get()).getDetailedMessage();
                if (this.myErrorDetailDialog == null) {
                    this.myErrorDetailDialog = new ErrorDetailDialog(errorDetailDialogTitle, errorDetailHeader, detailedMessage);
                    Disposer.register((Disposable)this.myErrorDetailDialog.getDisposable(), () -> {
                        this.myErrorDetailDialog = null;
                    });
                    Disposer.register((Disposable)this, () -> {
                        if (this.myErrorDetailDialog != null) {
                            this.myErrorDetailDialog.close(1);
                        }
                    });
                    this.myErrorDetailDialog.show();
                } else {
                    this.myErrorDetailDialog.setText(detailedMessage);
                }
            }
        });
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public ValidatorPanel(@NotNull Disposable parentDisposable, @NotNull JComponent innerPanel, boolean hideOnSuccess) {
        this(parentDisposable, innerPanel, hideOnSuccess, "Errors", "Error Details:");
    }

    public ValidatorPanel(@NotNull Disposable parentDisposable, @NotNull JComponent innerPanel) {
        this(parentDisposable, innerPanel, false);
    }

    public <T> void registerValidator(@NotNull ObservableValue<T> value, @NotNull Validator<? super T> validator, ObservableValue<?> ... dependencies) {
        ArrayList triggerObjects = Lists.newArrayList((Object[])new ObservableValue[]{value});
        if (dependencies.length > 0) {
            triggerObjects.addAll(Arrays.asList(dependencies));
        }
        int index = this.myResults.size();
        this.myResults.add(Validator.Result.OK);
        this.myListeners.listenAll((Collection)triggerObjects).withAndFire(() -> {
            Validator.Result oldValue = this.myResults.get(index);
            Validator.Result newValue = validator.validate(value.get());
            if (!newValue.equals(oldValue)) {
                this.myResults.set(index, newValue);
                this.updateActiveValidationResult();
            }
        });
    }

    public void registerTest(@NotNull ObservableValue<Boolean> value, @NotNull Validator.Severity severity, @NotNull String message) {
        this.registerValidator(value, new TrueValidator(severity, message), new ObservableValue[0]);
    }

    public void registerTest(@NotNull ObservableValue<Boolean> value, @NotNull String message) {
        this.registerTest(value, Validator.Severity.ERROR, message);
    }

    public void registerMessageSource(@NotNull ObservableValue<String> message, @NotNull Validator.Severity severity) {
        this.registerValidator(message, value -> {
            if (value.isEmpty()) {
                return Validator.Result.OK;
            }
            return new Validator.Result(severity, (String)value);
        }, new ObservableValue[0]);
    }

    public void registerMessageSource(@NotNull ObservableValue<String> message) {
        this.registerMessageSource(message, Validator.Severity.ERROR);
    }

    @NotNull
    public ObservableBool hasErrors() {
        return this.myHasErrorsExpression;
    }

    @NotNull
    public ObservableValue<Validator.Result> getValidationResult() {
        return this.myValidationResult;
    }

    private void updateActiveValidationResult() {
        Validator.Result activeResult = Validator.Result.OK;
        for (Validator.Result result : this.myResults) {
            if (result.getSeverity().compareTo(activeResult.getSeverity()) > 0 && (activeResult = result).getSeverity() == Validator.Severity.ERROR) break;
        }
        if (activeResult.getSeverity() == Validator.Severity.OK) {
            this.mySeverityIcon.setIcon(null);
            this.myValidationText.setText(BLANK_HTML);
            if (this.myHideOnSuccess) {
                this.myRootPanel.remove(this.mySouthPanel);
                this.myRootPanel.revalidate();
            }
        } else {
            this.mySeverityIcon.setIcon(activeResult.getSeverity().getIcon());
            String message = activeResult.getMessage().trim();
            if (!XmlStringUtil.isWrappedInHtml((String)message)) {
                message = !StringUtil.isEmpty((String)activeResult.getDetailedMessage()) ? XmlStringUtil.wrapInHtml((CharSequence)("<a href=\"details\">" + ValidatorPanel.convertToHtml(message) + "</a>")) : XmlStringUtil.wrapInHtml((CharSequence)ValidatorPanel.convertToHtml(message));
            }
            this.myValidationText.setText(message);
            if (this.myHideOnSuccess) {
                this.myRootPanel.add((Component)this.mySouthPanel, "South");
                this.myRootPanel.revalidate();
            }
        }
        this.myValidationResult.set((Object)activeResult);
    }

    private void setupUI() {
        this.createUIComponents();
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout(new BorderLayout(0, 15));
        this.mySouthPanel = new JPanel();
        this.mySouthPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mySouthPanel.setMinimumSize(new Dimension(154, 32));
        this.mySouthPanel.setPreferredSize(new Dimension(154, 32));
        if (!this.myHideOnSuccess) {
            this.myRootPanel.add((Component)this.mySouthPanel, "South");
        }
        this.mySeverityIcon = new JBLabel();
        this.mySeverityIcon.setFocusable(false);
        this.mySeverityIcon.setIconTextGap(0);
        this.mySouthPanel.add((Component)this.mySeverityIcon, new GridConstraints(0, 0, 1, 1, 1, 0, 1, 0, null, null, null, 0, false));
        this.myValidationText.setBackground(new Color(-855310));
        this.myValidationText.setEditable(false);
        this.myValidationText.setFocusable(false);
        this.myValidationText.setMargin(new Insets(0, 0, 0, 0));
        this.myValidationText.setText("");
        this.mySouthPanel.add((Component)this.myValidationText, new GridConstraints(0, 1, 1, 1, 0, 3, 4, 0, null, null, null, 0, false));
    }

    public JComponent getRootComponent() {
        return this.myRootPanel;
    }

    @NotNull
    private static String convertToHtml(String message) {
        return StringUtil.replace((String)XmlStringUtil.escapeString((String)message), (String)"\n", (String)"<br>");
    }

    public void dispose() {
        this.myListeners.releaseAll();
    }

    @TestOnly
    @NotNull
    public JEditorPane getValidationText() {
        return this.myValidationText;
    }

    private void createUIComponents() {
        this.myValidationText = SwingHelper.createHtmlViewer((boolean)true, null, (Color)JBColor.WHITE, (Color)JBColor.BLACK);
        this.myValidationText.setOpaque(false);
        this.myValidationText.setFocusable(false);
        this.myValidationText.addHyperlinkListener(event -> {});
    }
}

