/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.android.tools.adtui.common.StudioColorsKt;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicPanelUI;

public class DesignSurfaceToolbarUI
extends BasicPanelUI {
    private static final int ARC_LENGTH = 5;
    private static final int BORDER_ARC_LENGTH = 8;
    private static final int BORDER_SIZE = 1;
    private static final JBColor DEFAULT_BORDER = JBColor.lightGray;

    @Override
    public void update(Graphics g, JComponent c) {
        Insets insets = c.getInsets();
        Dimension preferredSize = c.getPreferredSize();
        if (insets.left + insets.right == preferredSize.width && insets.top + insets.bottom == preferredSize.height) {
            return;
        }
        if (c.isOpaque()) {
            int width = c.getWidth();
            int height = c.getHeight();
            Graphics2D g2D = (Graphics2D)g.create();
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int borderArcLength = JBUI.scale((int)8);
            g2D.setColor((Color)DEFAULT_BORDER);
            g2D.fillRoundRect(0, 0, width, height, borderArcLength, borderArcLength);
            int borderSize = JBUI.scale((int)1);
            int backgroundArcLength = JBUI.scale((int)5);
            g2D.setColor((Color)StudioColorsKt.getPrimaryContentBackground());
            g2D.fillRoundRect(borderSize, borderSize, width - borderSize - borderSize, height - borderSize - borderSize, backgroundArcLength, backgroundArcLength);
            g2D.dispose();
        }
        this.paint(g, c);
    }

    public static JPanel createPanel(final JComponent c) {
        JPanel container = new JPanel(){

            @Override
            public void updateUI() {
                this.setUI(new DesignSurfaceToolbarUI());
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size = c.getPreferredSize();
                Insets insets = this.getInsets();
                return new Dimension(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom);
            }
        };
        container.setOpaque(true);
        container.setBorder(JBUI.Borders.empty((int)1));
        container.setBackground((Color)JBColor.white);
        container.add(c);
        return container;
    }
}

