/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.RangeScrollBarUI;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.adtui.stdui.TimelineScrollbarKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBScrollBar;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.plaf.ScrollBarUI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0007J\b\u0010\u0016\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/adtui/stdui/TimelineScrollbar;", "Lcom/intellij/ui/components/JBScrollBar;", "timeline", "Lcom/android/tools/adtui/model/Timeline;", "zoomPanComponent", "Ljavax/swing/JComponent;", "<init>", "(Lcom/android/tools/adtui/model/Timeline;Ljavax/swing/JComponent;)V", "getTimeline", "()Lcom/android/tools/adtui/model/Timeline;", "aspectObserver", "Lcom/android/tools/adtui/model/AspectObserver;", "updating", "", "checkStream", "modelChanged", "", "updateModel", "paintComponent", "g", "Ljava/awt/Graphics;", "isScrollable", "isCloseToMax", "StreamingScrollbarUi", "intellij.android.adt.ui"})
public final class TimelineScrollbar
extends JBScrollBar {
    @NotNull
    private final Timeline timeline;
    @NotNull
    private final AspectObserver aspectObserver;
    private boolean updating;
    private boolean checkStream;

    public TimelineScrollbar(@NotNull Timeline timeline, @NotNull JComponent zoomPanComponent) {
        Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
        Intrinsics.checkNotNullParameter((Object)zoomPanComponent, (String)"zoomPanComponent");
        super(0);
        this.timeline = timeline;
        this.aspectObserver = new AspectObserver();
        Function0 onChange = () -> TimelineScrollbar._init_$lambda$0(this);
        this.timeline.getViewRange().addDependency(this.aspectObserver).onChange((Enum)Range.Aspect.RANGE, () -> TimelineScrollbar._init_$lambda$1(onChange));
        this.timeline.getDataRange().addDependency(this.aspectObserver).onChange((Enum)Range.Aspect.RANGE, () -> TimelineScrollbar._init_$lambda$2(onChange));
        StreamingScrollbarUi scrollbarUi = new StreamingScrollbarUi();
        this.setUI((ScrollBarUI)((Object)scrollbarUi));
        this.addPropertyChangeListener(arg_0 -> TimelineScrollbar._init_$lambda$3(this, scrollbarUi, arg_0));
        this.addAdjustmentListener(arg_0 -> TimelineScrollbar._init_$lambda$4(this, arg_0));
        zoomPanComponent.addMouseWheelListener(arg_0 -> TimelineScrollbar._init_$lambda$5(this, arg_0));
        this.modelChanged();
    }

    @NotNull
    public final Timeline getTimeline() {
        return this.timeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void modelChanged() {
        try {
            this.updating = true;
            Range range = this.timeline.getDataRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getDataRange(...)");
            Range dataRangeUs = range;
            if (dataRangeUs.getMin() < dataRangeUs.getMax()) {
                Range range2 = this.timeline.getViewRange();
                Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getViewRange(...)");
                Range viewRangeUs = range2;
                int dataExtentMs = (int)(dataRangeUs.getLength() / (double)TimelineScrollbarKt.access$getMS_TO_US$p());
                int viewExtentMs = Math.min(dataExtentMs, (int)(viewRangeUs.getLength() / (double)TimelineScrollbarKt.access$getMS_TO_US$p()));
                int viewRelativeMinMs = Math.max(0, (int)((viewRangeUs.getMin() - dataRangeUs.getMin()) / (double)TimelineScrollbarKt.access$getMS_TO_US$p()));
                this.setValues(viewRelativeMinMs, viewExtentMs, 0, dataExtentMs);
                this.setBlockIncrement(viewExtentMs);
            } else {
                this.setValues(0, 0, 0, 0);
            }
        }
        finally {
            this.updating = false;
        }
    }

    private final void updateModel() {
        Timeline timeline = this.timeline;
        StreamingTimeline streamingTimeline = timeline instanceof StreamingTimeline ? (StreamingTimeline)timeline : null;
        if (streamingTimeline != null) {
            streamingTimeline.setStreaming(false);
        }
        Range range = this.timeline.getDataRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getDataRange(...)");
        Range dataRangeUs = range;
        Range range2 = this.timeline.getViewRange();
        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getViewRange(...)");
        Range viewRangeUs = range2;
        int valueMs = this.getValue();
        int viewRelativeMinMs = Math.max(0, (int)((viewRangeUs.getMin() - dataRangeUs.getMin()) / (double)TimelineScrollbarKt.access$getMS_TO_US$p()));
        double deltaUs = (long)(valueMs - viewRelativeMinMs) * TimelineScrollbarKt.access$getMS_TO_US$p();
        viewRangeUs.shift(deltaUs);
    }

    public void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (this.checkStream && this.timeline instanceof StreamingTimeline && !((StreamingTimeline)this.timeline).isStreaming() && this.isCloseToMax() && ((StreamingTimeline)this.timeline).canStream()) {
            ((StreamingTimeline)this.timeline).setStreaming(true);
        }
        this.checkStream = false;
    }

    @VisibleForTesting
    public final boolean isScrollable() {
        Range range = this.timeline.getViewRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getViewRange(...)");
        Range viewRange = range;
        Range range2 = this.timeline.getDataRange();
        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getDataRange(...)");
        Range dataRange = range2;
        return viewRange.getMin() >= dataRange.getMin() && viewRange.getMax() <= dataRange.getMax();
    }

    private final boolean isCloseToMax() {
        BoundedRangeModel model2 = this.getModel();
        float snapPercentage = 1.0f - 10.0f / (float)this.getWidth();
        return (float)(model2.getValue() + model2.getExtent()) / (float)model2.getMaximum() >= snapPercentage;
    }

    private static final Unit _init_$lambda$0(TimelineScrollbar this$0) {
        this$0.modelChanged();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void _init_$lambda$2(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void _init_$lambda$3(TimelineScrollbar this$0, StreamingScrollbarUi $scrollbarUi, PropertyChangeEvent it) {
        if (Intrinsics.areEqual((Object)it.getPropertyName(), (Object)"UI") && !(it.getNewValue() instanceof RangeScrollBarUI)) {
            this$0.setUI((ScrollBarUI)((Object)$scrollbarUi));
        }
    }

    private static final void _init_$lambda$4(TimelineScrollbar this$0, AdjustmentEvent it) {
        if (!this$0.updating) {
            this$0.updateModel();
            if (!it.getValueIsAdjusting()) {
                this$0.checkStream = true;
            }
        }
    }

    private static final void _init_$lambda$5(TimelineScrollbar this$0, MouseWheelEvent it) {
        double count = it.getPreciseWheelRotation();
        Intrinsics.checkNotNull((Object)it);
        boolean isMenuKeyDown = AdtUiUtils.isActionKeyDown(it);
        if (isMenuKeyDown) {
            double anchor = (double)it.getX() / (double)it.getComponent().getWidth();
            this$0.timeline.handleMouseWheelZoom(count, anchor);
        } else {
            this$0.timeline.handleMouseWheelPan(count);
        }
        this$0.checkStream = count > 0.0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/android/tools/adtui/stdui/TimelineScrollbar$StreamingScrollbarUi;", "Lcom/android/tools/adtui/RangeScrollBarUI;", "<init>", "(Lcom/android/tools/adtui/stdui/TimelineScrollbar;)V", "doPaintTrack", "", "g", "Ljava/awt/Graphics;", "c", "Ljavax/swing/JComponent;", "bounds", "Ljava/awt/Rectangle;", "intellij.android.adt.ui"})
    private final class StreamingScrollbarUi
    extends RangeScrollBarUI {
        protected void doPaintTrack(@NotNull Graphics g, @NotNull JComponent c, @NotNull Rectangle bounds) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            g.setColor(StandardColors.DEFAULT_CONTENT_BACKGROUND_COLOR);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }
}

