/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.model.stdui.CommonTextFieldModel;
import com.android.tools.adtui.model.stdui.EditingErrorCategory;
import com.android.tools.adtui.model.stdui.EditingSupportKt;
import com.android.tools.adtui.stdui.CommonTextBorder;
import com.android.tools.adtui.stdui.KeyBindingKt;
import com.android.tools.adtui.stdui.KeyStrokes;
import com.android.tools.adtui.stdui.Lookup;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.SwingUndoUtil;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0014J\b\u0010\u001c\u001a\u00020\u001aH\u0014J\u0006\u0010\u001d\u001a\u00020\rJ\u0006\u0010\u001e\u001a\u00020\rJ\u0006\u0010\u001f\u001a\u00020\rJ\b\u0010 \u001a\u00020\u001aH\u0002J\b\u0010!\u001a\u00020\u001aH\u0016J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0014J\u0012\u0010%\u001a\u00020\u001a2\b\u0010&\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u001aH\u0002J\b\u0010+\u001a\u00020\u001aH\u0002J\b\u0010,\u001a\u00020\u001aH\u0002J\n\u0010-\u001a\u0004\u0018\u00010.H\u0002R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lcom/android/tools/adtui/stdui/CommonTextField;", "M", "Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "Lcom/intellij/ui/components/JBTextField;", "editorModel", "<init>", "(Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;)V", "getEditorModel", "()Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "_lookup", "Lcom/android/tools/adtui/stdui/Lookup;", "updatingFromModel", "", "documentChangeFromSetText", "lastModelValue", "", "enableScrollInView", "getEnableScrollInView", "()Z", "setEnableScrollInView", "(Z)V", "lookup", "getLookup", "()Lcom/android/tools/adtui/stdui/Lookup;", "showLookupCompletions", "", "forText", "updateFromModel", "enterInLookup", "escapeInLookup", "isLookupEnabled", "setFromModel", "updateUI", "paintComponent", "g", "Ljava/awt/Graphics;", "setText", "text", "scrollRectToVisible", "r", "Ljava/awt/Rectangle;", "tab", "backTab", "updateOutline", "getComponentWithErrorBorder", "Ljavax/swing/JComponent;", "intellij.android.adt.ui"})
public class CommonTextField<M extends CommonTextFieldModel>
extends JBTextField {
    @NotNull
    private final M editorModel;
    @Nullable
    private Lookup<? extends M> _lookup;
    private boolean updatingFromModel;
    private boolean documentChangeFromSetText;
    @NotNull
    private String lastModelValue;
    private boolean enableScrollInView;

    public CommonTextField(@NotNull M editorModel) {
        Intrinsics.checkNotNullParameter(editorModel, (String)"editorModel");
        this.editorModel = editorModel;
        this.lastModelValue = "";
        this.enableScrollInView = true;
        if (!Intrinsics.areEqual(this.editorModel.getEditingSupport().getCompletion(), EditingSupportKt.EDITOR_NO_COMPLETIONS)) {
            final Lookup myLookup = new Lookup(this, null, 2, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonTextField._init_$lambda$0(this), KeyStrokes.INSTANCE.getENTER(), "enter", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonTextField._init_$lambda$1(this), KeyStrokes.INSTANCE.getESCAPE(), "escape", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonTextField._init_$lambda$2(this), KeyStrokes.INSTANCE.getTAB(), "tab", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonTextField._init_$lambda$3(this), KeyStrokes.INSTANCE.getBACKTAB(), "backTab", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonTextField._init_$lambda$4(this), KeyStrokes.INSTANCE.getCTRL_SPACE(), "showCompletions", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonTextField._init_$lambda$5(myLookup), KeyStrokes.INSTANCE.getDOWN(), "selectNext", () -> CommonTextField._init_$lambda$6(myLookup), 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonTextField._init_$lambda$7(myLookup), KeyStrokes.INSTANCE.getUP(), "selectPrevious", () -> CommonTextField._init_$lambda$8(myLookup), 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonTextField._init_$lambda$9(myLookup), KeyStrokes.INSTANCE.getPAGE_DOWN(), "selectNextPage", () -> CommonTextField._init_$lambda$10(myLookup), 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonTextField._init_$lambda$11(myLookup), KeyStrokes.INSTANCE.getPAGE_UP(), "selectPreviousPage", () -> CommonTextField._init_$lambda$12(myLookup), 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonTextField._init_$lambda$13(myLookup), KeyStrokes.INSTANCE.getCMD_HOME(), "selectFirst", () -> CommonTextField._init_$lambda$14(myLookup), 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonTextField._init_$lambda$15(myLookup), KeyStrokes.INSTANCE.getCMD_END(), "selectLast", () -> CommonTextField._init_$lambda$16(myLookup), 0, 16, null);
            this.setFocusTraversalKeysEnabled(false);
            super.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    myLookup.close();
                }
            });
            this._lookup = myLookup;
        }
        this.putClientProperty("StatusVisibleFunction", arg_0 -> CommonTextField._init_$lambda$17(this, arg_0));
        this.setFocusable(true);
        this.setFromModel();
        this.editorModel.addListener(() -> CommonTextField._init_$lambda$18(this));
        this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent event) {
                block3: {
                    block4: {
                        String newText;
                        block5: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            if (updatingFromModel) break block3;
                            newText = this.getText();
                            Object m = this.getEditorModel();
                            Intrinsics.checkNotNull((Object)newText);
                            m.setText(newText);
                            if (documentChangeFromSetText) break block4;
                            if (((CharSequence)newText).length() > 0) break block5;
                            Lookup lookup = this.getLookup();
                            boolean bl = lookup != null ? lookup.isVisible() : false;
                            if (!bl) break block4;
                        }
                        this.showLookupCompletions(newText);
                    }
                    this.updateOutline();
                }
            }
        });
    }

    @NotNull
    public final M getEditorModel() {
        return this.editorModel;
    }

    public final boolean getEnableScrollInView() {
        return this.enableScrollInView;
    }

    public final void setEnableScrollInView(boolean bl) {
        this.enableScrollInView = bl;
    }

    @Nullable
    public final Lookup<M> getLookup() {
        return this._lookup;
    }

    protected void showLookupCompletions(@NotNull String forText) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)forText, (String)"forText");
            Lookup<M> lookup = this.getLookup();
            if (lookup == null) break block0;
            lookup.showLookup(forText);
        }
    }

    protected void updateFromModel() {
        this.setFromModel();
    }

    public final boolean enterInLookup() {
        Lookup<M> lookup = this._lookup;
        return lookup != null ? lookup.enter() : false;
    }

    public final boolean escapeInLookup() {
        Lookup<M> lookup = this._lookup;
        return lookup != null ? lookup.escape() : false;
    }

    public final boolean isLookupEnabled() {
        Lookup<M> lookup = this._lookup;
        return lookup != null ? lookup.getEnabled() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void setFromModel() {
        this.updatingFromModel = true;
        try {
            if (this.hasFocus() && !Intrinsics.areEqual((Object)this.getText(), (Object)this.lastModelValue)) ** GOTO lbl-1000
            v0 = this._lookup;
            v1 = v0 != null ? v0.isVisible() : false;
            if (v1) lbl-1000:
            // 2 sources

            {
                v2 = this.getText();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getText(...)");
                this.editorModel.setText(v2);
            } else {
                this.lastModelValue = this.editorModel.getValue();
                this.setText(this.lastModelValue);
            }
            this.setEnabled(this.editorModel.getEnabled());
            this.setEditable(this.editorModel.getEditable());
            this.getEmptyText().setText(this.editorModel.getPlaceHolderValue());
            this.updateOutline();
        }
        finally {
            this.updatingFromModel = false;
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.getBorder() == null || this.getBorder() instanceof UIResource) {
            this.setBorder((Border)((Object)new CommonTextBorder()));
        }
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        boolean selectionVisible = this.getCaret().isSelectionVisible();
        this.getCaret().setSelectionVisible(true);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        super.paintComponent((Graphics)g2);
        this.getCaret().setSelectionVisible(selectionVisible);
        g2.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(@Nullable String text) {
        this.documentChangeFromSetText = true;
        try {
            if (!StringsKt.equals$default((String)text, (String)super.getText(), (boolean)false, (int)2, null)) {
                super.setText(text);
            }
            SwingUndoUtil.resetUndoRedoActions((JTextComponent)((JTextComponent)((Object)this)));
        }
        finally {
            this.documentChangeFromSetText = false;
        }
    }

    public void scrollRectToVisible(@NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (this.enableScrollInView) {
            super.scrollRectToVisible(r);
        }
    }

    private final void tab() {
        this.enterInLookup();
        this.transferFocus();
    }

    private final void backTab() {
        this.enterInLookup();
        this.transferFocusBackward();
    }

    private final void updateOutline() {
        EditingErrorCategory code;
        String newOutline;
        JComponent jComponent = this.getComponentWithErrorBorder();
        if (jComponent == null) {
            return;
        }
        JComponent component = jComponent;
        Object current = component.getClientProperty("JComponent.outline");
        if (!Intrinsics.areEqual((Object)current, (Object)(newOutline = (code = (EditingErrorCategory)((Object)((Pair)this.editorModel.getEditingSupport().getValidation().invoke((Object)this.getText())).component1())).getOutline()))) {
            component.putClientProperty("JComponent.outline", newOutline);
            component.repaint();
        }
    }

    private final JComponent getComponentWithErrorBorder() {
        JComponent component = (JComponent)((Object)this);
        while (component != null && !(component.getBorder() instanceof ErrorBorderCapable)) {
            Container container = component.getParent();
            component = container instanceof JComponent ? (JComponent)container : null;
        }
        return component;
    }

    private static final Unit _init_$lambda$0(CommonTextField this$0) {
        this$0.enterInLookup();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(CommonTextField this$0) {
        this$0.escapeInLookup();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(CommonTextField this$0) {
        this$0.tab();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(CommonTextField this$0) {
        this$0.backTab();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(CommonTextField this$0) {
        String string = this$0.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this$0.showLookupCompletions(string);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(Lookup $myLookup) {
        $myLookup.selectNext();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$6(Lookup $myLookup) {
        return $myLookup.getEnabled();
    }

    private static final Unit _init_$lambda$7(Lookup $myLookup) {
        $myLookup.selectPrevious();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$8(Lookup $myLookup) {
        return $myLookup.getEnabled();
    }

    private static final Unit _init_$lambda$9(Lookup $myLookup) {
        $myLookup.selectNextPage();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$10(Lookup $myLookup) {
        return $myLookup.getEnabled();
    }

    private static final Unit _init_$lambda$11(Lookup $myLookup) {
        $myLookup.selectPreviousPage();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$12(Lookup $myLookup) {
        return $myLookup.getEnabled();
    }

    private static final Unit _init_$lambda$13(Lookup $myLookup) {
        $myLookup.selectFirst();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$14(Lookup $myLookup) {
        return $myLookup.getEnabled();
    }

    private static final Unit _init_$lambda$15(Lookup $myLookup) {
        $myLookup.selectLast();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$16(Lookup $myLookup) {
        return $myLookup.getEnabled();
    }

    private static final boolean _init_$lambda$17(CommonTextField this$0, JTextComponent it) {
        String string = this$0.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((CharSequence)string).length() == 0;
    }

    private static final void _init_$lambda$18(CommonTextField this$0) {
        this$0.updateFromModel();
    }
}

