/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.jetbrains.annotations.NotNull;

public class UserCounterAxisFormatter
extends BaseAxisFormatter {
    public static final int DEFAULT_MAJOR_INTERVAL = 2;
    public static String[] LABELS = new String[]{"Light", "Medium", "Heavy"};
    public static final UserCounterAxisFormatter DEFAULT = new UserCounterAxisFormatter(1, LABELS.length, 1);

    private UserCounterAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold) {
        super(maxMinorTicks, maxMajorTicks, switchThreshold);
    }

    @Override
    @NotNull
    public String getFormattedString(double globalRange, double value, boolean includeUnit) {
        int index = (int)Math.ceil(value / (double)LABELS.length);
        if (index <= 0) {
            return "None";
        }
        if (index <= LABELS.length) {
            return LABELS[index - 1];
        }
        return LABELS[2];
    }

    @Override
    protected int getNumUnits() {
        return LABELS.length;
    }

    @Override
    @NotNull
    protected String getUnit(int index) {
        return index < LABELS.length ? LABELS[index] : "";
    }

    @Override
    protected int getUnitBase(int index) {
        return 1;
    }

    @Override
    protected int getUnitMultiplier(int index) {
        return 1;
    }

    @Override
    protected int getUnitMinimalInterval(int index) {
        return 1;
    }

    @Override
    @NotNull
    protected IntList getUnitBaseFactors(int index) {
        return new IntArrayList(0);
    }
}

