/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.text.DecimalFormat;
import java.util.function.DoubleToIntFunction;
import org.jetbrains.annotations.NotNull;

public abstract class BaseAxisFormatter {
    private final int mMaxMinorTicks;
    private final int mMaxMajorTicks;
    private final int mSwitchThreshold;
    private final boolean mHasSeparator;
    private final boolean mHasCommas;
    private final DoubleToIntFunction mMaxDecimals;

    protected BaseAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold, boolean hasSeparator, boolean hasCommas, DoubleToIntFunction maxDecimals) {
        this.mMaxMinorTicks = Math.max(1, maxMinorTicks);
        this.mMaxMajorTicks = Math.max(1, maxMajorTicks);
        this.mSwitchThreshold = switchThreshold;
        this.mHasSeparator = hasSeparator;
        this.mHasCommas = hasCommas;
        this.mMaxDecimals = maxDecimals;
    }

    protected BaseAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold, boolean hasSeparator, DoubleToIntFunction maxDecimals) {
        this(maxMinorTicks, maxMajorTicks, switchThreshold, hasSeparator, false, maxDecimals);
    }

    protected BaseAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold, boolean hasSeparator, boolean hasCommas) {
        this(maxMinorTicks, maxMajorTicks, switchThreshold, hasSeparator, hasCommas, n -> 1);
    }

    protected BaseAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold, boolean hasSeparator) {
        this(maxMinorTicks, maxMajorTicks, switchThreshold, hasSeparator, false);
    }

    protected BaseAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold) {
        this(maxMinorTicks, maxMajorTicks, switchThreshold, false);
    }

    @NotNull
    public String getFormattedString(double globalRange, double value, boolean includeUnit) {
        Multiplier multiplier = this.getMultiplier(globalRange, 1);
        double multipliedValue = value / (double)multiplier.accumulation;
        String wholeNumPattern = this.mHasCommas ? "#,###." : "#.";
        DecimalFormat decimalFormat = new DecimalFormat(wholeNumPattern + StringUtil.repeat((String)"#", (int)this.mMaxDecimals.applyAsInt(multipliedValue)));
        String formattedValue = decimalFormat.format(multipliedValue);
        if (!includeUnit) {
            return formattedValue;
        }
        String pattern = this.mHasSeparator ? "%s %s" : "%s%s";
        return String.format(pattern, formattedValue, this.getUnit(multiplier.index)).trim();
    }

    public long getMajorInterval(double range) {
        return this.getInterval(range, this.mMaxMajorTicks);
    }

    public long getMinorInterval(double range) {
        return this.getInterval(range, this.mMaxMinorTicks);
    }

    public long getInterval(double range, int numTicks) {
        Multiplier multiplier = this.getMultiplier(range, this.mSwitchThreshold);
        int base = this.getUnitBase(multiplier.index);
        int minInterval = this.getUnitMinimalInterval(multiplier.index);
        IntList factors = this.getUnitBaseFactors(multiplier.index);
        return (long)BaseAxisFormatter.getInterval(range / (double)multiplier.accumulation, numTicks, base, minInterval, factors) * multiplier.accumulation;
    }

    protected abstract int getNumUnits();

    @NotNull
    protected abstract String getUnit(int var1);

    protected abstract int getUnitBase(int var1);

    protected abstract int getUnitMultiplier(int var1);

    protected abstract int getUnitMinimalInterval(int var1);

    @NotNull
    protected abstract IntList getUnitBaseFactors(int var1);

    protected Multiplier getMultiplier(double value, int threshold) {
        long multiplier = 1L;
        int count = this.getNumUnits();
        for (int i = 0; i < count; ++i) {
            long temp = multiplier * (long)this.getUnitMultiplier(i);
            if (value < (double)(temp * (long)threshold)) {
                return new Multiplier(i, multiplier);
            }
            multiplier = temp;
        }
        return new Multiplier(count - 1, multiplier);
    }

    protected static int getInterval(double range, int maxTicks, int base, int minInterval, IntList baseFactors) {
        int power;
        int magnitude;
        double interval = Math.max((double)minInterval, range / (double)maxTicks);
        float multiplier = (float)Math.max(1.0, interval / (double)(magnitude = (int)Math.pow(base, power = (int)Math.floor(Math.log(interval) / Math.log(base)))));
        if (multiplier > 1.0f) {
            for (int i = 1; i < baseFactors.size(); ++i) {
                if (!(multiplier > (float)baseFactors.getInt(i))) continue;
                multiplier = baseFactors.getInt(i - 1);
                break;
            }
        }
        return (int)multiplier * magnitude;
    }

    @NotNull
    protected static IntList getMultiplierFactors(int base) {
        IntArrayList factors = new IntArrayList();
        while (base > 1) {
            int divider = 2;
            while (base % divider != 0) {
                if (++divider * divider <= base) continue;
                divider = base;
                break;
            }
            factors.add(base);
            base /= divider;
        }
        factors.add(1);
        return factors;
    }

    protected static class Multiplier {
        final int index;
        final long accumulation;

        Multiplier(int index, long accumulation) {
            this.index = index;
            this.accumulation = accumulation;
        }
    }
}

