/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import java.util.List;
import javax.swing.RowSorter;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0003H&J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H$J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH&J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0006\u0010\u001f\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\u0018J\u0006\u0010\"\u001a\u00020\u0018J\u000e\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0003R\u001e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006%"}, d2={"Lcom/android/tools/adtui/model/AbstractPaginatedTableModel;", "Ljavax/swing/table/AbstractTableModel;", "initialPageSize", "", "<init>", "(I)V", "value", "pageIndex", "getPageIndex", "()I", "pageSize", "getPageSize", "pageCount", "getPageCount", "isOnFirstPage", "", "()Z", "isOnLastPage", "getDataSize", "getDataValueAt", "", "dataIndex", "columnIndex", "sortData", "", "sortKeys", "", "Ljavax/swing/RowSorter$SortKey;", "getRowCount", "getValueAt", "rowIndex", "goToFirstPage", "goToLastPage", "goToPrevPage", "goToNextPage", "updatePageSize", "newPageSize", "intellij.android.adt.ui.model"})
@SourceDebugExtension(value={"SMAP\nAbstractPaginatedTableModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractPaginatedTableModel.kt\ncom/android/tools/adtui/model/AbstractPaginatedTableModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public abstract class AbstractPaginatedTableModel
extends AbstractTableModel {
    private int pageIndex;
    private int pageSize;

    public AbstractPaginatedTableModel(int initialPageSize) {
        if (!(initialPageSize > 0)) {
            boolean bl = false;
            String string = "Page size must be positive, was " + initialPageSize;
            throw new IllegalArgumentException(string.toString());
        }
        this.pageSize = initialPageSize;
    }

    public final int getPageIndex() {
        return this.pageIndex;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final int getPageCount() {
        return Math.max(1, (int)Math.ceil((double)this.getDataSize() / (double)this.pageSize));
    }

    public final boolean isOnFirstPage() {
        return this.pageIndex == 0;
    }

    public final boolean isOnLastPage() {
        return this.pageIndex == this.getPageCount() - 1;
    }

    public abstract int getDataSize();

    @NotNull
    protected abstract Object getDataValueAt(int var1, int var2);

    public abstract void sortData(@NotNull List<? extends RowSorter.SortKey> var1);

    @Override
    public int getRowCount() {
        return this.isOnLastPage() ? this.getDataSize() - this.pageSize * (this.getPageCount() - 1) : this.pageSize;
    }

    @Override
    @NotNull
    public Object getValueAt(int rowIndex, int columnIndex) {
        int dataIndex = rowIndex + this.pageIndex * this.pageSize;
        return this.getDataValueAt(dataIndex, columnIndex);
    }

    public final void goToFirstPage() {
        if (!this.isOnFirstPage()) {
            this.pageIndex = 0;
            this.fireTableDataChanged();
        }
    }

    public final void goToLastPage() {
        if (!this.isOnLastPage()) {
            this.pageIndex = this.getPageCount() - 1;
            this.fireTableDataChanged();
        }
    }

    public final void goToPrevPage() {
        if (!this.isOnFirstPage()) {
            this.pageIndex += -1;
            this.fireTableDataChanged();
        }
    }

    public final void goToNextPage() {
        if (!this.isOnLastPage()) {
            ++this.pageIndex;
            this.fireTableDataChanged();
        }
    }

    public final void updatePageSize(int newPageSize) {
        if (newPageSize != this.pageSize) {
            this.pageSize = newPageSize;
            this.pageIndex = 0;
            this.fireTableDataChanged();
        }
    }
}

