/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.event;

import java.awt.Container;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NestedScrollPaneMouseWheelListener
implements MouseWheelListener {
    @NotNull
    private final JScrollPane myScrollPane;
    @Nullable
    private JScrollPane myParentScrollPane;

    public static void installOn(@NotNull JScrollPane scrollPane) {
        scrollPane.setVerticalScrollBarPolicy(21);
        scrollPane.addMouseWheelListener(new NestedScrollPaneMouseWheelListener(scrollPane));
    }

    private NestedScrollPaneMouseWheelListener(@NotNull JScrollPane scrollPane) {
        this.myScrollPane = scrollPane;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.setParentScrollPane();
        if (this.myParentScrollPane == null) {
            this.myScrollPane.removeMouseWheelListener(this);
            return;
        }
        this.myParentScrollPane.dispatchEvent(SwingUtilities.convertMouseEvent(this.myScrollPane, e, this.myParentScrollPane));
    }

    private void setParentScrollPane() {
        if (this.myParentScrollPane == null) {
            Container parent;
            for (parent = this.myScrollPane.getParent(); parent != null && !(parent instanceof JScrollPane); parent = parent.getParent()) {
            }
            this.myParentScrollPane = (JScrollPane)parent;
        }
    }
}

