/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.device;

import com.android.annotations.concurrency.Slow;
import com.android.io.Images;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.device.AnchorPoint;
import com.android.tools.adtui.device.AnchoredImage;
import com.android.tools.adtui.device.ImageTransformer;
import com.android.tools.adtui.device.InvalidSkinException;
import com.android.tools.adtui.device.SkinButton;
import com.android.tools.adtui.device.SkinLayout;
import com.android.tools.adtui.device.SkinLayoutDefinition;
import com.android.tools.adtui.util.AwtUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00152\u00020\u0001:\u0005\u0011\u0012\u0013\u0014\u0015B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/adtui/device/SkinDefinition;", "", "layout", "Lcom/android/tools/adtui/device/SkinLayout;", "<init>", "(Lcom/android/tools/adtui/device/SkinLayout;)V", "getLayout", "()Lcom/android/tools/adtui/device/SkinLayout;", "createScaledLayout", "displayWidth", "", "displayHeight", "displayOrientationQuadrants", "getRotatedFrameSize", "Ljava/awt/Dimension;", "displayRotationQuadrants", "displaySize", "LayoutDescriptor", "Part", "ButtonDescriptor", "ImageLoader", "Companion", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nSkinDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinDefinition.kt\ncom/android/tools/adtui/device/SkinDefinition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,672:1\n1617#2,9:673\n1869#2:682\n1870#2:684\n1626#2:685\n1617#2,9:686\n1869#2:695\n1870#2:697\n1626#2:698\n1617#2,9:699\n1869#2:708\n1870#2:711\n1626#2:712\n1#3:683\n1#3:696\n1#3:709\n1#3:710\n*S KotlinDebug\n*F\n+ 1 SkinDefinition.kt\ncom/android/tools/adtui/device/SkinDefinition\n*L\n89#1:673,9\n89#1:682\n89#1:684\n89#1:685\n90#1:686,9\n90#1:695\n90#1:697\n90#1:698\n92#1:699,9\n92#1:708\n92#1:711\n92#1:712\n89#1:683\n90#1:696\n92#1:710\n*E\n"})
public final class SkinDefinition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SkinLayout layout;

    private SkinDefinition(SkinLayout layout) {
        this.layout = layout;
    }

    @NotNull
    public final SkinLayout getLayout() {
        return this.layout;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SkinLayout createScaledLayout(int displayWidth, int displayHeight, int displayOrientationQuadrants) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv3;
        if (displayOrientationQuadrants == 0 && displayWidth == this.layout.getDisplaySize().width && displayHeight == this.layout.getDisplaySize().height) {
            return this.layout;
        }
        Rectangle rotatedFrameRect = SkinDefinition.Companion.rotatedByQuadrants(this.layout.getFrameRectangle(), displayOrientationQuadrants, this.layout.getDisplaySize());
        Dimension rotatedDisplaySize = AwtUtilsKt.rotatedByQuadrants(this.layout.getDisplaySize(), displayOrientationQuadrants);
        Dimension rotatedDisplayCornerSize = AwtUtilsKt.rotatedByQuadrants(this.layout.getDisplayCornerSize(), displayOrientationQuadrants);
        double scaleX = (double)displayWidth / (double)rotatedDisplaySize.width;
        double scaleY = (double)displayHeight / (double)rotatedDisplaySize.height;
        int displayCornerWidth = AwtUtilsKt.scaled(rotatedDisplayCornerSize.width, scaleX);
        int displayCornerHeight = AwtUtilsKt.scaled(rotatedDisplayCornerSize.height, scaleY);
        int frameX = AwtUtilsKt.scaled(rotatedFrameRect.x, scaleX);
        int frameY = AwtUtilsKt.scaled(rotatedFrameRect.y, scaleY);
        int frameWidth = -frameX + displayWidth + AwtUtilsKt.scaled(SkinDefinition.Companion.getRight(rotatedFrameRect) - rotatedDisplaySize.width, scaleX);
        int frameHeight = -frameY + displayHeight + AwtUtilsKt.scaled(SkinDefinition.Companion.getBottom(rotatedFrameRect) - rotatedDisplaySize.height, scaleY);
        Rectangle frameRect = new Rectangle(frameX, frameY, frameWidth, frameHeight);
        ImageTransformer imageTransformer = new ImageTransformer(displayOrientationQuadrants, scaleX, scaleY);
        Iterable $this$mapNotNull$iv = this.layout.getFrameImages();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<AnchoredImage> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            AnchoredImage it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            AnchoredImage it = (AnchoredImage)element$iv$iv;
            boolean bl2 = false;
            if (it.rotatedAndScaled$intellij_android_adt_ui(imageTransformer) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List frameImages = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv2 = this.layout.getMaskImages();
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Iterable<AnchoredImage> destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            AnchoredImage it$iv$iv;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl = false;
            AnchoredImage it = (AnchoredImage)element$iv$iv;
            boolean bl4 = false;
            if (it.rotatedAndScaled$intellij_android_adt_ui(imageTransformer) == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List maskImages = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        Iterable $this$mapNotNull$iv3 = this.layout.getButtons();
        boolean $i$f$mapNotNull3 = false;
        destination$iv$iv2 = $this$mapNotNull$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator = $this$forEach$iv$iv$iv3.iterator();
        while (iterator.hasNext()) {
            SkinButton skinButton;
            Object element$iv$iv$iv4;
            Object element$iv$iv = element$iv$iv$iv4 = iterator.next();
            boolean bl = false;
            SkinButton it = (SkinButton)element$iv$iv;
            boolean bl6 = false;
            if (it.getImage().rotatedAndScaled$intellij_android_adt_ui(imageTransformer) != null) {
                AnchoredImage image;
                boolean bl7 = false;
                skinButton = new SkinButton(it.getKeyName(), image);
            } else {
                skinButton = null;
            }
            if (skinButton == null) continue;
            SkinButton it$iv$iv = skinButton;
            boolean bl8 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List buttons = (List)destination$iv$iv3;
        return new SkinLayout(new Dimension(displayWidth, displayHeight), new Dimension(displayCornerWidth, displayCornerHeight), frameRect, frameImages, maskImages, buttons);
    }

    @NotNull
    public final Dimension getRotatedFrameSize(int displayRotationQuadrants, @NotNull Dimension displaySize) {
        Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
        double scaleX = displaySize.getWidth() / this.layout.getDisplaySize().getWidth();
        double scaleY = displaySize.getHeight() / this.layout.getDisplaySize().getHeight();
        Rectangle frameRect = this.layout.getFrameRectangle();
        Dimension size = scaleX == 1.0 && scaleY == 1.0 ? frameRect.getSize() : new Dimension(-AwtUtilsKt.scaled(frameRect.x, scaleX) + displaySize.width + AwtUtilsKt.scaled(SkinDefinition.Companion.getRight(frameRect) - this.layout.getDisplaySize().width, scaleX), -AwtUtilsKt.scaled(frameRect.y, scaleY) + displaySize.height + AwtUtilsKt.scaled(SkinDefinition.Companion.getBottom(frameRect) - this.layout.getDisplaySize().height, scaleY));
        Intrinsics.checkNotNull((Object)size);
        return AwtUtilsKt.rotatedByQuadrants(size, displayRotationQuadrants);
    }

    public static /* synthetic */ Dimension getRotatedFrameSize$default(SkinDefinition skinDefinition, int n, Dimension dimension, int n2, Object object) {
        if ((n2 & 2) != 0) {
            dimension = skinDefinition.layout.getDisplaySize();
        }
        return skinDefinition.getRotatedFrameSize(n, dimension);
    }

    @Slow
    @JvmStatic
    @Nullable
    public static final SkinDefinition createOrNull(@NotNull Path skinFolder) {
        return Companion.createOrNull(skinFolder);
    }

    @Slow
    @JvmStatic
    @NotNull
    public static final SkinDefinition create(@NotNull Path skinFolder) throws IOException, InvalidSkinException {
        return Companion.create(skinFolder);
    }

    @Slow
    @JvmStatic
    @NotNull
    public static final Dimension getSkinDisplaySize(@NotNull Path skinFolder) throws IOException, InvalidSkinException {
        return Companion.getSkinDisplaySize(skinFolder);
    }

    @Slow
    @JvmStatic
    private static final LayoutDescriptor createLayoutDescriptor(Path skinFolder) throws IOException, InvalidSkinException {
        return SkinDefinition.Companion.createLayoutDescriptor(skinFolder);
    }

    @JvmStatic
    private static final Rectangle rotatedByQuadrants(Rectangle $this$rotatedByQuadrants, int rotation, Dimension displaySize) {
        return SkinDefinition.Companion.rotatedByQuadrants($this$rotatedByQuadrants, rotation, displaySize);
    }

    @JvmStatic
    private static final Part createPart(SkinLayoutDefinition partNode, Path skinFolder) {
        return SkinDefinition.Companion.createPart(partNode, skinFolder);
    }

    @JvmStatic
    private static final Path getReferencedFile(SkinLayoutDefinition node, String propertyName, Path skinFolder) {
        return SkinDefinition.Companion.getReferencedFile(node, propertyName, skinFolder);
    }

    @JvmStatic
    private static final boolean isTransparentNearCenterOfDisplay(BufferedImage image, Dimension displaySize, Rectangle frameRectangle) {
        return SkinDefinition.Companion.isTransparentNearCenterOfDisplay(image, displaySize, frameRectangle);
    }

    @JvmStatic
    private static final List<AnchoredImage> disassembleFrame(BufferedImage background, Rectangle frameRectangle, Dimension displaySize) {
        return SkinDefinition.Companion.disassembleFrame(background, frameRectangle, displaySize);
    }

    @JvmStatic
    private static final List<AnchoredImage> disassembleMask(BufferedImage mask, Dimension displaySize) {
        return SkinDefinition.Companion.disassembleMask(mask, displaySize);
    }

    @JvmStatic
    private static final Sequence<Rectangle> cutHorizontally(BufferedImage image, Rectangle cropBounds) {
        return SkinDefinition.Companion.cutHorizontally(image, cropBounds);
    }

    @JvmStatic
    private static final Sequence<Rectangle> cutVertically(BufferedImage image, Rectangle cropBounds) {
        return SkinDefinition.Companion.cutVertically(image, cropBounds);
    }

    @JvmStatic
    private static final boolean isTransparentHorizontalLine(BufferedImage image, int startX, int endX, int y) {
        return SkinDefinition.Companion.isTransparentHorizontalLine(image, startX, endX, y);
    }

    @JvmStatic
    private static final boolean isTransparentVerticalLine(BufferedImage image, int x, int startY, int endY) {
        return SkinDefinition.Companion.isTransparentVerticalLine(image, x, startY, endY);
    }

    @JvmStatic
    private static final AnchoredImage createAnchoredImage(BufferedImage mask, Rectangle cropBounds, Dimension displaySize) {
        return SkinDefinition.Companion.createAnchoredImage(mask, cropBounds, displaySize);
    }

    @JvmStatic
    private static final Rectangle computeAdjustedFrameRectangle(Iterable<AnchoredImage> backgroundImages, Dimension displaySize) {
        return SkinDefinition.Companion.computeAdjustedFrameRectangle(backgroundImages, displaySize);
    }

    @JvmStatic
    private static final BufferedImage cropped(BufferedImage $this$cropped, Rectangle cropBounds) {
        return SkinDefinition.Companion.cropped($this$cropped, cropBounds);
    }

    @JvmStatic
    private static final Rectangle getCropBounds(BufferedImage image, Rectangle initialCrop) {
        return SkinDefinition.Companion.getCropBounds(image, initialCrop);
    }

    private static final int getRight(Rectangle $this$getRight) {
        return SkinDefinition.Companion.getRight($this$getRight);
    }

    private static final int getBottom(Rectangle $this$getBottom) {
        return SkinDefinition.Companion.getBottom($this$getBottom);
    }

    @JvmStatic
    @TestOnly
    @Nullable
    public static final Path getBackgroundImageFile$intellij_android_adt_ui(@NotNull Path skinFolder) {
        return Companion.getBackgroundImageFile$intellij_android_adt_ui(skinFolder);
    }

    public /* synthetic */ SkinDefinition(SkinLayout layout, DefaultConstructorMarker $constructor_marker) {
        this(layout);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/adtui/device/SkinDefinition$ButtonDescriptor;", "", "keyName", "", "offset", "Ljava/awt/Point;", "imageFile", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/awt/Point;Ljava/nio/file/Path;)V", "getKeyName", "()Ljava/lang/String;", "getOffset", "()Ljava/awt/Point;", "getImageFile", "()Ljava/nio/file/Path;", "createButton", "Lcom/android/tools/adtui/device/SkinButton;", "imageLoader", "Lcom/android/tools/adtui/device/SkinDefinition$ImageLoader;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.adt.ui"})
    private static final class ButtonDescriptor {
        @NotNull
        private final String keyName;
        @NotNull
        private final Point offset;
        @NotNull
        private final Path imageFile;

        public ButtonDescriptor(@NotNull String keyName, @NotNull Point offset, @NotNull Path imageFile) {
            Intrinsics.checkNotNullParameter((Object)keyName, (String)"keyName");
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            Intrinsics.checkNotNullParameter((Object)imageFile, (String)"imageFile");
            this.keyName = keyName;
            this.offset = offset;
            this.imageFile = imageFile;
        }

        @NotNull
        public final String getKeyName() {
            return this.keyName;
        }

        @NotNull
        public final Point getOffset() {
            return this.offset;
        }

        @NotNull
        public final Path getImageFile() {
            return this.imageFile;
        }

        @Nullable
        public final SkinButton createButton(@NotNull ImageLoader imageLoader) {
            Intrinsics.checkNotNullParameter((Object)imageLoader, (String)"imageLoader");
            BufferedImage bufferedImage = imageLoader.loadImage(this.imageFile);
            if (bufferedImage == null) {
                return null;
            }
            BufferedImage image = bufferedImage;
            AnchoredImage anchoredImage = new AnchoredImage(image, new Dimension(image.getWidth(), image.getHeight()), AnchorPoint.TOP_LEFT, this.offset);
            return new SkinButton(this.keyName, anchoredImage);
        }

        @NotNull
        public final String component1() {
            return this.keyName;
        }

        @NotNull
        public final Point component2() {
            return this.offset;
        }

        @NotNull
        public final Path component3() {
            return this.imageFile;
        }

        @NotNull
        public final ButtonDescriptor copy(@NotNull String keyName, @NotNull Point offset, @NotNull Path imageFile) {
            Intrinsics.checkNotNullParameter((Object)keyName, (String)"keyName");
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            Intrinsics.checkNotNullParameter((Object)imageFile, (String)"imageFile");
            return new ButtonDescriptor(keyName, offset, imageFile);
        }

        public static /* synthetic */ ButtonDescriptor copy$default(ButtonDescriptor buttonDescriptor, String string, Point point, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                string = buttonDescriptor.keyName;
            }
            if ((n & 2) != 0) {
                point = buttonDescriptor.offset;
            }
            if ((n & 4) != 0) {
                path = buttonDescriptor.imageFile;
            }
            return buttonDescriptor.copy(string, point, path);
        }

        @NotNull
        public String toString() {
            return "ButtonDescriptor(keyName=" + this.keyName + ", offset=" + this.offset + ", imageFile=" + this.imageFile + ")";
        }

        public int hashCode() {
            int result = this.keyName.hashCode();
            result = result * 31 + this.offset.hashCode();
            result = result * 31 + ((Object)this.imageFile).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ButtonDescriptor)) {
                return false;
            }
            ButtonDescriptor buttonDescriptor = (ButtonDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.keyName, (Object)buttonDescriptor.keyName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.offset, (Object)buttonDescriptor.offset)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.imageFile, (Object)buttonDescriptor.imageFile);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u001c\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u001c\u0010\r\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0003J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000eH\u0003J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\nH\u0003J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\nH\u0003J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0&2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u000eH\u0003J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0&2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u000eH\u0003J(\u0010)\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0010H\u0003J(\u0010-\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u0010H\u0003J \u00101\u001a\u00020!2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\nH\u0003J\u001e\u00102\u001a\u00020\u000e2\f\u00103\u001a\b\u0012\u0004\u0012\u00020!042\u0006\u0010\u0011\u001a\u00020\nH\u0003J\u0014\u00105\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010'\u001a\u00020\u000eH\u0003J\u001c\u00106\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u00107\u001a\u0004\u0018\u00010\u000eH\u0003J\u0017\u0010@\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\bAR\u001e\u00108\u001a\u00020\u0010*\u00020\u000e8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b9\u0010:\u001a\u0004\b;\u0010<R\u001e\u0010=\u001a\u00020\u0010*\u00020\u000e8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b>\u0010:\u001a\u0004\b?\u0010<\u00a8\u0006B"}, d2={"Lcom/android/tools/adtui/device/SkinDefinition$Companion;", "", "<init>", "()V", "createOrNull", "Lcom/android/tools/adtui/device/SkinDefinition;", "skinFolder", "Ljava/nio/file/Path;", "create", "getSkinDisplaySize", "Ljava/awt/Dimension;", "createLayoutDescriptor", "Lcom/android/tools/adtui/device/SkinDefinition$LayoutDescriptor;", "rotatedByQuadrants", "Ljava/awt/Rectangle;", "rotation", "", "displaySize", "createPart", "Lcom/android/tools/adtui/device/SkinDefinition$Part;", "partNode", "Lcom/android/tools/adtui/device/SkinLayoutDefinition;", "getReferencedFile", "node", "propertyName", "", "isTransparentNearCenterOfDisplay", "", "image", "Ljava/awt/image/BufferedImage;", "frameRectangle", "disassembleFrame", "", "Lcom/android/tools/adtui/device/AnchoredImage;", "background", "disassembleMask", "mask", "cutHorizontally", "Lkotlin/sequences/Sequence;", "cropBounds", "cutVertically", "isTransparentHorizontalLine", "startX", "endX", "y", "isTransparentVerticalLine", "x", "startY", "endY", "createAnchoredImage", "computeAdjustedFrameRectangle", "backgroundImages", "", "cropped", "getCropBounds", "initialCrop", "right", "getRight$annotations", "(Ljava/awt/Rectangle;)V", "getRight", "(Ljava/awt/Rectangle;)I", "bottom", "getBottom$annotations", "getBottom", "getBackgroundImageFile", "getBackgroundImageFile$intellij_android_adt_ui", "intellij.android.adt.ui"})
    @SourceDebugExtension(value={"SMAP\nSkinDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinDefinition.kt\ncom/android/tools/adtui/device/SkinDefinition$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,672:1\n24#2:673\n24#2:674\n24#2:675\n*S KotlinDebug\n*F\n+ 1 SkinDefinition.kt\ncom/android/tools/adtui/device/SkinDefinition$Companion\n*L\n251#1:673\n253#1:674\n255#1:675\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Slow
        @JvmStatic
        @Nullable
        public final SkinDefinition createOrNull(@NotNull Path skinFolder) {
            Intrinsics.checkNotNullParameter((Object)skinFolder, (String)"skinFolder");
            try {
                return this.create(skinFolder);
            }
            catch (NoSuchFileException e) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("File not found: " + e.getFile());
            }
            catch (IOException e) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error((Throwable)e);
            }
            catch (InvalidSkinException e) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(e.getMessage());
            }
            return null;
        }

        @Slow
        @JvmStatic
        @NotNull
        public final SkinDefinition create(@NotNull Path skinFolder) throws IOException, InvalidSkinException {
            Intrinsics.checkNotNullParameter((Object)skinFolder, (String)"skinFolder");
            LayoutDescriptor layoutDescriptor = this.createLayoutDescriptor(skinFolder);
            return new SkinDefinition(layoutDescriptor.createLayout(), null);
        }

        @Slow
        @JvmStatic
        @NotNull
        public final Dimension getSkinDisplaySize(@NotNull Path skinFolder) throws IOException, InvalidSkinException {
            Intrinsics.checkNotNullParameter((Object)skinFolder, (String)"skinFolder");
            return this.createLayoutDescriptor(skinFolder).getDisplaySize();
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Slow
        @JvmStatic
        private final LayoutDescriptor createLayoutDescriptor(Path skinFolder) throws IOException, InvalidSkinException {
            layoutFile = skinFolder.resolve("layout");
            v0 = Files.readAllBytes(layoutFile);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"readAllBytes(...)");
            var4_3 = v0;
            v1 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"UTF_8");
            var5_4 = v1;
            contents = new String(var4_3, var5_4);
            v2 = SkinLayoutDefinition.parseString(contents);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"parseString(...)");
            skin = v2;
            displayWidth = 0;
            displayHeight = 0;
            cornerRadius = 0;
            partsByName = new LinkedHashMap<K, V>();
            v3 = skin.getNode("parts");
            if (v3 == null || (v3 = v3.getChildren()) == null) {
                throw new InvalidSkinException("Missing \"parts\" element");
            }
            partNodes = v3;
            block6: for (Object var11_12 : partNodes.entrySet()) {
                block16: {
                    name = (String)var11_12.getKey();
                    node = (SkinLayoutDefinition)var11_12.getValue();
                    var14_16 = name;
                    if (var14_16 == null) break block16;
                    switch (var14_16.hashCode()) {
                        case -566933834: {
                            if (var14_16.equals("controls")) continue block6;
                            break;
                        }
                        case 105892297: {
                            if (var14_16.equals("onion")) continue block6;
                            break;
                        }
                        case -1335157162: {
                            if (!var14_16.equals("device")) {
                                break;
                            }
                            ** GOTO lbl38
                        }
                        case -314765822: {
                            if (!var14_16.equals("primary")) break;
lbl38:
                            // 2 sources

                            if (displayWidth != 0 && displayHeight != 0) break;
                            v4 = node.getValue("display.width");
                            displayWidth = v4 != null ? Integer.parseInt(v4) : 0;
                            v5 = node.getValue("display.height");
                            displayHeight = v5 != null ? Integer.parseInt(v5) : 0;
                            v6 = node.getValue("display.corner_radius");
                            cornerRadius = v6 != null ? Integer.parseInt(v6) : 0;
                            break;
                        }
                    }
                }
                Intrinsics.checkNotNull((Object)node);
                partsByName.put(name, this.createPart(node, skinFolder));
            }
            if (displayWidth == 0 || displayHeight == 0) {
                throw new InvalidSkinException("Missing or invalid display dimensions");
            }
            v7 = skin.getNode("layouts");
            if (v7 == null || (v7 = v7.getChildren()) == null) {
                throw new InvalidSkinException("Missing \"layouts\" element");
            }
            layoutNodes = v7;
            block7: for (SkinLayoutDefinition layoutNode : layoutNodes.values()) {
                v8 = layoutNode.getValue("width");
                if (v8 == null) {
                    continue;
                }
                width = Integer.parseInt(v8);
                v9 = layoutNode.getValue("height");
                if (v9 == null) {
                    continue;
                }
                height = Integer.parseInt(v9);
                part = null;
                frameX = 0;
                frameY = 0;
                partX = 0;
                partY = 0;
                for (SkinLayoutDefinition subnode : layoutNode.getChildren().values()) {
                    v10 = subnode.getValue("x");
                    x = v10 != null ? Integer.parseInt(v10) : 0;
                    v11 = subnode.getValue("y");
                    v12 = y = v11 != null ? Integer.parseInt(v11) : 0;
                    if (subnode.getValue("name") == null) continue;
                    if (Intrinsics.areEqual((Object)name, (Object)"device") || Intrinsics.areEqual((Object)name, (Object)"primary")) {
                        v13 = subnode.getValue("rotation");
                        v14 = rotation = v13 != null ? Integer.parseInt(v13) : 0;
                        if (rotation != 0) continue block7;
                        frameX = -x;
                        frameY = -y;
                        continue;
                    }
                    if (part != null || (part = (Part)partsByName.get(name)) == null) continue;
                    partX = x;
                    partY = y;
                }
                if (part == null) continue;
                frameRectangle = new Rectangle(frameX + partX, frameY + partY, width, height);
                return new LayoutDescriptor(new Dimension(displayWidth, displayHeight), cornerRadius, frameRectangle, part);
            }
            throw new InvalidSkinException("Missing \"device\" part");
        }

        @JvmStatic
        private final Rectangle rotatedByQuadrants(Rectangle $this$rotatedByQuadrants, int rotation, Dimension displaySize) {
            return switch (rotation) {
                case 1 -> new Rectangle($this$rotatedByQuadrants.y, displaySize.width - $this$rotatedByQuadrants.width - $this$rotatedByQuadrants.x, $this$rotatedByQuadrants.height, $this$rotatedByQuadrants.width);
                case 2 -> new Rectangle(displaySize.width - $this$rotatedByQuadrants.width - $this$rotatedByQuadrants.x, displaySize.height - $this$rotatedByQuadrants.height - $this$rotatedByQuadrants.y, $this$rotatedByQuadrants.width, $this$rotatedByQuadrants.height);
                case 3 -> new Rectangle(displaySize.height - $this$rotatedByQuadrants.height - $this$rotatedByQuadrants.y, $this$rotatedByQuadrants.x, $this$rotatedByQuadrants.height, $this$rotatedByQuadrants.width);
                default -> $this$rotatedByQuadrants;
            };
        }

        @JvmStatic
        private final Part createPart(SkinLayoutDefinition partNode, Path skinFolder) {
            List buttons;
            Path mask;
            Path background;
            block28: {
                background = this.getReferencedFile(partNode, "background.image", skinFolder);
                mask = this.getReferencedFile(partNode, "foreground.mask", skinFolder);
                buttons = new ArrayList();
                SkinLayoutDefinition buttonsNode = partNode.getNode("buttons");
                if (buttonsNode == null) break block28;
                Map<String, SkinLayoutDefinition> map2 = buttonsNode.getChildren();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"getChildren(...)");
                block18: for (Map.Entry<String, SkinLayoutDefinition> entry2 : map2.entrySet()) {
                    Path imageFile;
                    String string;
                    String buttonName = entry2.getKey();
                    SkinLayoutDefinition node = entry2.getValue();
                    String string2 = buttonName;
                    if (string2 == null) continue;
                    int n = -1;
                    switch (string2.hashCode()) {
                        case -2118461494: {
                            if (string2.equals("soft-left")) {
                                n = 1;
                            }
                            break;
                        }
                        case -921387147: {
                            if (string2.equals("volume-down")) {
                                n = 2;
                            }
                            break;
                        }
                        case -906336856: {
                            if (string2.equals("search")) {
                                n = 3;
                            }
                            break;
                        }
                        case 3015911: {
                            if (string2.equals("back")) {
                                n = 4;
                            }
                            break;
                        }
                        case -2128330194: {
                            if (string2.equals("volume-up")) {
                                n = 5;
                            }
                            break;
                        }
                        case 106858757: {
                            if (string2.equals("power")) {
                                n = 6;
                            }
                            break;
                        }
                        case 3208415: {
                            if (string2.equals("home")) {
                                n = 7;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 4: {
                            string = "GoBack";
                            break;
                        }
                        case 7: {
                            string = "GoHome";
                            break;
                        }
                        case 6: {
                            string = "Power";
                            break;
                        }
                        case 3: {
                            string = "Search";
                            break;
                        }
                        case 1: {
                            string = "Menu";
                            break;
                        }
                        case 2: {
                            string = "AudioVolumeDown";
                            break;
                        }
                        case 5: {
                            string = "AudioVolumeUp";
                            break;
                        }
                        default: {
                            continue block18;
                        }
                    }
                    String keyName = string;
                    String string3 = node.getValue("x");
                    if (string3 == null) {
                        continue;
                    }
                    int x = Integer.parseInt(string3);
                    String string4 = node.getValue("y");
                    if (string4 == null) {
                        continue;
                    }
                    int y = Integer.parseInt(string4);
                    Intrinsics.checkNotNull((Object)node);
                    if (this.getReferencedFile(node, "image", skinFolder) == null) continue;
                    buttons.add(new ButtonDescriptor(keyName, new Point(x, y), imageFile));
                }
            }
            return new Part(background, mask, buttons);
        }

        @JvmStatic
        private final Path getReferencedFile(SkinLayoutDefinition node, String propertyName, Path skinFolder) {
            String string = node.getValue(propertyName);
            if (string == null) {
                return null;
            }
            String filename = string;
            return skinFolder.resolve(filename);
        }

        @JvmStatic
        private final boolean isTransparentNearCenterOfDisplay(BufferedImage image, Dimension displaySize, Rectangle frameRectangle) {
            return ImageUtils.isTransparentPixel(image, displaySize.width / 2 - frameRectangle.x, displaySize.height / 2 - frameRectangle.y);
        }

        @JvmStatic
        private final List<AnchoredImage> disassembleFrame(BufferedImage background, Rectangle frameRectangle, Dimension displaySize) {
            Point offset;
            BufferedImage image;
            Rectangle rect;
            Rectangle rectangle = this.getCropBounds(background, null);
            if (rectangle == null) {
                return CollectionsKt.emptyList();
            }
            Rectangle cropBounds = rectangle;
            int displayLeft = -frameRectangle.x;
            int displayRight = displayLeft + displaySize.width;
            int displayTop = -frameRectangle.y;
            int displayBottom = displayTop + displaySize.height;
            int marginLeft = displayLeft - cropBounds.x;
            int marginRight = this.getRight(cropBounds) - displayRight;
            int marginTop = displayTop - cropBounds.y;
            int marginBottom = this.getBottom(cropBounds) - displayBottom;
            List images = new ArrayList();
            if (marginRight > 0) {
                rect = new Rectangle(displayRight, displayTop, marginRight, displaySize.height);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayRight, rect.y - displayTop);
                Dimension dimension = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
                images.add(new AnchoredImage(image, dimension, AnchorPoint.TOP_RIGHT, offset));
            }
            if (marginRight > 0 && marginTop > 0) {
                rect = new Rectangle(displayRight, cropBounds.y, marginRight, marginTop);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayRight, rect.y - displayTop);
                Dimension dimension = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
                images.add(new AnchoredImage(image, dimension, AnchorPoint.TOP_RIGHT, offset));
            }
            if (marginTop > 0) {
                rect = new Rectangle(displayLeft, cropBounds.y, displaySize.width, marginTop);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayLeft, rect.y - displayTop);
                Dimension dimension = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
                images.add(new AnchoredImage(image, dimension, AnchorPoint.TOP_LEFT, offset));
            }
            if (marginLeft > 0 && marginTop > 0) {
                rect = new Rectangle(cropBounds.x, cropBounds.y, marginLeft, marginTop);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayLeft, rect.y - displayTop);
                Dimension dimension = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
                images.add(new AnchoredImage(image, dimension, AnchorPoint.TOP_LEFT, offset));
            }
            if (marginLeft > 0) {
                rect = new Rectangle(cropBounds.x, displayTop, marginLeft, displaySize.height);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayLeft, rect.y - displayTop);
                Dimension dimension = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
                images.add(new AnchoredImage(image, dimension, AnchorPoint.TOP_LEFT, offset));
            }
            if (marginLeft > 0 && marginBottom > 0) {
                rect = new Rectangle(cropBounds.x, displayBottom, marginLeft, marginBottom);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayLeft, rect.y - displayBottom);
                Dimension dimension = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
                images.add(new AnchoredImage(image, dimension, AnchorPoint.BOTTOM_LEFT, offset));
            }
            if (marginBottom > 0) {
                rect = new Rectangle(displayLeft, displayBottom, displaySize.width, marginBottom);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayLeft, rect.y - displayBottom);
                Dimension dimension = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
                images.add(new AnchoredImage(image, dimension, AnchorPoint.BOTTOM_LEFT, offset));
            }
            if (marginRight > 0 && marginBottom > 0) {
                rect = new Rectangle(displayRight, displayBottom, marginRight, marginBottom);
                image = this.cropped(background, rect);
                offset = new Point(rect.x - displayRight, rect.y - displayBottom);
                Dimension dimension = rect.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
                images.add(new AnchoredImage(image, dimension, AnchorPoint.BOTTOM_RIGHT, offset));
            }
            return images;
        }

        @JvmStatic
        private final List<AnchoredImage> disassembleMask(BufferedImage mask, Dimension displaySize) {
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap(this.cutHorizontally(mask, new Rectangle(0, 0, mask.getWidth(), mask.getHeight())), arg_0 -> Companion.disassembleMask$lambda$0(mask, arg_0)), arg_0 -> Companion.disassembleMask$lambda$1(mask, displaySize, arg_0)));
        }

        @JvmStatic
        private final Sequence<Rectangle> cutHorizontally(BufferedImage image, Rectangle cropBounds) {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Rectangle>, Continuation<? super Unit>, Object>(cropBounds, image, null){
                Object L$1;
                int I$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Rectangle $cropBounds;
                final /* synthetic */ BufferedImage $image;
                {
                    this.$cropBounds = $cropBounds;
                    this.$image = $image;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    block12: {
                        block10: {
                            block11: {
                                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                block0 : switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        $this$sequence = (SequenceScope)this.L$0;
                                        bounds = this.$cropBounds;
lbl8:
                                        // 2 sources

                                        while (true) {
                                            y = bounds.y;
                                            var5_6 = com.android.tools.adtui.device.SkinDefinition$Companion.access$getBottom(SkinDefinition.Companion, bounds);
lbl11:
                                            // 2 sources

                                            while (y < var5_6) {
                                                if (!com.android.tools.adtui.device.SkinDefinition$Companion.access$isTransparentHorizontalLine(SkinDefinition.Companion, this.$image, bounds.x, com.android.tools.adtui.device.SkinDefinition$Companion.access$getRight(SkinDefinition.Companion, bounds), y)) break block10;
                                                piece = com.android.tools.adtui.device.SkinDefinition$Companion.access$getCropBounds(SkinDefinition.Companion, this.$image, new Rectangle(bounds.x, this.$cropBounds.y, bounds.width, y - bounds.y));
                                                if (piece == null) break block0;
                                                $i$a$-let-SkinDefinition$Companion$cutHorizontally$1$1 = false;
                                                this.L$0 = $this$sequence;
                                                this.L$1 = bounds;
                                                this.I$0 = y;
                                                this.label = 1;
                                                v0 = $this$sequence.yield((Object)it, (Continuation)this);
                                                if (v0 == var9_2) {
                                                    return var9_2;
                                                }
                                                break block11;
                                            }
                                            break block12;
                                            break;
                                        }
                                    }
                                    case 1: {
                                        $i$a$-let-SkinDefinition$Companion$cutHorizontally$1$1 = false;
                                        y = this.I$0;
                                        bounds = (Rectangle)this.L$1;
                                        $this$sequence = (SequenceScope)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        break;
                                    }
                                }
                            }
                            if (com.android.tools.adtui.device.SkinDefinition$Companion.access$getCropBounds(SkinDefinition.Companion, this.$image, new Rectangle(bounds.x, y + 1, this.$cropBounds.width, bounds.height - y - 1)) == null) {
                                return Unit.INSTANCE;
                            }
                            ** while (true)
                        }
                        ++y;
                        ** GOTO lbl11
                    }
                    this.L$0 = null;
                    this.L$1 = null;
                    this.label = 2;
                    v1 = $this$sequence.yield((Object)bounds, (Continuation)this);
                    if (v1 == var9_2) {
                        return var9_2;
                    }
                    ** GOTO lbl53
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl53:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super Rectangle> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @JvmStatic
        private final Sequence<Rectangle> cutVertically(BufferedImage image, Rectangle cropBounds) {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Rectangle>, Continuation<? super Unit>, Object>(cropBounds, image, null){
                Object L$1;
                int I$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Rectangle $cropBounds;
                final /* synthetic */ BufferedImage $image;
                {
                    this.$cropBounds = $cropBounds;
                    this.$image = $image;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    block12: {
                        block10: {
                            block11: {
                                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                block0 : switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        $this$sequence = (SequenceScope)this.L$0;
                                        bounds = this.$cropBounds;
lbl8:
                                        // 2 sources

                                        while (true) {
                                            x = bounds.x;
                                            var5_6 = com.android.tools.adtui.device.SkinDefinition$Companion.access$getRight(SkinDefinition.Companion, bounds);
lbl11:
                                            // 2 sources

                                            while (x < var5_6) {
                                                if (!com.android.tools.adtui.device.SkinDefinition$Companion.access$isTransparentVerticalLine(SkinDefinition.Companion, this.$image, x, bounds.y, com.android.tools.adtui.device.SkinDefinition$Companion.access$getBottom(SkinDefinition.Companion, bounds))) break block10;
                                                piece = com.android.tools.adtui.device.SkinDefinition$Companion.access$getCropBounds(SkinDefinition.Companion, this.$image, new Rectangle(bounds.x, this.$cropBounds.y, x - bounds.x, bounds.height));
                                                if (piece == null) break block0;
                                                $i$a$-let-SkinDefinition$Companion$cutVertically$1$1 = false;
                                                this.L$0 = $this$sequence;
                                                this.L$1 = bounds;
                                                this.I$0 = x;
                                                this.label = 1;
                                                v0 = $this$sequence.yield((Object)it, (Continuation)this);
                                                if (v0 == var9_2) {
                                                    return var9_2;
                                                }
                                                break block11;
                                            }
                                            break block12;
                                            break;
                                        }
                                    }
                                    case 1: {
                                        $i$a$-let-SkinDefinition$Companion$cutVertically$1$1 = false;
                                        x = this.I$0;
                                        bounds = (Rectangle)this.L$1;
                                        $this$sequence = (SequenceScope)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        break;
                                    }
                                }
                            }
                            if (com.android.tools.adtui.device.SkinDefinition$Companion.access$getCropBounds(SkinDefinition.Companion, this.$image, new Rectangle(x + 1, bounds.y, this.$cropBounds.width - x - 1, bounds.height)) == null) {
                                return Unit.INSTANCE;
                            }
                            ** while (true)
                        }
                        ++x;
                        ** GOTO lbl11
                    }
                    this.L$0 = null;
                    this.L$1 = null;
                    this.label = 2;
                    v1 = $this$sequence.yield((Object)bounds, (Continuation)this);
                    if (v1 == var9_2) {
                        return var9_2;
                    }
                    ** GOTO lbl53
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl53:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super Rectangle> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @JvmStatic
        private final boolean isTransparentHorizontalLine(BufferedImage image, int startX, int endX, int y) {
            for (int x = startX; x < endX; ++x) {
                if (ImageUtils.isTransparentPixel(image, x, y)) continue;
                return false;
            }
            return true;
        }

        @JvmStatic
        private final boolean isTransparentVerticalLine(BufferedImage image, int x, int startY, int endY) {
            for (int y = startY; y < endY; ++y) {
                if (ImageUtils.isTransparentPixel(image, x, y)) continue;
                return false;
            }
            return true;
        }

        @JvmStatic
        private final AnchoredImage createAnchoredImage(BufferedImage mask, Rectangle cropBounds, Dimension displaySize) {
            AnchorPoint anchorPoint = cropBounds.x > displaySize.width / 2 ? (cropBounds.y > displaySize.height / 2 ? AnchorPoint.BOTTOM_RIGHT : AnchorPoint.TOP_RIGHT) : (cropBounds.y > displaySize.height / 2 ? AnchorPoint.BOTTOM_LEFT : AnchorPoint.TOP_LEFT);
            Point offset = new Point(cropBounds.x - anchorPoint.getX() * displaySize.width, cropBounds.y - anchorPoint.getY() * displaySize.height);
            BufferedImage bufferedImage = this.cropped(mask, cropBounds);
            Dimension dimension = cropBounds.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
            return new AnchoredImage(bufferedImage, dimension, anchorPoint, offset);
        }

        @JvmStatic
        private final Rectangle computeAdjustedFrameRectangle(Iterable<AnchoredImage> backgroundImages, Dimension displaySize) {
            int left = 0;
            int top = 0;
            int right = displaySize.width;
            int bottom = displaySize.height;
            for (AnchoredImage image : backgroundImages) {
                left = RangesKt.coerceAtMost((int)left, (int)(image.getOffset().x + displaySize.width * image.getAnchorPoint().getX()));
                right = RangesKt.coerceAtLeast((int)right, (int)(image.getOffset().x + image.getSize().width + displaySize.width * image.getAnchorPoint().getX()));
                top = RangesKt.coerceAtMost((int)top, (int)(image.getOffset().y + displaySize.height * image.getAnchorPoint().getY()));
                bottom = RangesKt.coerceAtLeast((int)bottom, (int)(image.getOffset().y + image.getSize().height + displaySize.height * image.getAnchorPoint().getY()));
            }
            return new Rectangle(left, top, right - left, bottom - top);
        }

        @JvmStatic
        private final BufferedImage cropped(BufferedImage $this$cropped, Rectangle cropBounds) {
            BufferedImage bufferedImage = ImageUtils.getCroppedImage($this$cropped, cropBounds, -1);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"getCroppedImage(...)");
            return bufferedImage;
        }

        @JvmStatic
        private final Rectangle getCropBounds(BufferedImage image, Rectangle initialCrop) {
            return ImageUtils.getCropBounds(image, ImageUtils::isTransparentPixel, initialCrop);
        }

        private final int getRight(Rectangle $this$right) {
            return $this$right.x + $this$right.width;
        }

        @JvmStatic
        private static /* synthetic */ void getRight$annotations(Rectangle rectangle) {
        }

        private final int getBottom(Rectangle $this$bottom) {
            return $this$bottom.y + $this$bottom.height;
        }

        @JvmStatic
        private static /* synthetic */ void getBottom$annotations(Rectangle rectangle) {
        }

        @JvmStatic
        @TestOnly
        @Nullable
        public final Path getBackgroundImageFile$intellij_android_adt_ui(@NotNull Path skinFolder) {
            Intrinsics.checkNotNullParameter((Object)skinFolder, (String)"skinFolder");
            return this.createLayoutDescriptor(skinFolder).getPart().getBackgroundFile();
        }

        private static final Sequence disassembleMask$lambda$0(BufferedImage $mask, Rectangle it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.cutVertically($mask, it);
        }

        private static final AnchoredImage disassembleMask$lambda$1(BufferedImage $mask, Dimension $displaySize, Rectangle it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.createAnchoredImage($mask, it, $displaySize);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0006H\u0002R.\u0010\u0004\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005j\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/adtui/device/SkinDefinition$ImageLoader;", "", "<init>", "()V", "loadedImages", "Ljava/util/HashMap;", "Ljava/nio/file/Path;", "Ljava/awt/image/BufferedImage;", "Lkotlin/collections/HashMap;", "loadImage", "imageFile", "readImage", "file", "intellij.android.adt.ui"})
    @SourceDebugExtension(value={"SMAP\nSkinDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinDefinition.kt\ncom/android/tools/adtui/device/SkinDefinition$ImageLoader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,672:1\n14#2:673\n*S KotlinDebug\n*F\n+ 1 SkinDefinition.kt\ncom/android/tools/adtui/device/SkinDefinition$ImageLoader\n*L\n238#1:673\n*E\n"})
    private static final class ImageLoader {
        @NotNull
        private final HashMap<Path, BufferedImage> loadedImages = new HashMap();

        @Nullable
        public final BufferedImage loadImage(@NotNull Path imageFile) {
            Intrinsics.checkNotNullParameter((Object)imageFile, (String)"imageFile");
            return this.loadedImages.computeIfAbsent(imageFile, arg_0 -> ImageLoader.loadImage$lambda$1(arg_0 -> ImageLoader.loadImage$lambda$0(this, arg_0), arg_0));
        }

        private final BufferedImage readImage(Path file) {
            BufferedImage bufferedImage;
            try {
                bufferedImage = ImageUtils.normalizeImage(Images.readImage((Path)file));
            }
            catch (IOException e) {
                String string;
                if (Files.notExists(file, new LinkOption[0])) {
                    string = "the file does not exist";
                } else {
                    string = e.getMessage();
                    if (string == null) {
                        string = "";
                    }
                }
                String detail = string;
                String separator = ((CharSequence)detail).length() == 0 ? "" : " - ";
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(SkinDefinition.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to read Emulator skin image " + file + separator + detail);
                bufferedImage = null;
            }
            return bufferedImage;
        }

        private static final BufferedImage loadImage$lambda$0(ImageLoader this$0, Path it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.readImage(it);
        }

        private static final BufferedImage loadImage$lambda$1(Function1 $tmp0, Object p0) {
            return (BufferedImage)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/adtui/device/SkinDefinition$LayoutDescriptor;", "", "displaySize", "Ljava/awt/Dimension;", "displayCornerRadius", "", "frameRectangle", "Ljava/awt/Rectangle;", "part", "Lcom/android/tools/adtui/device/SkinDefinition$Part;", "<init>", "(Ljava/awt/Dimension;ILjava/awt/Rectangle;Lcom/android/tools/adtui/device/SkinDefinition$Part;)V", "getDisplaySize", "()Ljava/awt/Dimension;", "getDisplayCornerRadius", "()I", "getFrameRectangle", "()Ljava/awt/Rectangle;", "getPart", "()Lcom/android/tools/adtui/device/SkinDefinition$Part;", "imageLoader", "Lcom/android/tools/adtui/device/SkinDefinition$ImageLoader;", "createLayout", "Lcom/android/tools/adtui/device/SkinLayout;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.adt.ui"})
    @SourceDebugExtension(value={"SMAP\nSkinDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinDefinition.kt\ncom/android/tools/adtui/device/SkinDefinition$LayoutDescriptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,672:1\n1#2:673\n1#2:684\n1617#3,9:674\n1869#3:683\n1870#3:685\n1626#3:686\n*S KotlinDebug\n*F\n+ 1 SkinDefinition.kt\ncom/android/tools/adtui/device/SkinDefinition$LayoutDescriptor\n*L\n189#1:684\n189#1:674,9\n189#1:683\n189#1:685\n189#1:686\n*E\n"})
    private static final class LayoutDescriptor {
        @NotNull
        private final Dimension displaySize;
        private final int displayCornerRadius;
        @NotNull
        private final Rectangle frameRectangle;
        @NotNull
        private final Part part;
        @NotNull
        private final ImageLoader imageLoader;

        public LayoutDescriptor(@NotNull Dimension displaySize, int displayCornerRadius, @NotNull Rectangle frameRectangle, @NotNull Part part) {
            Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
            Intrinsics.checkNotNullParameter((Object)frameRectangle, (String)"frameRectangle");
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            this.displaySize = displaySize;
            this.displayCornerRadius = displayCornerRadius;
            this.frameRectangle = frameRectangle;
            this.part = part;
            this.imageLoader = new ImageLoader();
        }

        @NotNull
        public final Dimension getDisplaySize() {
            return this.displaySize;
        }

        public final int getDisplayCornerRadius() {
            return this.displayCornerRadius;
        }

        @NotNull
        public final Rectangle getFrameRectangle() {
            return this.frameRectangle;
        }

        @NotNull
        public final Part getPart() {
            return this.part;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SkinLayout createLayout() {
            void $this$mapNotNullTo$iv$iv;
            Object object;
            Object maskImages;
            Object backgroundImages;
            block17: {
                block16: {
                    BufferedImage mask;
                    block15: {
                        Object object2;
                        block14: {
                            BufferedImage bufferedImage;
                            backgroundImages = null;
                            maskImages = null;
                            Path path = this.part.getBackgroundFile();
                            if (path != null) {
                                Path it = path;
                                boolean bl = false;
                                bufferedImage = this.imageLoader.loadImage(it);
                            } else {
                                bufferedImage = null;
                            }
                            BufferedImage background = bufferedImage;
                            if (background != null && Companion.isTransparentNearCenterOfDisplay(background, this.displaySize, this.frameRectangle)) {
                                Path maskFile;
                                BufferedImage bufferedImage2;
                                BufferedImage $this$createLayout_u24lambda_u241 = bufferedImage2 = Companion.cropped(background, new Rectangle(-this.frameRectangle.x, -this.frameRectangle.y, this.displaySize.width, this.displaySize.height));
                                boolean bl = false;
                                if (ApplicationManager.getApplication() == null && this.part.getMaskFile() != null && Files.notExists(maskFile = this.part.getMaskFile(), new LinkOption[0])) {
                                    Images.writeImage((RenderedImage)$this$createLayout_u24lambda_u241, (String)"WEBP", (Path)maskFile);
                                }
                                v2 = bufferedImage2;
                            } else {
                                v2 = mask = this.part.getMaskFile() != null ? this.imageLoader.loadImage(this.part.getMaskFile()) : null;
                            }
                            if ((object2 = background) == null) break block14;
                            BufferedImage it = object2;
                            boolean bl = false;
                            List list = Companion.disassembleFrame(it, this.frameRectangle, this.displaySize);
                            object2 = list;
                            if (list != null) break block15;
                        }
                        object2 = backgroundImages = CollectionsKt.emptyList();
                    }
                    if ((object = mask) == null) break block16;
                    BufferedImage it = object;
                    boolean bl = false;
                    List list = Companion.disassembleMask(it, this.displaySize);
                    object = list;
                    if (list != null) break block17;
                }
                object = CollectionsKt.emptyList();
            }
            maskImages = object;
            Rectangle adjustedFrameRectangle = Companion.computeAdjustedFrameRectangle((Iterable)backgroundImages, this.displaySize);
            Iterable $this$mapNotNull$iv = this.part.getButtons();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SkinButton skinButton;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ButtonDescriptor buttonDescriptor = (ButtonDescriptor)element$iv$iv;
                boolean bl2 = false;
                if (buttonDescriptor.createButton(this.imageLoader) != null) {
                    SkinButton it;
                    boolean bl3 = false;
                    skinButton = new SkinButton(it.getKeyName(), it.getImage().translatedAndReanchored(this.frameRectangle.x, this.frameRectangle.y, this.displaySize));
                } else {
                    skinButton = null;
                }
                if (skinButton == null) continue;
                SkinButton it$iv$iv = skinButton;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List buttons = (List)destination$iv$iv;
            return new SkinLayout(this.displaySize, new Dimension(this.displayCornerRadius, this.displayCornerRadius), adjustedFrameRectangle, (List<AnchoredImage>)backgroundImages, (List<AnchoredImage>)maskImages, buttons);
        }

        @NotNull
        public final Dimension component1() {
            return this.displaySize;
        }

        public final int component2() {
            return this.displayCornerRadius;
        }

        @NotNull
        public final Rectangle component3() {
            return this.frameRectangle;
        }

        @NotNull
        public final Part component4() {
            return this.part;
        }

        @NotNull
        public final LayoutDescriptor copy(@NotNull Dimension displaySize, int displayCornerRadius, @NotNull Rectangle frameRectangle, @NotNull Part part) {
            Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
            Intrinsics.checkNotNullParameter((Object)frameRectangle, (String)"frameRectangle");
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            return new LayoutDescriptor(displaySize, displayCornerRadius, frameRectangle, part);
        }

        public static /* synthetic */ LayoutDescriptor copy$default(LayoutDescriptor layoutDescriptor, Dimension dimension, int n, Rectangle rectangle, Part part, int n2, Object object) {
            if ((n2 & 1) != 0) {
                dimension = layoutDescriptor.displaySize;
            }
            if ((n2 & 2) != 0) {
                n = layoutDescriptor.displayCornerRadius;
            }
            if ((n2 & 4) != 0) {
                rectangle = layoutDescriptor.frameRectangle;
            }
            if ((n2 & 8) != 0) {
                part = layoutDescriptor.part;
            }
            return layoutDescriptor.copy(dimension, n, rectangle, part);
        }

        @NotNull
        public String toString() {
            return "LayoutDescriptor(displaySize=" + this.displaySize + ", displayCornerRadius=" + this.displayCornerRadius + ", frameRectangle=" + this.frameRectangle + ", part=" + this.part + ")";
        }

        public int hashCode() {
            int result = this.displaySize.hashCode();
            result = result * 31 + Integer.hashCode(this.displayCornerRadius);
            result = result * 31 + this.frameRectangle.hashCode();
            result = result * 31 + this.part.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LayoutDescriptor)) {
                return false;
            }
            LayoutDescriptor layoutDescriptor = (LayoutDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.displaySize, (Object)layoutDescriptor.displaySize)) {
                return false;
            }
            if (this.displayCornerRadius != layoutDescriptor.displayCornerRadius) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.frameRectangle, (Object)layoutDescriptor.frameRectangle)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.part, (Object)layoutDescriptor.part);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/adtui/device/SkinDefinition$Part;", "", "backgroundFile", "Ljava/nio/file/Path;", "maskFile", "buttons", "", "Lcom/android/tools/adtui/device/SkinDefinition$ButtonDescriptor;", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/util/List;)V", "getBackgroundFile", "()Ljava/nio/file/Path;", "getMaskFile", "getButtons", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.adt.ui"})
    private static final class Part {
        @Nullable
        private final Path backgroundFile;
        @Nullable
        private final Path maskFile;
        @NotNull
        private final List<ButtonDescriptor> buttons;

        public Part(@Nullable Path backgroundFile, @Nullable Path maskFile, @NotNull List<ButtonDescriptor> buttons) {
            Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
            this.backgroundFile = backgroundFile;
            this.maskFile = maskFile;
            this.buttons = buttons;
        }

        @Nullable
        public final Path getBackgroundFile() {
            return this.backgroundFile;
        }

        @Nullable
        public final Path getMaskFile() {
            return this.maskFile;
        }

        @NotNull
        public final List<ButtonDescriptor> getButtons() {
            return this.buttons;
        }

        @Nullable
        public final Path component1() {
            return this.backgroundFile;
        }

        @Nullable
        public final Path component2() {
            return this.maskFile;
        }

        @NotNull
        public final List<ButtonDescriptor> component3() {
            return this.buttons;
        }

        @NotNull
        public final Part copy(@Nullable Path backgroundFile, @Nullable Path maskFile, @NotNull List<ButtonDescriptor> buttons) {
            Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
            return new Part(backgroundFile, maskFile, buttons);
        }

        public static /* synthetic */ Part copy$default(Part part, Path path, Path path2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                path = part.backgroundFile;
            }
            if ((n & 2) != 0) {
                path2 = part.maskFile;
            }
            if ((n & 4) != 0) {
                list = part.buttons;
            }
            return part.copy(path, path2, list);
        }

        @NotNull
        public String toString() {
            return "Part(backgroundFile=" + this.backgroundFile + ", maskFile=" + this.maskFile + ", buttons=" + this.buttons + ")";
        }

        public int hashCode() {
            int result = this.backgroundFile == null ? 0 : ((Object)this.backgroundFile).hashCode();
            result = result * 31 + (this.maskFile == null ? 0 : ((Object)this.maskFile).hashCode());
            result = result * 31 + ((Object)this.buttons).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Part)) {
                return false;
            }
            Part part = (Part)other;
            if (!Intrinsics.areEqual((Object)this.backgroundFile, (Object)part.backgroundFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.maskFile, (Object)part.maskFile)) {
                return false;
            }
            return Intrinsics.areEqual(this.buttons, part.buttons);
        }
    }
}

