/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.device;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.util.AwtUtilsKt;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/adtui/device/ImageTransformer;", "", "rotationQuadrants", "", "scaleX", "", "scaleY", "<init>", "(IDD)V", "getRotationQuadrants", "()I", "getScaleX", "()D", "getScaleY", "cache", "", "Ljava/awt/image/BufferedImage;", "transform", "image", "intellij.android.adt.ui"})
public final class ImageTransformer {
    private final int rotationQuadrants;
    private final double scaleX;
    private final double scaleY;
    @NotNull
    private final Map<BufferedImage, BufferedImage> cache;

    public ImageTransformer(int rotationQuadrants, double scaleX, double scaleY) {
        this.rotationQuadrants = rotationQuadrants;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.cache = new LinkedHashMap();
    }

    public final int getRotationQuadrants() {
        return this.rotationQuadrants;
    }

    public final double getScaleX() {
        return this.scaleX;
    }

    public final double getScaleY() {
        return this.scaleY;
    }

    @Nullable
    public final BufferedImage transform(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.cache.computeIfAbsent(image, arg_0 -> ImageTransformer.transform$lambda$1(arg_0 -> ImageTransformer.transform$lambda$0(image, this, arg_0), arg_0));
    }

    private static final BufferedImage transform$lambda$0(BufferedImage $image, ImageTransformer this$0, BufferedImage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Dimension rotatedSize = AwtUtilsKt.rotatedByQuadrants(new Dimension($image.getWidth(), $image.getHeight()), this$0.rotationQuadrants);
        int width = AwtUtilsKt.scaled(rotatedSize.width, this$0.scaleX);
        int height = AwtUtilsKt.scaled(rotatedSize.height, this$0.scaleY);
        return width > 0 && height > 0 ? ImageUtils.rotateByQuadrantsAndScale($image, this$0.rotationQuadrants, width, height, 2) : null;
    }

    private static final BufferedImage transform$lambda$1(Function1 $tmp0, Object p0) {
        return (BufferedImage)$tmp0.invoke(p0);
    }
}

