/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.device;

import com.android.tools.adtui.device.AnchorPoint;
import com.android.tools.adtui.device.ImageTransformer;
import com.android.tools.adtui.util.AwtUtilsKt;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u001e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0005J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J1\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u001aH\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lcom/android/tools/adtui/device/AnchoredImage;", "", "image", "Ljava/awt/image/BufferedImage;", "size", "Ljava/awt/Dimension;", "anchorPoint", "Lcom/android/tools/adtui/device/AnchorPoint;", "offset", "Ljava/awt/Point;", "<init>", "(Ljava/awt/image/BufferedImage;Ljava/awt/Dimension;Lcom/android/tools/adtui/device/AnchorPoint;Ljava/awt/Point;)V", "getImage", "()Ljava/awt/image/BufferedImage;", "getSize", "()Ljava/awt/Dimension;", "getAnchorPoint", "()Lcom/android/tools/adtui/device/AnchorPoint;", "getOffset", "()Ljava/awt/Point;", "rotatedAndScaled", "imageTransformer", "Lcom/android/tools/adtui/device/ImageTransformer;", "rotatedAndScaled$intellij_android_adt_ui", "translatedAndReanchored", "x", "", "y", "displaySize", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.adt.ui"})
public final class AnchoredImage {
    @NotNull
    private final BufferedImage image;
    @NotNull
    private final Dimension size;
    @NotNull
    private final AnchorPoint anchorPoint;
    @NotNull
    private final Point offset;

    public AnchoredImage(@NotNull BufferedImage image, @NotNull Dimension size, @NotNull AnchorPoint anchorPoint, @NotNull Point offset) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)((Object)anchorPoint), (String)"anchorPoint");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        this.image = image;
        this.size = size;
        this.anchorPoint = anchorPoint;
        this.offset = offset;
    }

    @NotNull
    public final BufferedImage getImage() {
        return this.image;
    }

    @NotNull
    public final Dimension getSize() {
        return this.size;
    }

    @NotNull
    public final AnchorPoint getAnchorPoint() {
        return this.anchorPoint;
    }

    @NotNull
    public final Point getOffset() {
        return this.offset;
    }

    @Nullable
    public final AnchoredImage rotatedAndScaled$intellij_android_adt_ui(@NotNull ImageTransformer imageTransformer) {
        Intrinsics.checkNotNullParameter((Object)imageTransformer, (String)"imageTransformer");
        int rotationQuadrants = imageTransformer.getRotationQuadrants();
        double scaleX = imageTransformer.getScaleX();
        double scaleY = imageTransformer.getScaleY();
        Dimension rotatedSize = AwtUtilsKt.rotatedByQuadrants(this.size, rotationQuadrants);
        int width = AwtUtilsKt.scaled(rotatedSize.width, scaleX);
        int height = AwtUtilsKt.scaled(rotatedSize.height, scaleY);
        if (width == 0 || height == 0) {
            return null;
        }
        BufferedImage bufferedImage = imageTransformer.transform(this.image);
        if (bufferedImage == null) {
            return null;
        }
        BufferedImage transformedImage = bufferedImage;
        AnchorPoint rotatedAnchorPoint = this.anchorPoint.rotatedByQuadrants(rotationQuadrants);
        Point rotatedOffset = AwtUtilsKt.rotatedByQuadrants(this.offset, rotationQuadrants);
        Point transformedOffset = switch (rotationQuadrants) {
            case 1 -> new Point(AwtUtilsKt.scaled(rotatedOffset.x, scaleX), AwtUtilsKt.scaled(rotatedOffset.y, scaleY) - height);
            case 2 -> new Point(AwtUtilsKt.scaled(rotatedOffset.x, scaleX) - width, AwtUtilsKt.scaled(rotatedOffset.y, scaleY) - height);
            case 3 -> new Point(AwtUtilsKt.scaled(rotatedOffset.x, scaleX) - width, AwtUtilsKt.scaled(rotatedOffset.y, scaleY));
            default -> new Point(AwtUtilsKt.scaled(rotatedOffset.x, scaleX), AwtUtilsKt.scaled(rotatedOffset.y, scaleY));
        };
        return new AnchoredImage(transformedImage, new Dimension(width, height), rotatedAnchorPoint, transformedOffset);
    }

    @NotNull
    public final AnchoredImage translatedAndReanchored(int x, int y, @NotNull Dimension displaySize) {
        Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
        Point point = new Point(this.offset.x + x, this.offset.y + y);
        int minDistanceSquared = Integer.MAX_VALUE;
        AnchorPoint closestAnchor = this.anchorPoint;
        for (AnchorPoint anchor : AnchorPoint.getEntries()) {
            int cornerY;
            int dy;
            int cornerX = displaySize.width * (anchor.getX() - this.anchorPoint.getX());
            int dx = point.x - cornerX;
            int d = dx * dx + (dy = point.y - (cornerY = displaySize.height * (anchor.getY() - this.anchorPoint.getY()))) * dy;
            if (d >= minDistanceSquared) continue;
            minDistanceSquared = d;
            closestAnchor = anchor;
        }
        point.translate(displaySize.width * (this.anchorPoint.getX() - closestAnchor.getX()), displaySize.height * (this.anchorPoint.getY() - closestAnchor.getY()));
        return new AnchoredImage(this.image, this.size, closestAnchor, point);
    }

    @NotNull
    public final BufferedImage component1() {
        return this.image;
    }

    @NotNull
    public final Dimension component2() {
        return this.size;
    }

    @NotNull
    public final AnchorPoint component3() {
        return this.anchorPoint;
    }

    @NotNull
    public final Point component4() {
        return this.offset;
    }

    @NotNull
    public final AnchoredImage copy(@NotNull BufferedImage image, @NotNull Dimension size, @NotNull AnchorPoint anchorPoint, @NotNull Point offset) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)((Object)anchorPoint), (String)"anchorPoint");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return new AnchoredImage(image, size, anchorPoint, offset);
    }

    public static /* synthetic */ AnchoredImage copy$default(AnchoredImage anchoredImage, BufferedImage bufferedImage, Dimension dimension, AnchorPoint anchorPoint, Point point, int n, Object object) {
        if ((n & 1) != 0) {
            bufferedImage = anchoredImage.image;
        }
        if ((n & 2) != 0) {
            dimension = anchoredImage.size;
        }
        if ((n & 4) != 0) {
            anchorPoint = anchoredImage.anchorPoint;
        }
        if ((n & 8) != 0) {
            point = anchoredImage.offset;
        }
        return anchoredImage.copy(bufferedImage, dimension, anchorPoint, point);
    }

    @NotNull
    public String toString() {
        return "AnchoredImage(image=" + this.image + ", size=" + this.size + ", anchorPoint=" + this.anchorPoint + ", offset=" + this.offset + ")";
    }

    public int hashCode() {
        int result = this.image.hashCode();
        result = result * 31 + this.size.hashCode();
        result = result * 31 + this.anchorPoint.hashCode();
        result = result * 31 + this.offset.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnchoredImage)) {
            return false;
        }
        AnchoredImage anchoredImage = (AnchoredImage)other;
        if (!Intrinsics.areEqual((Object)this.image, (Object)anchoredImage.image)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.size, (Object)anchoredImage.size)) {
            return false;
        }
        if (this.anchorPoint != anchoredImage.anchorPoint) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.offset, (Object)anchoredImage.offset);
    }
}

