/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/adtui/common/AdtUiCursorProviderImpl;", "Lcom/android/tools/adtui/common/AdtUiCursorsProvider;", "<init>", "()V", "cursorMap", "", "Lcom/android/tools/adtui/common/AdtUiCursorType;", "Ljava/awt/Cursor;", "getCursor", "type", "makeCursor", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nAdtUiCursors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdtUiCursors.kt\ncom/android/tools/adtui/common/AdtUiCursorProviderImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,94:1\n382#2,7:95\n*S KotlinDebug\n*F\n+ 1 AdtUiCursors.kt\ncom/android/tools/adtui/common/AdtUiCursorProviderImpl\n*L\n70#1:95,7\n*E\n"})
final class AdtUiCursorProviderImpl
implements AdtUiCursorsProvider {
    @NotNull
    private final Map<AdtUiCursorType, Cursor> cursorMap = new LinkedHashMap();

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Cursor getCursor(@NotNull AdtUiCursorType type) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Map<AdtUiCursorType, Cursor> map2 = this.cursorMap;
        AdtUiCursorType key$iv = type;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get((Object)key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Cursor answer$iv = this.makeCursor(type);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Cursor)object;
    }

    private final Cursor makeCursor(AdtUiCursorType type) {
        if (GraphicsEnvironment.isHeadless()) {
            Logger.getInstance(AdtUiCursorProviderImpl.class).warn("Cannot create a custom cursor in headless environment, use default cursor instead");
            Cursor cursor = Cursor.getDefaultCursor();
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getDefaultCursor(...)");
            return cursor;
        }
        String name = ((Object)((Object)type)).getClass().getName() + "." + type.name();
        Icon icon = type.getIcon();
        Function1<BufferedImage, Point> hotSpotMapFunc = type.getHotSpotMapFun$intellij_android_adt_ui();
        float scaleFactor = UIUtil.isRetina() ? 0.5f : 1.0f;
        Intrinsics.checkNotNull((Object)icon, (String)"null cannot be cast to non-null type com.intellij.ui.icons.CachedImageIcon");
        CachedImageIcon scaledIcon = ((CachedImageIcon)icon).scale(scaleFactor);
        BufferedImage bufferedImage = UIUtil.createImage((int)scaledIcon.getIconWidth(), (int)scaledIcon.getIconHeight(), (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage image = bufferedImage;
        Component component = new JPanel();
        Graphics graphics = image.getGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics, (String)"getGraphics(...)");
        scaledIcon.paintIcon(component, graphics, 0, 0);
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, (Point)hotSpotMapFunc.invoke((Object)image), name);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"createCustomCursor(...)");
        return cursor;
    }
}

