/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.intellij.util.Function;
import com.intellij.util.containers.Stack;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public final class TreeWalker {
    private final Component myRoot;

    private static Stream<Component> streamFromIterator(Iterator<Component> componentIterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(componentIterator, 1297), false);
    }

    public static boolean isAncestor(@NotNull Container ancestor, @NotNull Component child) {
        if (child == ancestor) {
            return true;
        }
        if (child.getParent() == null) {
            return false;
        }
        return TreeWalker.isAncestor(ancestor, child.getParent());
    }

    public TreeWalker(@NotNull Component root) {
        this.myRoot = root;
    }

    public Stream<Component> ancestorStream() {
        return TreeWalker.streamFromIterator(new AncestorIterator(this.myRoot));
    }

    public Iterable<Component> ancestors() {
        return new Iterable<Component>(){

            @Override
            public Iterator<Component> iterator() {
                return new AncestorIterator(TreeWalker.this.myRoot);
            }
        };
    }

    public Stream<Component> descendantStream(DescendantOrder order) {
        return TreeWalker.streamFromIterator((Iterator)order.createIterator.fun((Object)this.myRoot));
    }

    public Iterable<Component> descendants(final DescendantOrder order) {
        return new Iterable<Component>(){

            @Override
            public Iterator<Component> iterator() {
                return (Iterator)order.createIterator.fun((Object)TreeWalker.this.myRoot);
            }
        };
    }

    public Stream<Component> descendantStream() {
        return this.descendantStream(DescendantOrder.BREADTH_FIRST);
    }

    public Iterable<Component> descendants() {
        return this.descendants(DescendantOrder.BREADTH_FIRST);
    }

    private static final class AncestorIterator
    implements Iterator<Component> {
        Component currComponent;

        public AncestorIterator(Component root) {
            this.currComponent = root;
        }

        @Override
        public boolean hasNext() {
            return this.currComponent != null;
        }

        @Override
        public Component next() {
            Component next = this.currComponent;
            this.currComponent = this.currComponent.getParent();
            return next;
        }
    }

    public static enum DescendantOrder {
        BREADTH_FIRST((Function<Component, Iterator<Component>>)((Function)BfsDescendantIterator::new)),
        DEPTH_FIRST((Function<Component, Iterator<Component>>)((Function)DfsDescendantIterator::new));

        final Function<Component, Iterator<Component>> createIterator;

        private DescendantOrder(Function<Component, Iterator<Component>> createIterator) {
            this.createIterator = createIterator;
        }
    }

    private static final class DfsDescendantIterator
    implements Iterator<Component> {
        private final Stack<Component> myDescendants = new Stack();

        public DfsDescendantIterator(Component root) {
            this.myDescendants.push((Object)root);
        }

        @Override
        public boolean hasNext() {
            return !this.myDescendants.isEmpty();
        }

        @Override
        public Component next() {
            Component c = (Component)this.myDescendants.pop();
            if (c instanceof Container) {
                for (int i = ((Container)c).getComponentCount() - 1; i >= 0; --i) {
                    Component child = ((Container)c).getComponent(i);
                    this.myDescendants.push((Object)child);
                }
            }
            return c;
        }
    }

    private static final class BfsDescendantIterator
    implements Iterator<Component> {
        private final Deque<Component> myDescendants = new ArrayDeque<Component>(10);

        public BfsDescendantIterator(Component root) {
            this.myDescendants.addLast(root);
        }

        @Override
        public boolean hasNext() {
            return !this.myDescendants.isEmpty();
        }

        @Override
        public Component next() {
            Component c = this.myDescendants.removeFirst();
            if (c instanceof Container) {
                for (Component child : ((Container)c).getComponents()) {
                    if (child == null) continue;
                    this.myDescendants.addLast(child);
                }
            }
            return c;
        }
    }
}

