/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TreeWalker;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class TooltipView
extends AspectObserver {
    public static final Font TOOLTIP_BODY_FONT = AdtUiUtils.DEFAULT_FONT.biggerOn(2.0f);
    private static final Font TOOLTIP_HEADER_FONT = AdtUiUtils.DEFAULT_FONT.biggerOn(3.0f);
    private static final Color TOOLTIP_TEXT = JBColor.foreground();
    private static final Color TOOLTIP_BACKGROUND = StudioColorsKt.getCanvasTooltipBackground();
    @NotNull
    private final Timeline myTimeline;
    @NotNull
    private final JLabel myHeadingLabel;
    protected final Font myFont;

    protected TooltipView(@NotNull Timeline timeline) {
        this.myTimeline = timeline;
        this.myHeadingLabel = new JLabel();
        this.myHeadingLabel.setForeground(TOOLTIP_TEXT);
        this.myFont = TOOLTIP_HEADER_FONT;
        this.myHeadingLabel.setFont(this.myFont);
        timeline.getTooltipRange().addDependency(this).onChange(Range.Aspect.RANGE, this::timeChanged);
    }

    @VisibleForTesting
    public String getHeadingText() {
        return this.myHeadingLabel.getText();
    }

    private void timeChanged() {
        this.updateHeader();
        this.updateTooltip();
    }

    private void updateHeader() {
        Range tooltipRange = this.myTimeline.getTooltipRange();
        if (!tooltipRange.isEmpty() && tooltipRange.getMin() >= this.myTimeline.getDataRange().getMin()) {
            String time = TimeFormatter.getSemiSimplifiedClockString((long)(tooltipRange.getMin() - this.myTimeline.getDataRange().getMin()));
            this.myHeadingLabel.setText(time);
        } else {
            this.myHeadingLabel.setText("");
        }
    }

    protected void updateTooltip() {
    }

    @NotNull
    protected abstract JComponent createTooltip();

    @NotNull
    protected static JLabel createTooltipLabel() {
        JLabel label2 = new JLabel();
        label2.setFont(TOOLTIP_BODY_FONT);
        label2.setForeground(TOOLTIP_TEXT);
        return label2;
    }

    @NotNull
    protected Timeline getTimeline() {
        return this.myTimeline;
    }

    @NotNull
    public final JComponent createComponent() {
        TooltipPanel tooltipPanel = new TooltipPanel(new TabularLayout("Fit", "Fit-,8px,Fit"));
        tooltipPanel.add((Component)this.myHeadingLabel, new TabularLayout.Constraint(0, 0));
        tooltipPanel.add((Component)this.createTooltip(), new TabularLayout.Constraint(2, 0));
        tooltipPanel.setForeground(TOOLTIP_TEXT);
        tooltipPanel.setBackground(TOOLTIP_BACKGROUND);
        Border visibleBorder = JBUI.Borders.customLine((Color)StudioColorsKt.getBorderLight());
        tooltipPanel.setBorder(JBUI.Borders.merge((Border)new JBEmptyBorder(9, 9, 9, 9), (Border)visibleBorder, (boolean)true));
        this.updateHeader();
        new TreeWalker(tooltipPanel).descendantStream().forEach(component -> component.setBackground(tooltipPanel.getBackground()));
        return tooltipPanel;
    }

    public void dispose() {
        this.myTimeline.getTooltipRange().removeDependencies(this);
    }

    private static class TooltipPanel
    extends JPanel {
        TooltipPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        @Override
        public void doLayout() {
            Rectangle oldBounds = this.getBounds();
            Dimension preferredSize = this.getPreferredSize();
            this.setBounds(oldBounds.x, oldBounds.y, preferredSize.width, preferredSize.height);
            super.doLayout();
        }
    }
}

