/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterModel;
import com.android.tools.adtui.stdui.CommonToggleButton;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.concurrent.CountDownLatch;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class FilterComponent
extends JPanel {
    static final String OPEN_AND_FOCUS_ACTION = "OpenAndFocusSearchAction";
    static final String CLOSE_ACTION = "CloseSearchAction";
    static final JBColor NO_MATCHES_COLOR = new JBColor(new Color(-13108), new Color(-9160134));
    private static final String REGEX = "Regex";
    private static final String MATCH_CASE = "Match Case";
    private final FilterModel myModel;
    private JCheckBox myRegexCheckBox;
    private JCheckBox myMatchCaseCheckBox;
    private JLabel myCountLabel;
    private final SearchTextField mySearchField;
    private final Timer myTimer;
    private final Color mySearchFieldDefaultBackground;
    private CountDownLatch myTimerRunningLatch = new CountDownLatch(0);

    public FilterComponent(@NotNull Filter filter, int textFieldWidth, int historySize, int delayMs) {
        super(new TabularLayout("4px," + textFieldWidth + "px,5px,Fit-,5px,Fit-,20px,Fit-", "Fit-"));
        this.myModel = new FilterModel();
        this.myModel.setFilter(filter);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                super.componentShown(e);
                FilterComponent.this.requestFocusInWindow();
            }
        });
        this.mySearchField = new SearchTextField(){

            protected Runnable createItemChosenCallback(JList list) {
                Runnable callback = super.createItemChosenCallback(list);
                return () -> {
                    callback.run();
                    FilterComponent.this.updateModel();
                };
            }

            protected Component getPopupLocationComponent() {
                return FilterComponent.this.mySearchField;
            }

            protected void onFocusLost() {
                this.addCurrentTextToHistory();
                super.onFocusLost();
            }
        };
        if (!filter.isEmpty()) {
            this.mySearchField.setText(filter.getFilterString());
        }
        this.mySearchField.getTextEditor().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    FilterComponent.this.mySearchField.addCurrentTextToHistory();
                    FilterComponent.this.updateModel();
                }
            }
        });
        this.myTimer = new Timer(delayMs, e -> {
            this.updateModel();
            this.myTimerRunningLatch.countDown();
        });
        this.myTimer.setRepeats(false);
        this.mySearchField.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.onChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.onChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.onChanged();
            }

            private void onChanged() {
                FilterComponent.this.myTimerRunningLatch = new CountDownLatch(1);
                FilterComponent.this.myTimer.restart();
            }
        });
        this.mySearchField.setHistorySize(historySize);
        this.add((Component)this.mySearchField, new TabularLayout.Constraint(0, 1));
        this.mySearchFieldDefaultBackground = this.mySearchField.getTextEditor().getBackground();
        this.myMatchCaseCheckBox = new JCheckBox(MATCH_CASE, filter.isMatchCase());
        this.myMatchCaseCheckBox.setMnemonic(67);
        this.myMatchCaseCheckBox.setDisplayedMnemonicIndex(MATCH_CASE.indexOf(67));
        this.myMatchCaseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FilterComponent.this.updateModel();
            }
        });
        this.add((Component)this.myMatchCaseCheckBox, new TabularLayout.Constraint(0, 3));
        this.myRegexCheckBox = new JCheckBox(REGEX, filter.isRegex());
        this.myRegexCheckBox.setMnemonic(71);
        this.myRegexCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FilterComponent.this.updateModel();
            }
        });
        this.add((Component)this.myRegexCheckBox, new TabularLayout.Constraint(0, 5));
        this.myCountLabel = new JLabel();
        this.myCountLabel.setFont(this.myCountLabel.getFont().deriveFont(1));
        this.add((Component)this.myCountLabel, new TabularLayout.Constraint(0, 7));
        this.myModel.addMatchResultListener(result -> {
            Color background = this.mySearchFieldDefaultBackground;
            Object text = "";
            if (result.isFilterEnabled()) {
                int count = result.getMatchCount();
                if (count == 0) {
                    text = "No matches";
                    background = NO_MATCHES_COLOR;
                } else {
                    text = count == 1 ? "One match" : new DecimalFormat("#,###").format(count) + " matches";
                }
            }
            this.mySearchField.getTextEditor().setBackground(background);
            this.myCountLabel.setText((String)text);
        });
    }

    public FilterComponent(int textFieldWidth, int historySize, int delayMs) {
        this(Filter.EMPTY_FILTER, textFieldWidth, historySize, delayMs);
    }

    public void setFilterText(String filterText) {
        this.mySearchField.setText(filterText);
    }

    @NotNull
    public FilterModel getModel() {
        return this.myModel;
    }

    @NotNull
    public FilterComponent setMatchCountVisibility(boolean value) {
        this.myCountLabel.setVisible(value);
        return this;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.mySearchField.requestFocusInWindow();
    }

    @VisibleForTesting
    @NotNull
    public SearchTextField getSearchField() {
        return this.mySearchField;
    }

    @VisibleForTesting
    @NotNull
    public JLabel getCountLabel() {
        return this.myCountLabel;
    }

    @TestOnly
    public void waitForFilterUpdated() throws InterruptedException {
        this.myTimerRunningLatch.await();
    }

    private void updateModel() {
        this.myModel.setFilter(new Filter(this.mySearchField.getText(), this.myMatchCaseCheckBox.isSelected(), this.myRegexCheckBox.isSelected()));
    }

    public static void configureKeyBindingAndFocusBehaviors(final @NotNull JComponent containerComponent, final @NotNull FilterComponent filterComponent, final @NotNull JToggleButton showHideButton) {
        showHideButton.addActionListener(event -> {
            filterComponent.setVisible(showHideButton.isSelected());
            if (!showHideButton.isSelected()) {
                filterComponent.setFilterText("");
            } else {
                filterComponent.requestFocusInWindow();
            }
            containerComponent.revalidate();
        });
        InputMap inputMap = containerComponent.getInputMap(1);
        ActionMap actionMap = containerComponent.getActionMap();
        inputMap.put(FilterComponent.getFilterKeyStroke(), OPEN_AND_FOCUS_ACTION);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), CLOSE_ACTION);
        actionMap.put(OPEN_AND_FOCUS_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!showHideButton.isSelected()) {
                    showHideButton.doClick(0);
                } else {
                    filterComponent.requestFocusInWindow();
                }
            }
        });
        actionMap.put(CLOSE_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!showHideButton.isSelected()) {
                    return;
                }
                showHideButton.doClick(0);
                containerComponent.requestFocusInWindow();
            }
        });
    }

    @NotNull
    public static CommonToggleButton createFilterToggleButton() {
        CommonToggleButton filterButton = new CommonToggleButton("", AllIcons.General.Filter);
        filterButton.setToolTipText(String.format("Filter (%s)", KeymapUtil.getKeystrokeText((KeyStroke)FilterComponent.getFilterKeyStroke())));
        return filterButton;
    }

    private static KeyStroke getFilterKeyStroke() {
        return KeyStroke.getKeyStroke(70, AdtUiUtils.getActionMask());
    }
}

