/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestTreeStructure;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilderBase;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.util.Alarm;
import javax.swing.JTree;

public class GoogleCloudTestTreeBuilder
implements Disposable,
AbstractTestTreeBuilderBase<AbstractTestProxy> {
    private final JTree myTree;
    private final GoogleCloudTestTreeStructure myTreeStructure;
    private boolean myDisposed;
    private StructureTreeModel myTreeModel;
    private final Alarm mySelectionAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);

    public GoogleCloudTestTreeBuilder(JTree tree, GoogleCloudTestTreeStructure structure) {
        this.myTree = tree;
        this.myTreeStructure = structure;
    }

    public GoogleCloudTestTreeStructure getGoogleCloudTestTreeStructure() {
        return this.myTreeStructure;
    }

    public void updateTestsSubtree(GoogleCloudTestProxy parentTestProxy) {
        this.getTreeModel().invalidate((Object)parentTestProxy, true);
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public JTree getTree() {
        return this.myTree;
    }

    public void updateFromRoot() {
        this.myTreeModel.invalidateAsync();
    }

    public void setModel(StructureTreeModel asyncTreeModel) {
        this.myTreeModel = asyncTreeModel;
    }

    public void select(Object proxy, Runnable onDone) {
        if (!(proxy instanceof AbstractTestProxy)) {
            return;
        }
        this.mySelectionAlarm.cancelAllRequests();
        this.mySelectionAlarm.addRequest(() -> this.getTreeModel().select(proxy, this.getTree(), path -> {
            if (onDone != null) {
                onDone.run();
            }
        }), 50);
    }

    public GoogleCloudTestTreeStructure getTreeStructure() {
        return this.myTreeStructure;
    }

    public void repaintWithParents(AbstractTestProxy testProxy) {
        do {
            this.getTreeModel().invalidate((Object)testProxy, false);
        } while ((testProxy = testProxy.getParent()) != null);
    }

    public void setTestsComparator(TestFrameworkRunningModel model) {
        this.myTreeModel.setComparator(model.createComparator());
    }

    public void dispose() {
        this.myDisposed = true;
    }

    protected StructureTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        GoogleCloudTestTreeStructure treeStructure = this.getTreeStructure();
        Object rootElement = treeStructure.getRootElement();
        Object nodeElement = nodeDescriptor.getElement();
        if (nodeElement == rootElement) {
            return true;
        }
        return ((AbstractTestProxy)nodeElement).getParent() == rootElement && ((AbstractTestProxy)rootElement).getChildren().size() == 1;
    }
}

