/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.CloudMatrixExecutionCancellator;
import com.google.gct.testing.results.GoogleCloudTestEventsProcessor;
import com.google.gct.testing.results.GoogleCloudTestingConsoleView;
import com.google.gct.testing.results.GoogleCloudTestingResultsForm;
import com.google.gct.testing.results.GoogleCloudTestingToSMTRunnerEventsConvertor;
import com.google.gct.testing.results.GoogleCloudTestingUIActionsHandler;
import com.google.gct.testing.results.OutputToGoogleCloudTestEventsConverter;
import com.intellij.execution.Location;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.FileUrlProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestResultsConnectionUtil {
    private static final String TEST_RUNNER_DEBUG_MODE_PROPERTY = "idea.smrunner.debug";

    private GoogleCloudTestResultsConnectionUtil() {
    }

    public static BaseTestsOutputConsoleView createAndAttachConsole(@NotNull String testFrameworkName, @NotNull ProcessHandler processHandler, @NotNull TestConsoleProperties consoleProperties, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        BaseTestsOutputConsoleView console = GoogleCloudTestResultsConnectionUtil.createConsole(testFrameworkName, consoleProperties, matrixExecutionCancellator);
        console.attachToProcess(processHandler);
        return console;
    }

    @NotNull
    public static String getSplitterPropertyName(@NotNull String testFrameworkName) {
        return testFrameworkName + ".Splitter.Proportion";
    }

    public static void initConsoleView(@NotNull GoogleCloudTestingConsoleView consoleView, @NotNull String testFrameworkName, @Nullable SMTestLocator locator, boolean idBasedTreeConstruction, @Nullable TestProxyFilterProvider filterProvider, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        consoleView.addAttachToProcessListener(processHandler -> {
            TestProxyPrinterProvider printerProvider = null;
            if (filterProvider != null) {
                printerProvider = new TestProxyPrinterProvider((BaseTestsOutputConsoleView)consoleView, filterProvider);
            }
            GoogleCloudTestingResultsForm resultsForm = consoleView.getResultsViewer();
            GoogleCloudTestResultsConnectionUtil.attachEventsProcessors(consoleView.getProperties(), resultsForm, processHandler, testFrameworkName, locator, idBasedTreeConstruction, printerProvider, matrixExecutionCancellator);
        });
        consoleView.setHelpId("reference.runToolWindow.testResultsTab");
        consoleView.initUI();
    }

    public static BaseTestsOutputConsoleView createConsole(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        String splitterPropertyName = GoogleCloudTestResultsConnectionUtil.getSplitterPropertyName(testFrameworkName);
        GoogleCloudTestingConsoleView consoleView = new GoogleCloudTestingConsoleView(consoleProperties, splitterPropertyName);
        CompositeTestLocationProvider locator = new CompositeTestLocationProvider(((SMTRunnerConsoleProperties)consoleProperties).getTestLocator());
        GoogleCloudTestResultsConnectionUtil.initConsoleView(consoleView, testFrameworkName, locator, false, null, matrixExecutionCancellator);
        return consoleView;
    }

    public static boolean isInDebugMode() {
        return Boolean.parseBoolean(System.getProperty(TEST_RUNNER_DEBUG_MODE_PROPERTY));
    }

    private static void attachEventsProcessors(@NotNull TestConsoleProperties consoleProperties, GoogleCloudTestingResultsForm resultsViewer, ProcessHandler processHandler, @NotNull String testFrameworkName, @Nullable SMTestLocator locator, boolean idBasedTreeConstruction, @Nullable TestProxyPrinterProvider printerProvider, final @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        final OutputToGoogleCloudTestEventsConverter outputConsumer = new OutputToGoogleCloudTestEventsConverter(testFrameworkName);
        if (idBasedTreeConstruction) {
            throw new RuntimeException("ID-based converter is not supported!");
        }
        final GoogleCloudTestingToSMTRunnerEventsConvertor eventsProcessor = new GoogleCloudTestingToSMTRunnerEventsConvertor(resultsViewer.getTestsRootNode(), testFrameworkName);
        if (locator != null) {
            ((GoogleCloudTestEventsProcessor)eventsProcessor).setLocator(locator);
        }
        if (printerProvider != null) {
            ((GoogleCloudTestEventsProcessor)eventsProcessor).setPrinterProvider(printerProvider);
        }
        GoogleCloudTestingUIActionsHandler uiActionsHandler = new GoogleCloudTestingUIActionsHandler(consoleProperties);
        outputConsumer.setProcessor(eventsProcessor);
        ((GoogleCloudTestEventsProcessor)eventsProcessor).addEventsListener(resultsViewer);
        resultsViewer.addEventsListener(uiActionsHandler);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                matrixExecutionCancellator.cancel();
                outputConsumer.flushBufferBeforeTerminating();
                eventsProcessor.onFinishTesting();
                Disposer.dispose((Disposable)eventsProcessor);
                Disposer.dispose((Disposable)outputConsumer);
            }

            public void startNotified(ProcessEvent event) {
                eventsProcessor.onStartTesting();
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                outputConsumer.process(event.getText(), outputType);
            }
        });
    }

    public static class CompositeTestLocationProvider
    implements SMTestLocator {
        private final SMTestLocator myPrimaryLocator;

        public CompositeTestLocationProvider(@Nullable SMTestLocator primaryLocator) {
            this.myPrimaryLocator = primaryLocator;
        }

        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
            List locations;
            boolean isDumbMode = DumbService.isDumb((Project)project);
            if (!(this.myPrimaryLocator == null || isDumbMode && !(this.myPrimaryLocator instanceof DumbAware) || (locations = this.myPrimaryLocator.getLocation(protocol, path, project, scope)).isEmpty())) {
                return locations;
            }
            if ("file".equals(protocol) && !(locations = FileUrlProvider.INSTANCE.getLocation(protocol, path, project, scope)).isEmpty()) {
                return locations;
            }
            return Collections.emptyList();
        }
    }
}

