/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.tools.idea.run.ValidationError;
import com.google.common.collect.Lists;
import com.google.gct.testing.CloudConfigurationHelper;
import com.google.gct.testing.CloudPersistentConfiguration;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.gct.testing.launcher.CloudAuthenticator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class CloudTargetUtil {
    private CloudTargetUtil() {
    }

    @NotNull
    public static List<ValidationError> validate(@NotNull AndroidFacet facet, @NotNull CloudConfiguration.Kind kind, @NotNull String cloudProjectId, int cloudConfigurationId) {
        ArrayList errors = Lists.newArrayList();
        if (!CloudAuthenticator.isUserLoggedIn()) {
            errors.add(ValidationError.fatal((String)"Not signed in with Google."));
            return errors;
        }
        if (cloudProjectId.isEmpty()) {
            errors.add(ValidationError.fatal((String)"Cloud project not specified."));
        }
        if (cloudConfigurationId == Integer.MAX_VALUE || cloudConfigurationId == 0x7FFFFFFD) {
            return errors;
        }
        CloudPersistentConfiguration selectedConfig = null;
        for (CloudPersistentConfiguration config : CloudConfigurationHelper.getPersistentConfigurations(facet, kind)) {
            if (config.id != cloudConfigurationId) continue;
            selectedConfig = config;
        }
        if (selectedConfig == null) {
            errors.add(ValidationError.fatal((String)"Matrix configuration not specified."));
            return errors;
        }
        if (selectedConfig.devices.isEmpty() || selectedConfig.apiLevels.isEmpty() || selectedConfig.languages.isEmpty() || selectedConfig.orientations.isEmpty()) {
            errors.add(ValidationError.fatal((String)"Selected matrix configuration is empty."));
        }
        return errors;
    }
}

