/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import java.util.function.Predicate;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTAttributeOwner;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemHolder;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAttributeList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCapture;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTClassVirtSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDecltypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDesignator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionWithTryBlock;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTIfStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLambdaExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.gnu.IGCCASTAttributeList;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.formatter.DefaultCodeFormatterOptions;
import org.eclipse.cdt.core.parser.util.IUnaryPredicate;
import org.eclipse.cdt.core.parser.util.InstanceOfPredicate;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.formatter.InactivePosition;
import org.eclipse.cdt.internal.formatter.Scribe;
import org.eclipse.cdt.internal.formatter.align.Alignment;
import org.eclipse.cdt.internal.formatter.align.AlignmentException;
import org.eclipse.cdt.internal.formatter.scanner.Scanner;
import org.eclipse.cdt.internal.formatter.scanner.Token;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterVisitor
extends ASTVisitor
implements ICPPASTVisitor,
ICASTVisitor {
    private static boolean DEBUG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.core/debug/formatter"));
    private final Scanner localScanner;
    private List<InactivePosition> fInactivePreprocessorPositions;
    final DefaultCodeFormatterOptions preferences;
    private final Scribe scribe;
    private boolean fHasClauseInitStatement;
    private boolean fInsideMacroArguments;
    private boolean fExpectSemicolonAfterDeclaration;
    private MultiStatus fStatus;
    private IASTTranslationUnit ast;

    public CodeFormatterVisitor(DefaultCodeFormatterOptions preferences, int offset, int length) {
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitInitializers = true;
        this.shouldVisitParameterDeclarations = true;
        this.shouldVisitDeclarators = true;
        this.shouldVisitDeclSpecifiers = true;
        this.shouldVisitDecltypeSpecifiers = true;
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitTypeIds = true;
        this.shouldVisitEnumerators = true;
        this.shouldVisitTranslationUnit = true;
        this.shouldVisitBaseSpecifiers = true;
        this.shouldVisitNamespaces = true;
        this.shouldVisitTemplateParameters = true;
        this.shouldVisitVirtSpecifiers = true;
        this.fExpectSemicolonAfterDeclaration = true;
        this.localScanner = new Scanner(){

            @Override
            public Token nextToken() {
                Token t = super.nextToken();
                while (t != null && (t.isWhiteSpace() || t.isPreprocessor())) {
                    t = super.nextToken();
                }
                return t;
            }
        };
        this.preferences = preferences;
        this.scribe = new Scribe(this, offset, length);
        this.fInactivePreprocessorPositions = Collections.emptyList();
    }

    public TextEdit format(String string, IASTTranslationUnit unit) {
        long startTime;
        block3: {
            this.scribe.reset();
            startTime = DEBUG ? System.currentTimeMillis() : 0L;
            char[] compilationUnitSource = string.toCharArray();
            this.localScanner.setSource(compilationUnitSource);
            this.scribe.initializeScanner(compilationUnitSource);
            this.fInactivePreprocessorPositions = CodeFormatterVisitor.collectInactiveCodePositions(unit);
            List<InactivePosition> inactive = this.collectNoFormatCodePositions(unit);
            inactive.addAll(this.fInactivePreprocessorPositions);
            this.scribe.setSkipInactivePositions(inactive);
            this.fStatus = new MultiStatus("org.eclipse.cdt.core", 0, "Formatting problem(s) in '" + unit.getFilePath() + "'", null);
            try {
                unit.accept(this);
            }
            catch (RuntimeException e) {
                this.reportFormattingProblem(e);
                if (!DEBUG) break block3;
                return this.failedToFormat(e);
            }
        }
        if (DEBUG) {
            System.out.println("Formatting time: " + (System.currentTimeMillis() - startTime));
        }
        return this.scribe.getRootEdit();
    }

    IStatus getStatus() {
        return this.fStatus;
    }

    private TextEdit failedToFormat(RuntimeException e) {
        if (DEBUG) {
            System.out.println("COULD NOT FORMAT: " + e.getMessage());
            System.out.println(this.scribe.scanner);
            System.out.println(this.scribe);
            System.out.flush();
            System.err.flush();
            e.printStackTrace();
            System.err.flush();
        }
        return null;
    }

    private void reportFormattingProblem(RuntimeException e) {
        String errorMessage = e.getMessage();
        if (errorMessage == null) {
            errorMessage = "Unknown error";
        }
        this.fStatus.add(CodeFormatterVisitor.createStatus(errorMessage, e));
    }

    private static IStatus createStatus(String msg, Throwable e) {
        return new Status(2, "org.eclipse.cdt.core", msg, e);
    }

    @Override
    public int visit(IASTTranslationUnit tu) {
        this.ast = tu;
        this.scribe.lastNumberOfNewLines = 1;
        this.scribe.startNewLine();
        int indentLevel = this.scribe.indentationLevel;
        IASTDeclaration[] decls = tu.getDeclarations();
        this.formatDeclarations(decls, indentLevel);
        this.scribe.printEndOfTranslationUnit();
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private void formatDeclarations(IASTDeclaration[] decls, int indentLevel) {
        macroExpansions = this.ast.getMacroExpansions();
        m = 0;
        i = 0;
        while (i < decls.length) {
            block11: {
                declaration = decls[i];
                if (declaration.isPartOfTranslationUnitFile()) {
                    try {
                        pos = this.getCurrentPosition();
                        declarationLocation = declaration.getFileLocation();
                        declarationOffset = declarationLocation.getNodeOffset();
                        while (m < macroExpansions.length) {
                            macroExpansion = macroExpansions[m];
                            macroLocation = macroExpansion.getFileLocation();
                            macroOffset = macroLocation.getNodeOffset();
                            if (macroOffset > declarationOffset) break;
                            macroEndOffset = macroOffset + macroLocation.getNodeLength();
                            if (this.isFunctionStyleMacroExpansion(macroExpansion) && macroOffset >= pos) {
                                j = i + 1;
                                while (j < decls.length) {
                                    next = decls[j];
                                    if (next.isPartOfTranslationUnitFile()) {
                                        nextLocation = next.getFileLocation();
                                        nextOffset = nextLocation.getNodeOffset();
                                        if (macroEndOffset <= nextOffset) break;
                                        i = j;
                                        declaration = next;
                                        declarationLocation = nextLocation;
                                        declarationOffset = declarationLocation.getNodeOffset();
                                    }
                                    ++j;
                                }
                                declarationEndOffset = declarationOffset + declarationLocation.getNodeLength();
                                if (macroEndOffset <= declarationOffset || macroEndOffset >= declarationEndOffset || macroEndOffset == declarationEndOffset - 1 && this.isSemicolonAtPosition(macroEndOffset)) {
                                    this.scribe.setTailFormatter(new TrailingTokenFormatter(5, macroEndOffset, this.preferences.insert_space_before_semicolon, false));
                                    this.formatFunctionStyleMacroExpansion(macroExpansion);
                                }
                            }
                            ++m;
                        }
                        declaration.accept(this);
                        this.scribe.startNewLine();
                        break block11;
                    }
                    catch (RuntimeException e) {
                        this.reportFormattingProblem(e);
                        if (i >= decls.length - 1) break block11;
                        this.exitAlignments();
                        this.skipToNode(decls[i + 1]);
                        ** while (this.scribe.indentationLevel < indentLevel)
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.scribe.indent();
                        continue;
                    }
lbl49:
                    // 2 sources

                    while (this.scribe.indentationLevel > indentLevel) {
                        this.scribe.unIndent();
                    }
                }
            }
            ++i;
        }
    }

    private boolean isFunctionStyleMacroExpansion(IASTPreprocessorMacroExpansion macroExpansion) {
        IASTName name = macroExpansion.getMacroReference();
        IMacroBinding binding = (IMacroBinding)name.resolveBinding();
        return binding.isFunctionStyle() && binding.getParameterList().length >= 0;
    }

    private void formatFunctionStyleMacroExpansion(IASTPreprocessorMacroExpansion macroExpansion) {
        IASTName name = macroExpansion.getMacroReference();
        IASTFileLocation fileLocation = name.getFileLocation();
        if (fileLocation != null) {
            this.scribe.printRaw(fileLocation.getNodeOffset(), fileLocation.getNodeLength());
        }
        IMacroBinding binding = (IMacroBinding)name.resolveBinding();
        List<Object> arguments = this.getMacroArguments(binding.getParameterList().length);
        ListOptions options = new ListOptions(this.preferences.alignment_for_arguments_in_method_invocation);
        options.fSeparatorToken = 6;
        options.fSpaceAfterOpeningParen = this.preferences.insert_space_after_opening_paren_in_method_invocation;
        options.fSpaceBeforeClosingParen = this.preferences.insert_space_before_closing_paren_in_method_invocation;
        options.fSpaceBetweenEmptyParen = this.preferences.insert_space_between_empty_parens_in_method_invocation;
        options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_method_invocation_arguments;
        options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_method_invocation_arguments;
        options.fTieBreakRule = 1;
        this.fInsideMacroArguments = true;
        try {
            this.formatList(arguments, options, true, false, this.scribe.takeTailFormatter());
        }
        finally {
            this.fInsideMacroArguments = false;
        }
    }

    private List<Object> getMacroArguments(int expectedNumberOfArguments) {
        int token;
        ArrayList<TokenRange> argumentRanges = new ArrayList<TokenRange>(expectedNumberOfArguments);
        TokenRange currentArgument = null;
        this.localScanner.resetTo(this.getCurrentPosition(), this.scribe.scannerEndPosition);
        this.localScanner.getNextToken();
        int parenLevel = 0;
        while ((token = this.localScanner.getNextToken()) != -1) {
            int tokenOffset = this.localScanner.getCurrentTokenStartPosition();
            if (parenLevel == 0 && (token == 6 || token == 9)) {
                if (currentArgument != null) {
                    argumentRanges.add(currentArgument);
                    currentArgument = null;
                } else {
                    argumentRanges.add(new TokenRange(tokenOffset, tokenOffset));
                }
                if (token != 9) continue;
                break;
            }
            int tokenEndOffset = this.localScanner.getCurrentPosition();
            if (currentArgument == null) {
                currentArgument = new TokenRange(tokenOffset, tokenEndOffset);
            } else {
                currentArgument.endOffset = tokenEndOffset;
            }
            switch (token) {
                case 8: {
                    ++parenLevel;
                    break;
                }
                case 9: {
                    if (parenLevel <= 0) break;
                    --parenLevel;
                }
            }
        }
        ArrayList<Object> arguments = new ArrayList<Object>(argumentRanges.size());
        IASTNodeSelector nodeSelector = this.ast.getNodeSelector(null);
        for (TokenRange argument : argumentRanges) {
            IASTNode node = nodeSelector.findNodeInExpansion(argument.getOffset(), argument.getLength());
            if (node != null) {
                arguments.add(node);
                continue;
            }
            arguments.add(argument);
        }
        return arguments;
    }

    @Override
    public int visit(IASTDeclaration node) {
        if (!this.enterNode(node)) {
            return 1;
        }
        int result = this.formatDeclaration(node);
        this.exitNode(node);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private int formatDeclaration(IASTDeclaration node) {
        block17: {
            indentLevel = this.scribe.indentationLevel;
            try {
                if (node instanceof IASTFunctionDefinition) {
                    return this.visit((IASTFunctionDefinition)node);
                }
                if (node instanceof IASTSimpleDeclaration) {
                    return this.visit((IASTSimpleDeclaration)node);
                }
                if (node instanceof IASTASMDeclaration) {
                    return this.visit((IASTASMDeclaration)node);
                }
                if (node instanceof ICPPASTVisibilityLabel) {
                    return this.visit((ICPPASTVisibilityLabel)node);
                }
                if (node instanceof ICPPASTNamespaceDefinition) {
                    return this.visit((ICPPASTNamespaceDefinition)node);
                }
                if (node instanceof ICPPASTNamespaceAlias) {
                    return this.visit((ICPPASTNamespaceAlias)node);
                }
                if (node instanceof ICPPASTUsingDeclaration) {
                    return this.visit((ICPPASTUsingDeclaration)node);
                }
                if (node instanceof ICPPASTUsingDirective) {
                    return this.visit((ICPPASTUsingDirective)node);
                }
                if (node instanceof ICPPASTLinkageSpecification) {
                    return this.visit((ICPPASTLinkageSpecification)node);
                }
                if (node instanceof ICPPASTTemplateDeclaration) {
                    return this.visit((ICPPASTTemplateDeclaration)node);
                }
                if (node instanceof ICPPASTTemplateSpecialization) {
                    return this.visit((ICPPASTTemplateSpecialization)node);
                }
                if (node instanceof ICPPASTExplicitTemplateInstantiation) {
                    return this.visit((ICPPASTExplicitTemplateInstantiation)node);
                }
                if (node instanceof IASTProblemDeclaration) {
                    return this.visit((IASTProblemDeclaration)node);
                }
                this.formatRaw(node);
                break block17;
            }
            catch (ASTProblemException e) {
                if (node instanceof IASTProblemDeclaration) {
                    throw e;
                }
                this.skipNode(node);
                ** while (this.scribe.indentationLevel > indentLevel)
            }
lbl-1000:
            // 1 sources

            {
                this.scribe.unIndent();
                continue;
            }
        }
        return 1;
    }

    @Override
    public int visit(IASTName node) {
        if (!this.enterNode(node)) {
            return 1;
        }
        if (node instanceof ICPPASTQualifiedName) {
            this.visit((ICPPASTQualifiedName)node);
        } else if (node instanceof ICPPASTTemplateId) {
            this.visit((ICPPASTTemplateId)node);
        } else {
            this.formatRaw(node);
        }
        this.exitNode(node);
        return 1;
    }

    @Override
    public int visit(IASTInitializer node) {
        if (node instanceof ICPPASTConstructorInitializer) {
            return this.visit((ICPPASTConstructorInitializer)node);
        }
        if (this.peekNextToken() == 38) {
            this.scribe.printNextToken(38, this.preferences.insert_space_before_assignment_operator);
            if (this.preferences.insert_space_after_assignment_operator) {
                this.scribe.space();
            }
        }
        if (!this.enterNode(node)) {
            return 1;
        }
        if (node instanceof IASTEqualsInitializer) {
            this.visit((IASTEqualsInitializer)node);
        } else if (node instanceof IASTInitializerList) {
            this.visit((IASTInitializerList)node);
        } else if (node instanceof ICASTDesignatedInitializer) {
            this.visit((ICASTDesignatedInitializer)node);
        } else if (node instanceof ICPPASTDesignatedInitializer) {
            this.visit((ICPPASTDesignatedInitializer)node);
        } else {
            this.formatRaw(node);
        }
        this.exitNode(node);
        return 1;
    }

    @Override
    public int visit(IASTParameterDeclaration node) {
        IASTDeclarator declarator;
        if (!this.enterNode(node)) {
            return 1;
        }
        IASTDeclSpecifier declSpec = node.getDeclSpecifier();
        if (declSpec != null) {
            declSpec.accept(this);
        }
        if ((declarator = node.getDeclarator()) != null) {
            boolean needSpace;
            boolean bl = needSpace = declarator.getPointerOperators().length > 0 && this.scribe.printComment();
            if (needSpace) {
                this.scribe.space();
            }
            declarator.accept(this);
        }
        this.exitNode(node);
        return 1;
    }

    @Override
    public int visit(IASTDeclarator node) {
        if (!this.enterNode(node)) {
            return 1;
        }
        IASTPointerOperator[] pointerOperators = node.getPointerOperators();
        this.formatPointers(pointerOperators);
        if (node instanceof IASTStandardFunctionDeclarator) {
            if (this.preferences.insert_new_line_before_identifier_in_function_declaration) {
                this.scribe.startNewLine();
            } else if (this.scribe.printCommentPreservingNewLines()) {
                this.scribe.space();
            }
        }
        IASTName name = node.getName();
        IASTDeclarator nestedDecl = node.getNestedDeclarator();
        if (name != null && name.getSimpleID().length != 0 || nestedDecl != null) {
            if (node.getPropertyInParent() != IASTDeclarator.NESTED_DECLARATOR && this.isFirstDeclarator(node)) {
                if (pointerOperators.length == 0) {
                    this.scribe.space();
                } else {
                    this.scribe.printComment();
                }
            }
            if (name != null) {
                name.accept(this);
            }
        }
        if (nestedDecl != null) {
            this.scribe.printNextToken(8, false);
            nestedDecl.accept(this);
            this.scribe.printNextToken(9, false);
        }
        if (node instanceof ICPPASTFunctionDeclarator) {
            return this.visit((ICPPASTFunctionDeclarator)node);
        }
        if (node instanceof IASTStandardFunctionDeclarator) {
            this.visit((IASTStandardFunctionDeclarator)node);
        } else if (node instanceof ICASTKnRFunctionDeclarator) {
            this.visit((ICASTKnRFunctionDeclarator)node);
        } else if (node instanceof IASTFieldDeclarator) {
            this.visit((IASTFieldDeclarator)node);
        } else if (node instanceof IASTArrayDeclarator) {
            this.visit((IASTArrayDeclarator)node);
        }
        IASTInitializer initializer = node.getInitializer();
        if (initializer != null) {
            initializer.accept(this);
        }
        this.exitNode(node);
        return 1;
    }

    private boolean isFirstDeclarator(IASTDeclarator node) {
        IASTNode parent = node.getParent();
        if (parent instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)parent;
            return simpleDecl.getDeclarators()[0] == node;
        }
        return true;
    }

    @Override
    public int visit(IASTDeclSpecifier node) {
        if (!this.enterNode(node)) {
            return 1;
        }
        if (node instanceof ICPPASTCompositeTypeSpecifier) {
            this.visit((ICPPASTCompositeTypeSpecifier)node);
        } else if (node instanceof ICASTCompositeTypeSpecifier) {
            this.visit((ICASTCompositeTypeSpecifier)node);
        } else if (node instanceof IASTElaboratedTypeSpecifier) {
            this.visit((IASTElaboratedTypeSpecifier)node);
        } else if (node instanceof IASTEnumerationSpecifier) {
            this.visit((IASTEnumerationSpecifier)node);
        } else if (node instanceof IASTSimpleDeclSpecifier) {
            this.visit((IASTSimpleDeclSpecifier)node);
        } else if (node instanceof IASTNamedTypeSpecifier) {
            this.visit((IASTNamedTypeSpecifier)node);
        } else {
            this.formatRaw(node);
        }
        this.exitNode(node);
        return 1;
    }

    @Override
    public int visit(ICPPASTDecltypeSpecifier node) {
        this.formatRaw(node);
        return 1;
    }

    @Override
    public int visit(IASTExpression node) {
        if (!this.enterNode(node)) {
            return 1;
        }
        if (node instanceof IASTArraySubscriptExpression) {
            this.visit((IASTArraySubscriptExpression)node);
        } else if (node instanceof IASTConditionalExpression) {
            this.visit((IASTConditionalExpression)node);
        } else if (node instanceof IASTFunctionCallExpression) {
            this.visit((IASTFunctionCallExpression)node);
        } else if (node instanceof IASTExpressionList) {
            this.visit((IASTExpressionList)node);
        } else if (node instanceof IASTTypeIdExpression) {
            this.visit((IASTTypeIdExpression)node);
        } else if (node instanceof IASTBinaryExpression) {
            this.visit((IASTBinaryExpression)node);
        } else if (node instanceof IASTLiteralExpression) {
            this.visit((IASTLiteralExpression)node);
        } else if (node instanceof IASTIdExpression) {
            this.visit((IASTIdExpression)node);
        } else if (node instanceof IASTCastExpression) {
            this.visit((IASTCastExpression)node);
        } else if (node instanceof IASTUnaryExpression) {
            this.visit((IASTUnaryExpression)node);
        } else if (node instanceof IASTFieldReference) {
            this.visit((IASTFieldReference)node);
        } else if (node instanceof IASTTypeIdInitializerExpression) {
            this.visit((IASTTypeIdInitializerExpression)node);
        } else if (node instanceof ICPPASTNewExpression) {
            this.visit((ICPPASTNewExpression)node);
        } else if (node instanceof ICPPASTDeleteExpression) {
            this.visit((ICPPASTDeleteExpression)node);
        } else if (node instanceof ICPPASTSimpleTypeConstructorExpression) {
            this.visit((ICPPASTSimpleTypeConstructorExpression)node);
        } else if (node instanceof IASTProblemExpression) {
            this.visit((IASTProblemExpression)node);
        } else if (node instanceof ICPPASTLambdaExpression) {
            this.visit((ICPPASTLambdaExpression)node);
        } else {
            this.formatRaw(node);
        }
        this.exitNode(node);
        return 1;
    }

    public int visit(final ICPPASTLambdaExpression node) {
        boolean needSpace;
        int line = this.scribe.line;
        final ListOptions options = this.createListOptionsForLambdaCapturesParameters(node);
        ICPPASTCapture[] captures = node.getCaptures();
        this.formatList(Arrays.asList(captures), options, true, captures.length > 0 && captures[0].isPackExpansion(), null, new Runnable(){

            @Override
            public void run() {
                if (options.captureDefault == ICPPASTLambdaExpression.CaptureDefault.BY_COPY) {
                    CodeFormatterVisitor.this.scribe.printNextToken(38, options.fSpaceAfterOpeningParen);
                } else if (options.captureDefault == ICPPASTLambdaExpression.CaptureDefault.BY_REFERENCE) {
                    CodeFormatterVisitor.this.scribe.printNextToken(30, options.fSpaceAfterOpeningParen);
                }
                if (options.captureDefault != ICPPASTLambdaExpression.CaptureDefault.UNSPECIFIED && node.getCaptures().length > 0) {
                    CodeFormatterVisitor.this.scribe.printNextToken(6, options.fSpaceBeforeSeparator);
                    if (options.fSpaceAfterSeparator) {
                        CodeFormatterVisitor.this.scribe.space();
                    }
                }
            }
        });
        ICPPASTFunctionDeclarator declarator = node.getDeclarator();
        this.skipNonWhitespaceToNode(declarator);
        boolean hasSpace = this.scribe.printComment();
        boolean hasPointerOps = declarator.getPointerOperators().length > 0;
        boolean bl = needSpace = hasPointerOps && hasSpace || !hasPointerOps && this.peekNextToken() == 1;
        if (needSpace) {
            this.scribe.space();
        }
        TrailingTokenFormatter tailFormatter = null;
        IASTCompoundStatement bodyStmt = node.getBody();
        if ("end_of_line".equals(this.preferences.brace_position_for_method_declaration) && bodyStmt instanceof IASTCompoundStatement && !this.startsWithMacroExpansion(bodyStmt)) {
            tailFormatter = new TrailingTokenFormatter(12, this.nodeOffset(bodyStmt), this.preferences.insert_space_before_opening_brace_in_method_declaration, false);
            this.scribe.setTailFormatter(tailFormatter);
        }
        declarator.accept(this);
        IASTAttributeSpecifier[] attributes = declarator.getAttributeSpecifiers();
        if (attributes.length > 0) {
            this.formatAttributes(declarator, true, false);
        }
        if (tailFormatter != null) {
            this.scribe.runTailFormatter();
            this.scribe.setTailFormatter(null);
        }
        Alignment alignment = this.scribe.createAlignment("lambdaExpression", this.preferences.alignment_for_lambda_expression, 2, 1, this.getCurrentPosition());
        this.scribe.enterAlignment(alignment);
        if (bodyStmt instanceof IASTCompoundStatement) {
            if (this.enterNode(bodyStmt)) {
                if (this.getCurrentPosition() <= this.nodeOffset(bodyStmt)) {
                    this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_method_declaration);
                }
                this.formatBlock(bodyStmt, this.preferences.brace_position_for_method_declaration, this.preferences.insert_space_before_opening_brace_in_method_declaration, this.preferences.indent_statements_compare_to_body);
                this.exitNode(bodyStmt);
            }
        } else if (bodyStmt != null) {
            bodyStmt.accept(this);
        }
        this.scribe.printTrailingComment();
        this.scribe.exitAlignment(alignment, true);
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int visit(IASTStatement node) {
        block46: {
            if (this.getCurrentPosition() <= this.nodeOffset(node) && this.startsWithMacroExpansion(node)) {
                this.scribe.printCommentPreservingNewLines();
            }
            if (!this.enterNode(node)) {
                return 1;
            }
            indentLevel = this.scribe.indentationLevel;
            try {
                if (node instanceof IASTCompoundStatement) {
                    this.visit((IASTCompoundStatement)node);
                } else if (node instanceof IASTNullStatement) {
                    this.visit((IASTNullStatement)node);
                } else if (node instanceof IASTDeclarationStatement) {
                    this.visit((IASTDeclarationStatement)node);
                } else if (node instanceof IASTForStatement) {
                    this.visit((IASTForStatement)node);
                } else if (node instanceof ICPPASTRangeBasedForStatement) {
                    this.visit((ICPPASTRangeBasedForStatement)node);
                } else if (node instanceof IASTIfStatement) {
                    this.visit((IASTIfStatement)node);
                } else if (node instanceof ICPPASTCatchHandler) {
                    this.visit((ICPPASTCatchHandler)node);
                } else if (node instanceof ICPPASTTryBlockStatement) {
                    this.visit((ICPPASTTryBlockStatement)node);
                } else if (node instanceof IASTWhileStatement) {
                    this.visit((IASTWhileStatement)node);
                } else if (node instanceof IASTDoStatement) {
                    this.visit((IASTDoStatement)node);
                } else if (node instanceof IASTSwitchStatement) {
                    this.visit((IASTSwitchStatement)node);
                } else if (node instanceof IASTExpressionStatement) {
                    this.visit((IASTExpressionStatement)node);
                } else if (node instanceof IASTContinueStatement) {
                    this.visit((IASTContinueStatement)node);
                } else if (node instanceof IASTReturnStatement) {
                    this.visit((IASTReturnStatement)node);
                } else if (node instanceof IASTBreakStatement) {
                    this.visit((IASTBreakStatement)node);
                } else if (node instanceof IASTCaseStatement) {
                    this.visit((IASTCaseStatement)node);
                } else if (node instanceof IASTDefaultStatement) {
                    this.visit((IASTDefaultStatement)node);
                } else if (node instanceof IASTGotoStatement) {
                    this.visit((IASTGotoStatement)node);
                } else if (node instanceof IASTLabelStatement) {
                    this.visit((IASTLabelStatement)node);
                } else if (node instanceof IASTProblemStatement) {
                    this.visit((IASTProblemStatement)node);
                } else {
                    this.formatRaw(node);
                }
                this.exitNode(node);
                break block46;
            }
            catch (ASTProblemException e) {
                if (node instanceof IASTProblemStatement) {
                    throw e;
                }
                this.skipNode(node);
                ** while (this.scribe.indentationLevel > indentLevel)
            }
lbl-1000:
            // 1 sources

            {
                this.scribe.unIndent();
                continue;
            }
lbl98:
            // 1 sources

            this.exitNode(node);
        }
        return 1;
    }

    @Override
    public int visit(IASTTypeId node) {
        IASTDeclarator declarator;
        if (!this.enterNode(node)) {
            return 1;
        }
        if (node instanceof IASTProblemHolder) {
            throw new ASTProblemException(((IASTProblemHolder)((Object)node)).getProblem());
        }
        IASTDeclSpecifier declSpec = node.getDeclSpecifier();
        if (declSpec != null) {
            declSpec.accept(this);
        }
        if ((declarator = node.getAbstractDeclarator()) != null) {
            boolean needSpace;
            boolean bl = needSpace = declarator.getPointerOperators().length > 0 && this.scribe.printComment();
            if (needSpace) {
                this.scribe.space();
            }
            declarator.accept(this);
        }
        this.exitNode(node);
        return 1;
    }

    @Override
    public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        if (!this.enterNode(enumerator)) {
            return 1;
        }
        enumerator.getName().accept(this);
        IASTExpression value = enumerator.getValue();
        if (value != null) {
            this.scribe.printNextToken(38, this.preferences.insert_space_before_assignment_operator);
            if (this.preferences.insert_space_after_assignment_operator) {
                this.scribe.space();
            }
            value.accept(this);
        }
        this.exitNode(enumerator);
        return 1;
    }

    @Override
    public int visit(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier specifier) {
        if (!this.enterNode(specifier)) {
            return 1;
        }
        boolean needSpace = false;
        block3: while (true) {
            int token = this.peekNextToken();
            switch (token) {
                case 98: 
                case 99: 
                case 100: 
                case 122: {
                    this.scribe.printNextToken(token, needSpace);
                    needSpace = true;
                    continue block3;
                }
            }
            break;
        }
        if (needSpace) {
            this.scribe.space();
        }
        specifier.getNameSpecifier().accept(this);
        this.exitNode(specifier);
        return 1;
    }

    @Override
    public int visit(ICPPASTNamespaceDefinition node) {
        boolean isNamedNamespace;
        if (!this.enterNode(node)) {
            return 1;
        }
        int line = this.scribe.line;
        if (node.isInline()) {
            this.scribe.printNextToken(87, false);
            this.scribe.space();
        }
        if (this.peekNextToken() == 3) {
            this.scribe.printNextToken(3, false);
        } else {
            this.scribe.printNextToken(91, false);
            this.scribe.space();
            this.formatLeadingAttributes(node, ICPPASTAttributeList.TYPE_FILTER);
        }
        boolean bl = isNamedNamespace = !CPPVisitor.isAnonymousNamespace(node);
        if (isNamedNamespace) {
            IASTName name = node.getName();
            name.accept(this);
        }
        if (this.peekNextToken() == 3) {
            return 3;
        }
        this.formatAttributes(node, isNamedNamespace, false, IGCCASTAttributeList.TYPE_FILTER);
        IASTDeclaration[] memberDecls = node.getDeclarations();
        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_namespace_declaration);
        this.formatOpeningBrace(this.preferences.brace_position_for_namespace_declaration, this.preferences.insert_space_before_opening_brace_in_namespace_declaration);
        if (this.preferences.indent_body_declarations_compare_to_namespace_header) {
            this.scribe.indent();
        }
        this.scribe.startNewLine();
        this.formatDeclarations(memberDecls, this.scribe.indentationLevel);
        if (this.preferences.indent_body_declarations_compare_to_namespace_header) {
            this.scribe.unIndent();
        }
        this.formatClosingBrace(this.preferences.brace_position_for_namespace_declaration);
        this.exitNode(node);
        return 1;
    }

    private int visit(ICPPASTLinkageSpecification node) {
        this.scribe.printComment();
        int line = this.scribe.line;
        this.scribe.printNextToken(80, false);
        this.scribe.space();
        this.scribe.printNextToken(129);
        IASTDeclaration[] memberDecls = node.getDeclarations();
        if (memberDecls.length == 1 && this.peekNextToken() != 12) {
            this.scribe.space();
            memberDecls[0].accept(this);
        } else {
            this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_linkage_declaration);
            this.formatOpeningBrace(this.preferences.brace_position_for_linkage_declaration, this.preferences.insert_space_before_opening_brace_in_linkage_declaration);
            if (this.preferences.indent_body_declarations_compare_to_linkage) {
                this.scribe.indent();
            }
            this.scribe.startNewLine();
            IASTDeclaration[] iASTDeclarationArray = memberDecls;
            int n = memberDecls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration declaration = iASTDeclarationArray[n2];
                declaration.accept(this);
                this.scribe.startNewLine();
                ++n2;
            }
            if (this.preferences.indent_body_declarations_compare_to_linkage) {
                this.scribe.unIndent();
            }
            this.formatClosingBrace(this.preferences.brace_position_for_linkage_declaration);
        }
        return 1;
    }

    private int visit(ICPPASTNamespaceAlias node) {
        this.scribe.printNextToken(91);
        this.scribe.space();
        node.getAlias().accept(this);
        this.scribe.printNextToken(38, this.preferences.insert_space_before_assignment_operator);
        if (this.preferences.insert_space_after_assignment_operator) {
            this.scribe.space();
        }
        node.getMappingName().accept(this);
        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        return 1;
    }

    private int visit(ICPPASTUsingDeclaration node) {
        int token = this.peekNextToken();
        if (token == 121) {
            this.scribe.printNextToken(token);
        }
        if ((token = this.peekNextToken()) == 118) {
            this.scribe.printNextToken(token, true);
        }
        this.scribe.space();
        node.getName().accept(this);
        token = this.peekNextToken();
        if (token == 5) {
            this.scribe.printNextToken(token, this.preferences.insert_space_before_semicolon);
        }
        return 1;
    }

    private int visit(ICPPASTUsingDirective node) {
        this.scribe.printNextToken(121);
        this.scribe.printNextToken(91, true);
        this.scribe.space();
        node.getQualifiedName().accept(this);
        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        return 1;
    }

    @Override
    public int visit(ICPPASTTemplateParameter node) {
        if (!this.enterNode(node)) {
            return 1;
        }
        try {
            if (node instanceof ICPPASTSimpleTypeTemplateParameter) {
                this.visit((ICPPASTSimpleTypeTemplateParameter)node);
            } else if (node instanceof ICPPASTTemplatedTypeTemplateParameter) {
                this.visit((ICPPASTTemplatedTypeTemplateParameter)node);
            } else {
                this.visit((IASTParameterDeclaration)((Object)node));
            }
            this.exitNode(node);
        }
        catch (ASTProblemException e) {
            this.skipNode(node);
            this.exitNode(node);
        }
        return 1;
    }

    private int visit(ICPPASTSimpleTypeTemplateParameter node) {
        switch (node.getParameterType()) {
            case 1: {
                this.scribe.printNextToken(65);
                this.scribe.space();
                break;
            }
            case 2: {
                this.scribe.printNextToken(118);
                this.scribe.space();
                break;
            }
            default: {
                assert (false) : "Unknown template paramter type";
                this.formatRaw(node);
                return 1;
            }
        }
        node.getName().accept(this);
        IASTTypeId defaultType = node.getDefaultType();
        if (defaultType != null) {
            this.scribe.printNextToken(38, this.preferences.insert_space_before_assignment_operator);
            if (this.preferences.insert_space_after_assignment_operator) {
                this.scribe.space();
            }
            defaultType.accept(this);
        }
        return 1;
    }

    private int visit(ICPPASTTemplatedTypeTemplateParameter node) {
        IASTExpression defaultValue;
        IASTName name;
        ICPPASTTemplateParameter[] templateParameters;
        this.scribe.printNextToken(111, this.scribe.printComment());
        this.scribe.printNextToken(42, this.preferences.insert_space_before_opening_angle_bracket_in_template_parameters);
        if (this.preferences.insert_space_after_opening_angle_bracket_in_template_parameters) {
            this.scribe.space();
        }
        if ((templateParameters = node.getTemplateParameters()).length > 0) {
            ListOptions options = new ListOptions(16);
            options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_template_parameters;
            options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_template_parameters;
            options.fTieBreakRule = 1;
            this.formatList(Arrays.asList(templateParameters), options, false, false, null);
        }
        this.scribe.printNextToken(new int[]{46, 44}, this.preferences.insert_space_before_closing_angle_bracket_in_template_parameters);
        if (this.preferences.insert_space_after_closing_angle_bracket_in_template_parameters) {
            this.scribe.space();
        }
        if ((name = node.getName()) != null) {
            name.accept(this);
        }
        if ((defaultValue = node.getDefaultValue()) != null) {
            this.scribe.printNextToken(38, this.preferences.insert_space_before_assignment_operator);
            if (this.preferences.insert_space_after_assignment_operator) {
                this.scribe.space();
            }
            defaultValue.accept(this);
        }
        return 1;
    }

    private int visit(ICPPASTConstructorInitializer node) {
        if (!this.enterNode(node)) {
            return 1;
        }
        this.formatFunctionCallArguments(node.getArguments());
        this.exitNode(node);
        return 1;
    }

    private int visit(ICPPASTConstructorChainInitializer node) {
        IASTName member = node.getMemberInitializerId();
        IASTInitializer init = node.getInitializer();
        if (member != null && init != null) {
            member.accept(this);
            init.accept(this);
        } else {
            this.formatRaw(node);
        }
        return 1;
    }

    private int visit(IASTFunctionDefinition node) {
        boolean needSpace;
        this.scribe.printComment();
        int line = this.scribe.line;
        IASTDeclSpecifier declSpec = node.getDeclSpecifier();
        declSpec.accept(this);
        IASTFunctionDeclarator declarator = node.getDeclarator();
        this.skipNonWhitespaceToNode(declarator);
        boolean hasSpace = this.scribe.printComment();
        boolean hasPointerOps = declarator.getPointerOperators().length > 0;
        boolean bl = needSpace = hasPointerOps && hasSpace || !hasPointerOps && this.peekNextToken() == 1;
        if (needSpace) {
            this.scribe.space();
        }
        TrailingTokenFormatter tailFormatter = null;
        IASTStatement bodyStmt = node.getBody();
        if ("end_of_line".equals(this.preferences.brace_position_for_method_declaration) && !this.hasMemberInitializers(node) && !(node instanceof ICPPASTFunctionWithTryBlock) && bodyStmt instanceof IASTCompoundStatement && !this.startsWithMacroExpansion(bodyStmt)) {
            tailFormatter = new TrailingTokenFormatter(12, this.nodeOffset(bodyStmt), this.preferences.insert_space_before_opening_brace_in_method_declaration, false);
            this.scribe.setTailFormatter(tailFormatter);
        }
        declarator.accept(this);
        if (node instanceof ICPPASTFunctionWithTryBlock) {
            this.scribe.startNewLine();
            this.scribe.printNextToken(115, false);
            this.scribe.printTrailingComment();
        }
        if (node instanceof ICPPASTFunctionDefinition) {
            ICPPASTFunctionDefinition cppFunctionDefinition = (ICPPASTFunctionDefinition)node;
            ICPPASTConstructorChainInitializer[] constructorChain = cppFunctionDefinition.getMemberInitializers();
            if (constructorChain != null && constructorChain.length > 0) {
                if (this.preferences.insert_new_line_before_colon_in_constructor_initializer_list) {
                    this.scribe.printTrailingComment();
                    this.scribe.startNewLine();
                    this.scribe.indentForContinuation();
                }
                this.scribe.printNextToken(4, !this.preferences.insert_new_line_before_colon_in_constructor_initializer_list);
                if (!this.preferences.insert_new_line_after_colon_in_constructor_initializer_list) {
                    this.scribe.space();
                }
                if (this.preferences.insert_new_line_after_colon_in_constructor_initializer_list) {
                    this.scribe.printTrailingComment();
                    this.scribe.startNewLine();
                    if (!this.preferences.insert_new_line_before_colon_in_constructor_initializer_list) {
                        this.scribe.indentForContinuation();
                    }
                }
                ListOptions options = new ListOptions(this.preferences.alignment_for_constructor_initializer_list);
                options.fTieBreakRule = 1;
                this.formatList(Arrays.asList(constructorChain), options, false, false, null);
                if (this.preferences.insert_new_line_after_colon_in_constructor_initializer_list || this.preferences.insert_new_line_before_colon_in_constructor_initializer_list) {
                    this.scribe.unIndentForContinuation();
                }
            }
            if (cppFunctionDefinition.isDefaulted() || cppFunctionDefinition.isDeleted()) {
                int token = this.peekNextToken();
                if (token == 38) {
                    if (this.preferences.insert_space_before_assignment_operator) {
                        this.scribe.space();
                    }
                    this.scribe.printNextToken(token);
                    if (this.preferences.insert_space_after_assignment_operator) {
                        this.scribe.space();
                    }
                }
                if ((token = this.peekNextToken()) == 71 || token == 72) {
                    this.scribe.printNextToken(token);
                }
                if (bodyStmt == null) {
                    tailFormatter = new TrailingSemicolonFormatter(node);
                    this.scribe.setTailFormatter(tailFormatter);
                }
            }
        }
        if (tailFormatter != null) {
            this.scribe.runTailFormatter();
            this.scribe.setTailFormatter(null);
        }
        if (bodyStmt instanceof IASTCompoundStatement) {
            if (this.enterNode(bodyStmt)) {
                if (this.getCurrentPosition() <= this.nodeOffset(bodyStmt)) {
                    this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_method_declaration);
                }
                this.formatBlock((IASTCompoundStatement)bodyStmt, this.preferences.brace_position_for_method_declaration, this.preferences.insert_space_before_opening_brace_in_method_declaration, this.preferences.indent_statements_compare_to_body);
                this.exitNode(bodyStmt);
            }
        } else if (bodyStmt != null) {
            bodyStmt.accept(this);
        }
        this.scribe.printTrailingComment();
        this.scribe.startNewLine();
        if (node instanceof ICPPASTFunctionWithTryBlock) {
            ICPPASTCatchHandler[] catchHandlers;
            ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = catchHandlers = ((ICPPASTFunctionWithTryBlock)node).getCatchHandlers();
            int n = catchHandlers.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTCatchHandler catchHandler = iCPPASTCatchHandlerArray[n2];
                catchHandler.accept(this);
                this.scribe.printTrailingComment();
                this.scribe.startNewLine();
                ++n2;
            }
        }
        return 1;
    }

    private int visit(IASTASMDeclaration node) {
        this.formatRaw(node);
        return 1;
    }

    private int visit(ICPPASTFunctionDeclarator node) {
        List<ICPPASTParameterDeclaration> parameters = Arrays.asList(node.getParameters());
        ListOptions options = this.createListOptionsForFunctionDeclarationParameters();
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        this.formatList(parameters, options, true, node.takesVarArgs(), new FunctionDeclaratorTailFormatter(node, tailFormatter));
        return 1;
    }

    private void formatExceptionSpecification(IASTTypeId[] exceptionSpecification) {
        if (exceptionSpecification.length > 0) {
            Alignment alignment = this.scribe.createAlignment("exceptionSpecification", this.preferences.alignment_for_throws_clause_in_method_declaration, exceptionSpecification.length, this.getCurrentPosition());
            this.scribe.enterAlignment(alignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(alignment, 0);
                    this.scribe.printNextToken(113, true);
                    this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_exception_specification);
                    if (this.preferences.insert_space_after_opening_paren_in_exception_specification) {
                        this.scribe.space();
                    }
                    exceptionSpecification[0].accept(this);
                    int i = 1;
                    while (i < exceptionSpecification.length) {
                        this.scribe.printNextToken(6, this.preferences.insert_space_before_comma_in_method_declaration_throws);
                        this.scribe.printTrailingComment();
                        if (this.preferences.insert_space_after_comma_in_method_declaration_throws) {
                            this.scribe.space();
                        }
                        this.scribe.alignFragment(alignment, i);
                        exceptionSpecification[i].accept(this);
                        ++i;
                    }
                    if (this.peekNextToken() == 9) {
                        this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_exception_specification);
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(alignment, true);
        } else {
            this.scribe.printNextToken(113, true);
            this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_exception_specification);
            this.scribe.printNextToken(9, this.preferences.insert_space_between_empty_parens_in_exception_specification);
        }
    }

    private boolean skipConstVolatileRestrict(boolean spaceBefore) {
        return this.skipTokenWhile(token -> token == 67 || token == 124 || token == 136, spaceBefore);
    }

    private boolean skipMutableConstexpr() {
        return this.skipTokenWhile(token -> token == 90 || token == 5400, true);
    }

    private boolean skipTokenWhile(Predicate<Integer> pred, boolean spaceBefore) {
        boolean skipped = false;
        int token = this.peekNextToken();
        while (pred.test(token)) {
            this.scribe.printNextToken(token, spaceBefore);
            token = this.peekNextToken();
            if (!spaceBefore && pred.test(token)) {
                this.scribe.space();
            }
            skipped = true;
        }
        return skipped;
    }

    private int visit(IASTStandardFunctionDeclarator node) {
        List<IASTParameterDeclaration> parameters = Arrays.asList(node.getParameters());
        ListOptions options = this.createListOptionsForFunctionDeclarationParameters();
        this.formatList(parameters, options, true, node.takesVarArgs(), new TrailingSemicolonFormatter(node));
        return 1;
    }

    private ListOptions createListOptionsForFunctionDeclarationParameters() {
        ListOptions options = new ListOptions(this.preferences.alignment_for_parameters_in_method_declaration);
        options.fSpaceBeforeOpeningParen = this.preferences.insert_space_before_opening_paren_in_method_declaration;
        options.fSpaceAfterOpeningParen = this.preferences.insert_space_after_opening_paren_in_method_declaration;
        options.fSpaceBeforeClosingParen = this.preferences.insert_space_before_closing_paren_in_method_declaration;
        options.fSpaceBetweenEmptyParen = this.preferences.insert_space_between_empty_parens_in_method_declaration;
        options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_method_declaration_parameters;
        options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_method_declaration_parameters;
        options.fTieBreakRule = 1;
        return options;
    }

    private ListOptions createListOptionsForLambdaCapturesParameters(ICPPASTLambdaExpression expr) {
        ListOptions options = new ListOptions(this.preferences.alignment_for_parameters_in_method_declaration);
        options.fSpaceBeforeOpeningParen = this.preferences.insert_space_before_opening_paren_in_method_declaration;
        options.fSpaceAfterOpeningParen = this.preferences.insert_space_after_opening_paren_in_method_declaration;
        options.fSpaceBeforeClosingParen = this.preferences.insert_space_before_closing_paren_in_method_declaration;
        options.fSpaceBetweenEmptyParen = this.preferences.insert_space_between_empty_parens_in_method_declaration;
        options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_method_declaration_parameters;
        options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_method_declaration_parameters;
        options.fTieBreakRule = 1;
        options.rightToken = 11;
        options.leftToken = 10;
        options.captureDefault = expr.getCaptureDefault();
        return options;
    }

    private static int getLastNodeCharacterPosition(IASTNode node) {
        IASTNodeLocation lastLocation;
        IASTNodeLocation[] locations = node.getNodeLocations();
        if (locations.length > 0 && !((lastLocation = locations[locations.length - 1]) instanceof IASTMacroExpansionLocation)) {
            IASTFileLocation fileLocation = lastLocation.asFileLocation();
            return fileLocation.getNodeOffset() + fileLocation.getNodeLength() - 1;
        }
        return -1;
    }

    private void formatLeadingAttributes(IASTAttributeOwner owner) {
        this.formatAttributes(owner, false, true);
    }

    private void formatLeadingAttributes(IASTAttributeOwner owner, InstanceOfPredicate<IASTAttributeSpecifier> predicate) {
        this.formatAttributes(owner, false, true, predicate);
    }

    private void formatAttributes(IASTAttributeOwner owner, boolean printLeadingSpace, boolean printTrailingSpace) {
        this.formatAttributes(owner, printLeadingSpace, printTrailingSpace, unsused -> true);
    }

    private void formatAttributes(IASTAttributeOwner owner, boolean printLeadingSpace, boolean printTrailingSpace, IUnaryPredicate<IASTAttributeSpecifier> filter) {
        if (owner == null) {
            return;
        }
        IASTAttributeSpecifier[] attributeSpecifiers = owner.getAttributeSpecifiers();
        if (attributeSpecifiers.length > 0) {
            if (printLeadingSpace) {
                this.scribe.space();
            }
            IASTAttributeSpecifier[] iASTAttributeSpecifierArray = attributeSpecifiers;
            int n = attributeSpecifiers.length;
            int n2 = 0;
            while (n2 < n) {
                IASTAttributeSpecifier attributeSpecifier = iASTAttributeSpecifierArray[n2];
                if (filter.apply(attributeSpecifier)) {
                    this.formatRaw(attributeSpecifier);
                }
                ++n2;
            }
            if (printTrailingSpace) {
                this.scribe.space();
            }
        }
    }

    private boolean alignPointer(IASTPointerOperator[] pointers, IASTPointerOperator pointer, int token) {
        boolean firstPtr = pointer == pointers[0];
        boolean lastPtr = pointers.length == 1 || pointer == pointers[pointers.length - 1];
        TrailingTokenFormatter tailFormatter = null;
        IASTNode parent = pointer.getParent();
        boolean needSpace = false;
        if (parent instanceof IASTFunctionDeclarator) {
            tailFormatter = new TrailingTokenFormatter(token, pointer.getParent(), false, true);
            tailFormatter.run();
        } else {
            if (parent instanceof IASTDeclarator) {
                char[] simpleId = ((IASTDeclarator)parent).getName().getSimpleID();
                IASTDeclarator nested = ((IASTDeclarator)parent).getNestedDeclarator();
                if ((simpleId == null || simpleId.length == 0) && nested == null) {
                    needSpace = true;
                    tailFormatter = new TrailingTokenFormatter(token, pointer.getParent(), false, false);
                    tailFormatter.run();
                    return needSpace;
                }
            }
            if (parent != null && parent.getParent() instanceof IASTParameterDeclaration) {
                needSpace = this.preferences.insert_space_after_pointer_in_method_declaration && lastPtr;
                tailFormatter = new TrailingTokenFormatter(token, pointer.getParent(), this.preferences.insert_space_before_pointer_in_method_declaration && firstPtr, this.preferences.insert_space_after_pointer_in_method_declaration && lastPtr);
                tailFormatter.run();
            } else if (parent != null && parent.getParent() instanceof IASTSimpleDeclaration) {
                needSpace = this.preferences.insert_space_after_pointer_in_declarator_list && lastPtr;
                IASTSimpleDeclaration simple = (IASTSimpleDeclaration)parent.getParent();
                IASTDeclarator[] declarators = simple.getDeclarators();
                boolean first = declarators.length == 0 || declarators[0].getPointerOperators() == pointers;
                tailFormatter = new TrailingTokenFormatter(token, pointer.getParent(), first ? this.preferences.insert_space_before_pointer_in_declarator_list && firstPtr : (this.preferences.insert_space_before_pointer_in_declarator_list || this.preferences.insert_space_after_comma_in_declarator_list) && firstPtr, this.preferences.insert_space_after_pointer_in_declarator_list && lastPtr);
                tailFormatter.run();
            } else {
                this.scribe.printNextToken(token, false);
            }
        }
        return needSpace;
    }

    private void formatPointers(IASTPointerOperator[] pointers) {
        IASTPointerOperator[] iASTPointerOperatorArray = pointers;
        int n = pointers.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPointerOperator pointer = iASTPointerOperatorArray[n2];
            if (this.scribe.printComment()) {
                this.scribe.space();
            }
            if (this.scribe.printModifiers()) {
                this.scribe.space();
            }
            if (pointer instanceof ICPPASTReferenceOperator) {
                if (((ICPPASTReferenceOperator)pointer).isRValueReference()) {
                    this.alignPointer(pointers, pointer, 29);
                } else {
                    this.alignPointer(pointers, pointer, 30);
                }
            } else if (pointer instanceof ICPPASTPointerToMember) {
                ICPPASTPointerToMember ptrToMember = (ICPPASTPointerToMember)pointer;
                IASTName name = ptrToMember.getName();
                if (name != null) {
                    name.accept(this);
                }
                this.scribe.printNextToken(23, false);
                if (this.skipConstVolatileRestrict(false)) {
                    this.scribe.space();
                }
            } else {
                boolean needSpace = this.alignPointer(pointers, pointer, 23);
                if (this.skipConstVolatileRestrict(needSpace)) {
                    this.scribe.space();
                }
            }
            ++n2;
        }
    }

    private int visit(ICASTKnRFunctionDeclarator node) {
        List<IASTName> parameters = Arrays.asList(node.getParameterNames());
        ListOptions options = this.createListOptionsForFunctionDeclarationParameters();
        this.formatList(parameters, options, true, false, null);
        IASTDeclaration[] parameterDecls = node.getParameterDeclarations();
        this.scribe.startNewLine();
        this.scribe.indent();
        try {
            IASTDeclaration[] iASTDeclarationArray = parameterDecls;
            int n = parameterDecls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration declaration = iASTDeclarationArray[n2];
                declaration.accept(this);
                ++n2;
            }
        }
        finally {
            this.scribe.unIndent();
        }
        return 1;
    }

    private int visit(IASTFieldDeclarator node) {
        IASTExpression bitFieldSizeExpr = node.getBitFieldSize();
        if (bitFieldSizeExpr != null) {
            this.scribe.printNextToken(4, true);
            bitFieldSizeExpr.accept(this);
        }
        return 1;
    }

    private int visit(IASTArrayDeclarator node) {
        IASTArrayModifier[] arrayModifiers = node.getArrayModifiers();
        if (arrayModifiers != null) {
            IASTArrayModifier[] iASTArrayModifierArray = arrayModifiers;
            int n = arrayModifiers.length;
            int n2 = 0;
            while (n2 < n) {
                boolean emptyBrackets;
                block12: {
                    IASTArrayModifier arrayModifier = iASTArrayModifierArray[n2];
                    this.scribe.printNextToken(10, this.preferences.insert_space_before_opening_bracket);
                    boolean bl = emptyBrackets = arrayModifier.getConstantExpression() == null && !(arrayModifier instanceof ICASTArrayModifier);
                    if (!emptyBrackets && this.preferences.insert_space_after_opening_bracket) {
                        this.scribe.space();
                    }
                    if (arrayModifier instanceof ICASTArrayModifier) {
                        ICASTArrayModifier cArrayModifier = (ICASTArrayModifier)arrayModifier;
                        if (this.scribe.printModifiers()) {
                            this.scribe.space();
                        }
                        if (cArrayModifier.isVariableSized()) {
                            this.scribe.printNextToken(23, this.scribe.printComment());
                        }
                        if (this.scribe.printComment()) {
                            this.scribe.space();
                        }
                    }
                    Runnable tailFormatter = this.scribe.takeTailFormatter();
                    try {
                        try {
                            arrayModifier.accept(this);
                        }
                        catch (ASTProblemException e) {
                            this.scribe.skipToToken(11);
                            this.scribe.setTailFormatter(tailFormatter);
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        this.scribe.setTailFormatter(tailFormatter);
                        throw throwable;
                    }
                    this.scribe.setTailFormatter(tailFormatter);
                }
                boolean insertSpace = emptyBrackets ? this.preferences.insert_space_between_empty_brackets : this.preferences.insert_space_before_closing_bracket;
                this.scribe.printNextToken(11, insertSpace);
                ++n2;
            }
        }
        return 1;
    }

    private int visit(IASTSimpleDeclaration node) {
        this.formatLeadingAttributes(node);
        IASTDeclSpecifier declSpec = node.getDeclSpecifier();
        declSpec.accept(this);
        List<IASTDeclarator> declarators = Arrays.asList(node.getDeclarators());
        if (!declarators.isEmpty()) {
            TrailingSemicolonFormatter tailFormatter;
            if (declarators.size() == 1 && declarators.get(0) instanceof IASTFunctionDeclarator) {
                if (this.scribe.printCommentPreservingNewLines()) {
                    this.scribe.space();
                }
            } else if (this.scribe.printComment()) {
                this.scribe.space();
            }
            TrailingSemicolonFormatter trailingSemicolonFormatter = tailFormatter = this.fExpectSemicolonAfterDeclaration ? new TrailingSemicolonFormatter(node) : null;
            if (declarators.size() == 1) {
                if (tailFormatter != null) {
                    this.scribe.setTailFormatter(tailFormatter);
                    try {
                        this.visit(declarators.get(0));
                        this.scribe.runTailFormatter();
                    }
                    finally {
                        this.scribe.setTailFormatter(null);
                    }
                } else {
                    this.visit(declarators.get(0));
                }
            } else {
                ListOptions options = new ListOptions(this.preferences.alignment_for_declarator_list);
                options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_declarator_list;
                options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_declarator_list;
                this.formatList(declarators, options, false, false, tailFormatter);
            }
        }
        return 1;
    }

    private int visit(ICPPASTTemplateDeclaration node) {
        int nextToken;
        ICPPASTTemplateParameter[] templateParameters;
        if (node.isExported()) {
            this.scribe.printNextToken(79);
            this.scribe.space();
        }
        this.scribe.printNextToken(111);
        this.scribe.printNextToken(42, this.preferences.insert_space_before_opening_angle_bracket_in_template_parameters);
        if (this.preferences.insert_space_after_opening_angle_bracket_in_template_parameters) {
            this.scribe.space();
        }
        if ((templateParameters = node.getTemplateParameters()).length > 0) {
            ListOptions options = new ListOptions(16);
            options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_template_parameters;
            options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_template_parameters;
            this.formatList(Arrays.asList(templateParameters), options, false, false, null);
        }
        if ((nextToken = this.peekNextToken()) == 46 || nextToken == 44) {
            this.scribe.printNextToken(new int[]{46, 44}, this.preferences.insert_space_before_closing_angle_bracket_in_template_parameters);
            if (this.preferences.insert_space_after_closing_angle_bracket_in_template_parameters) {
                this.scribe.space();
            }
        }
        IASTDeclaration declaration = node.getDeclaration();
        if (this.preferences.insert_new_line_after_template_declaration) {
            this.scribe.startNewLine();
            if (this.preferences.indent_declaration_compare_to_template_header) {
                this.scribe.indent();
            }
        } else {
            this.scribe.printCommentPreservingNewLines();
        }
        declaration.accept(this);
        if (this.preferences.insert_new_line_after_template_declaration && this.preferences.indent_declaration_compare_to_template_header) {
            this.scribe.unIndent();
        }
        return 1;
    }

    private int visit(ICPPASTTemplateSpecialization node) {
        this.scribe.printNextToken(111);
        this.scribe.printNextToken(42, this.preferences.insert_space_before_opening_angle_bracket_in_template_parameters);
        this.scribe.printNextToken(46, this.scribe.printComment());
        if (this.preferences.insert_space_after_closing_angle_bracket_in_template_parameters) {
            this.scribe.space();
        }
        node.getDeclaration().accept(this);
        return 1;
    }

    private int visit(ICPPASTExplicitTemplateInstantiation node) {
        node.getDeclaration().accept(this);
        return 1;
    }

    private int visit(IASTSimpleDeclSpecifier node) {
        this.formatRaw(node);
        return 1;
    }

    private int visit(IASTNamedTypeSpecifier node) {
        if (this.scribe.printModifiers()) {
            this.scribe.space();
        }
        if (node instanceof ICPPASTNamedTypeSpecifier && ((ICPPASTNamedTypeSpecifier)node).isTypename()) {
            this.scribe.printNextToken(118);
            this.scribe.space();
        }
        node.getName().accept(this);
        return 1;
    }

    private int visit(ICASTCompositeTypeSpecifier node) {
        boolean formatAttributes = false;
        this.scribe.printComment();
        int line = this.scribe.line;
        if (this.scribe.printModifiers()) {
            this.scribe.space();
        }
        if (this.withinMacroExpansion(node, this.getCurrentPosition())) {
            this.scribe.printNextToken(this.peekNextToken());
            this.continueNode(node);
            if (this.scribe.printComment()) {
                this.scribe.space();
            }
        }
        switch (node.getKey()) {
            case 1: {
                this.scribe.printNextToken(109, true);
                break;
            }
            case 2: {
                this.scribe.printNextToken(119, true);
                break;
            }
            default: {
                assert (false) : "Unexpected composite type specifier";
                break;
            }
        }
        IASTName name = node.getName();
        if (name != null) {
            IASTAttributeSpecifier[] attributes = node.getAttributeSpecifiers();
            if (attributes.length > 0) {
                int token = this.peekTokenAtPosition(this.nodeEndOffset(attributes[0]));
                if (token == 12 || name.getFileLocation() != null && this.nodeOffset(name) > this.nodeOffset(attributes[0])) {
                    this.formatAttributes(node, true, false, IGCCASTAttributeList.TYPE_FILTER);
                } else {
                    formatAttributes = true;
                }
            }
            this.scribe.space();
            name.accept(this);
        }
        IASTDeclaration[] memberDecls = node.getMembers();
        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_type_declaration);
        this.formatOpeningBrace(this.preferences.brace_position_for_type_declaration, this.preferences.insert_space_before_opening_brace_in_type_declaration);
        if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
            this.scribe.indent();
        }
        this.scribe.startNewLine();
        IASTDeclaration[] iASTDeclarationArray = memberDecls;
        int n = memberDecls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            declaration.accept(this);
            this.scribe.startNewLine();
            ++n2;
        }
        if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
            this.scribe.unIndent();
        }
        this.formatClosingBrace(this.preferences.brace_position_for_type_declaration);
        if (formatAttributes) {
            this.formatAttributes(node, true, false, IGCCASTAttributeList.TYPE_FILTER);
        }
        return 1;
    }

    private int visit(ICPPASTCompositeTypeSpecifier node) {
        List<ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier> baseSpecifiers;
        ICPPASTClassVirtSpecifier virtSpecifier;
        IASTName name;
        int token;
        boolean formatAttributes = false;
        this.scribe.printComment();
        int line = this.scribe.line;
        if (this.scribe.printModifiers()) {
            this.scribe.space();
        }
        int headerIndent = this.scribe.numberOfIndentations;
        if (this.withinMacroExpansion(node, this.getCurrentPosition())) {
            this.scribe.printNextToken(this.peekNextToken());
            this.continueNode(node);
            if (this.scribe.printComment()) {
                this.scribe.space();
            }
        }
        if ((token = this.peekNextToken()) == 109 || token == 65 || token == 119) {
            this.scribe.printNextToken(token, false);
        }
        if ((name = node.getName()) != null) {
            IASTAttributeSpecifier[] attributes;
            if ((token == 109 || token == 119) && (attributes = node.getAttributeSpecifiers()).length > 0) {
                token = this.peekTokenAtPosition(this.nodeEndOffset(attributes[0]));
                if (token == 12 || name.getFileLocation() != null && this.nodeOffset(name) > this.nodeOffset(attributes[0])) {
                    this.formatAttributes(node, true, false, IGCCASTAttributeList.TYPE_FILTER);
                } else {
                    formatAttributes = true;
                }
            }
            this.scribe.space();
            name.accept(this);
        }
        if ((virtSpecifier = node.getVirtSpecifier()) != null) {
            this.scribe.space();
            virtSpecifier.accept(this);
        }
        if ((baseSpecifiers = Arrays.asList(node.getBaseSpecifiers())).size() > 0) {
            ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier = baseSpecifiers.get(0);
            try {
                if (baseSpecifier.getLeadingSyntax().getType() == 4) {
                    this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_base_clause);
                    if (this.preferences.insert_space_after_colon_in_base_clause) {
                        this.scribe.space();
                    }
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException) {
                // empty catch block
            }
            ListOptions options = new ListOptions(this.preferences.alignment_for_base_clause_in_type_declaration);
            options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_base_types;
            options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_base_types;
            this.formatList(baseSpecifiers, options, false, false, null);
        }
        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_type_declaration);
        this.formatOpeningBrace(this.preferences.brace_position_for_type_declaration, this.preferences.insert_space_before_opening_brace_in_type_declaration);
        int braceIndent = this.scribe.numberOfIndentations;
        if (braceIndent > headerIndent) {
            this.scribe.unIndent();
        }
        if (this.preferences.indent_access_specifier_compare_to_type_header) {
            this.scribe.indent();
        }
        if (this.getCurrentPosition() >= this.nodeEndOffset(node)) {
            return 1;
        }
        this.scribe.startNewLine();
        IASTDeclaration[] memberDecls = node.getMembers();
        int i = 0;
        while (i < memberDecls.length) {
            IASTDeclaration next;
            IASTDeclaration declaration = memberDecls[i];
            if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
                this.scribe.indent();
            }
            this.scribe.printComment();
            if (declaration instanceof ICPPASTVisibilityLabel) {
                if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
                    this.scribe.unIndent();
                }
                next = null;
                if (i < memberDecls.length - 1 && !(memberDecls[i + 1] instanceof IASTProblemHolder)) {
                    next = memberDecls[i + 1];
                }
                if (!(i != memberDecls.length - 1 && next != null && this.doNodeLocationsOverlap(declaration, next) || this.getCurrentPosition() > this.nodeOffset(declaration))) {
                    this.scribe.startNewLine();
                }
                declaration.accept(this);
            } else {
                if (!(declaration instanceof IASTProblemHolder)) {
                    next = null;
                    if (i < memberDecls.length - 1 && !(memberDecls[i + 1] instanceof IASTProblemHolder)) {
                        next = memberDecls[i + 1];
                    }
                    if (!(i != memberDecls.length - 1 && next != null && this.doNodeLocationsOverlap(declaration, next) || this.getCurrentPosition() > this.nodeOffset(declaration))) {
                        this.scribe.startNewLine();
                    }
                    declaration.accept(this);
                } else {
                    this.skipNode(declaration);
                }
                if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
                    this.scribe.unIndent();
                }
            }
            ++i;
        }
        this.scribe.startNewLine();
        if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
            this.scribe.indent();
        }
        this.scribe.printComment();
        if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
            this.scribe.unIndent();
        }
        if (this.preferences.indent_access_specifier_compare_to_type_header) {
            this.scribe.unIndent();
        }
        if (this.scribe.numberOfIndentations < braceIndent) {
            this.scribe.indent();
        }
        this.formatClosingBrace(this.preferences.brace_position_for_type_declaration);
        if (formatAttributes) {
            this.formatAttributes(node, true, false, IGCCASTAttributeList.TYPE_FILTER);
        }
        return 1;
    }

    private int visit(ICPPASTVisibilityLabel node) {
        if (node.getNodeLocations()[0] instanceof IASTMacroExpansionLocation) {
            this.skipNode(node);
        } else {
            this.scribe.printSpaces(this.preferences.indent_access_specifier_extra_spaces);
            switch (node.getVisibility()) {
                case 3: {
                    this.scribe.printNextToken(98, false);
                    break;
                }
                case 2: {
                    this.scribe.printNextToken(99, false);
                    break;
                }
                case 1: {
                    this.scribe.printNextToken(100, false);
                }
            }
            if (this.peekNextToken() != 4) {
                this.scribe.skipToToken(4);
            }
            this.scribe.printNextToken(4, false);
        }
        return 1;
    }

    private int visit(IASTElaboratedTypeSpecifier node) {
        if (this.scribe.printModifiers()) {
            this.scribe.space();
        }
        switch (node.getKind()) {
            case 0: {
                this.scribe.printNextToken(77, false);
                break;
            }
            case 1: {
                this.scribe.printNextToken(109, false);
                break;
            }
            case 2: {
                this.scribe.printNextToken(119, false);
                break;
            }
            case 3: {
                this.scribe.printNextToken(65, false);
                break;
            }
            default: {
                assert (false) : "Unexpected elaborated type specifier";
                break;
            }
        }
        this.scribe.space();
        node.getName().accept(this);
        return 1;
    }

    private int visit(IASTEnumerationSpecifier node) {
        this.scribe.printComment();
        int line = this.scribe.line;
        if (this.scribe.printModifiers()) {
            this.scribe.space();
        }
        int headerIndent = this.scribe.numberOfIndentations;
        this.scribe.printNextToken(77, true);
        IASTName name = node.getName();
        if (name != null) {
            this.scribe.space();
            name.accept(this);
        }
        ICPPASTEnumerationSpecifier cppNode = null;
        if (node instanceof ICPPASTEnumerationSpecifier) {
            cppNode = (ICPPASTEnumerationSpecifier)node;
            this.formatLeadingAttributes(cppNode);
            ICPPASTDeclSpecifier baseType = cppNode.getBaseType();
            if (baseType != null) {
                this.scribe.space();
                this.scribe.printNextToken(4);
                this.scribe.space();
                baseType.accept(this);
            }
        }
        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_type_declaration);
        this.formatOpeningBrace(this.preferences.brace_position_for_type_declaration, this.preferences.insert_space_before_opening_brace_in_type_declaration);
        int braceIndent = this.scribe.numberOfIndentations;
        this.scribe.startNewLine();
        if (braceIndent == headerIndent) {
            this.scribe.indent();
        }
        int enumIndent = this.scribe.numberOfIndentations;
        IASTEnumerationSpecifier.IASTEnumerator[] enumerators = node.getEnumerators();
        ListOptions options = new ListOptions(this.preferences.alignment_for_enumerator_list);
        options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_enum_declarations;
        options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_enum_declarations;
        options.fContinuationIndentation = enumIndent == headerIndent ? 1 : 0;
        this.formatList(Arrays.asList(enumerators), options, false, false, null);
        if (this.peekNextToken() == 6) {
            this.scribe.printNextToken(6, options.fSpaceBeforeSeparator);
            if (options.fSpaceAfterSeparator) {
                this.scribe.space();
            }
        }
        this.scribe.printTrailingComment();
        if (enumIndent > braceIndent) {
            this.scribe.unIndent();
        }
        this.scribe.startNewLine();
        this.formatClosingBrace(this.preferences.brace_position_for_type_declaration);
        return 1;
    }

    private void formatList(List<?> elements, ListOptions options, boolean encloseInParen, boolean addEllipsis, Runnable tailFormatter) {
        this.formatList(elements, options, encloseInParen, addEllipsis, tailFormatter, null);
    }

    private void formatList(List<?> elements, ListOptions options, boolean encloseInParen, boolean addEllipsis, Runnable tailFormatter, Runnable prefix) {
        if (encloseInParen) {
            this.scribe.printNextToken(options.leftToken, options.fSpaceBeforeOpeningParen);
        }
        int elementsLength = elements.size();
        if (encloseInParen) {
            boolean spaceBeforeClosingParen = elements.isEmpty() && !addEllipsis ? options.fSpaceBetweenEmptyParen : options.fSpaceBeforeClosingParen;
            tailFormatter = new ClosingParensesisTailFormatter(spaceBeforeClosingParen, tailFormatter, options.rightToken);
        }
        if (prefix != null) {
            prefix.run();
        }
        if (!elements.isEmpty() || addEllipsis) {
            if (options.fSpaceAfterOpeningParen) {
                this.scribe.space();
            }
            int continuationIndentation = options.fContinuationIndentation >= 0 ? options.fContinuationIndentation : this.preferences.continuation_indentation;
            Alignment alignment = this.scribe.createAlignment("listElements_" + (elements.isEmpty() ? "ellipsis" : elements.get(0).getClass().getSimpleName()), options.fMode, options.fTieBreakRule, elementsLength + (addEllipsis ? 1 : 0), this.getCurrentPosition(), continuationIndentation, false);
            this.scribe.enterAlignment(alignment);
            boolean ok = false;
            do {
                try {
                    int i = 0;
                    while (i < elementsLength) {
                        Object element = elements.get(i);
                        if (i < elementsLength - 1) {
                            this.scribe.setTailFormatter(new TrailingTokenFormatter(options.fSeparatorToken, this.findTokenAfterNodeOrTokenRange(options.fSeparatorToken, element), options.fSpaceBeforeSeparator, options.fSpaceAfterSeparator));
                        } else {
                            this.scribe.setTailFormatter(tailFormatter);
                        }
                        this.scribe.alignFragment(alignment, i);
                        if (element instanceof IASTNode) {
                            if (element instanceof ICPPASTConstructorChainInitializer) {
                                this.visit((ICPPASTConstructorChainInitializer)element);
                            } else {
                                ((IASTNode)element).accept(this);
                            }
                        } else {
                            this.formatTokenRange((TokenRange)element);
                        }
                        if (i < elementsLength - 1) {
                            this.scribe.runTailFormatter();
                        }
                        ++i;
                    }
                    if (addEllipsis) {
                        if (i > 0) {
                            this.scribe.printNextToken(options.fSeparatorToken, options.fSpaceBeforeSeparator);
                            this.scribe.printTrailingComment();
                        }
                        this.scribe.alignFragment(alignment, i);
                        if (i > 0 && options.fSpaceAfterSeparator) {
                            this.scribe.space();
                        }
                        this.scribe.printNextToken(48);
                    }
                    this.scribe.runTailFormatter();
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
                catch (ASTProblemException aSTProblemException) {
                    // empty catch block
                }
            } while (!ok);
            this.scribe.exitAlignment(alignment, true);
        } else if (tailFormatter != null) {
            tailFormatter.run();
        }
    }

    private void formatTokenRange(TokenRange tokenRange) {
        this.scribe.restartAtOffset(tokenRange.getOffset());
        while (this.getCurrentPosition() < tokenRange.getEndOffset()) {
            boolean hasWhitespace = this.scribe.printComment();
            int token = this.peekNextToken();
            this.scribe.printNextToken(token, hasWhitespace);
        }
    }

    private int visit(ICPPASTTryBlockStatement node) {
        ICPPASTCatchHandler[] catchHandlers;
        this.scribe.printNextToken(115, this.scribe.printComment());
        IASTStatement tryBody = node.getTryBody();
        if (tryBody != null) {
            tryBody.accept(this);
        }
        this.scribe.printTrailingComment();
        ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = catchHandlers = node.getCatchHandlers();
        int n = catchHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTCatchHandler catchHandler = iCPPASTCatchHandlerArray[n2];
            catchHandler.accept(this);
            this.scribe.printTrailingComment();
            ++n2;
        }
        return 1;
    }

    private int visit(ICPPASTCatchHandler node) {
        IASTStatement catchBody;
        IASTDeclaration decl;
        int token = this.peekNextToken();
        if (token == 63) {
            if (this.preferences.insert_new_line_before_catch_in_try_statement) {
                this.scribe.startNewLine();
            }
            this.scribe.printNextToken(token, true);
        }
        if ((token = this.peekNextToken()) == 8) {
            this.scribe.printNextToken(token, this.preferences.insert_space_before_opening_paren_in_catch);
            if (this.preferences.insert_space_after_opening_paren_in_catch) {
                this.scribe.space();
            }
        }
        if ((decl = node.getDeclaration()) != null) {
            this.formatInlineDeclaration(decl);
        } else if (node.isCatchAll() && (token = this.peekNextToken()) == 48) {
            this.scribe.printNextToken(token, false);
        }
        token = this.peekNextToken();
        if (token == 9) {
            this.scribe.printNextToken(token, this.preferences.insert_space_before_closing_paren_in_catch);
        }
        if ((catchBody = node.getCatchBody()) != null) {
            catchBody.accept(this);
        }
        return 1;
    }

    private void formatInlineDeclaration(IASTDeclaration decl) {
        this.fExpectSemicolonAfterDeclaration = false;
        try {
            decl.accept(this);
        }
        finally {
            this.fExpectSemicolonAfterDeclaration = true;
        }
    }

    private int visit(IASTCompoundStatement node) {
        this.formatBlock(node, this.preferences.brace_position_for_block, this.preferences.insert_space_before_opening_brace_in_block, this.preferences.indent_statements_compare_to_block);
        return 1;
    }

    private int visit(IASTBreakStatement node) {
        this.formatLeadingAttributes(node);
        this.scribe.printNextToken(61);
        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(IASTConditionalExpression node) {
        int numConditions = 0;
        IASTExpression expression = node;
        while (expression instanceof IASTConditionalExpression) {
            ++numConditions;
            expression = expression.getNegativeResultExpression();
        }
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        Alignment alignment = this.scribe.createAlignment("conditionalExpressionChain", this.preferences.alignment_for_conditional_expression_chain, 1, numConditions, this.getCurrentPosition());
        this.scribe.enterAlignment(alignment);
        boolean ok = false;
        do {
            try {
                IASTConditionalExpression expression2 = node;
                int i = 0;
                while (true) {
                    this.scribe.alignFragment(alignment, i);
                    boolean last = i == numConditions - 1;
                    this.formatConditionalExpression(expression2, last ? tailFormatter : null);
                    if (last) break;
                    expression2 = (IASTConditionalExpression)expression2.getNegativeResultExpression();
                    ++i;
                }
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(alignment, true);
        return 1;
    }

    private void formatConditionalExpression(IASTConditionalExpression node, Runnable tailFormatter) {
        this.scribe.setTailFormatter(new TrailingTokenFormatter(7, node, this.preferences.insert_space_before_question_in_conditional, this.preferences.insert_space_after_question_in_conditional));
        node.getLogicalConditionExpression().accept(this);
        this.scribe.runTailFormatter();
        IASTExpression positiveExpression = node.getPositiveResultExpression();
        IASTExpression negativeExpression = node.getNegativeResultExpression();
        Alignment alignment = this.scribe.createAlignment("conditionalExpression", this.preferences.alignment_for_conditional_expression, 1, negativeExpression instanceof IASTConditionalExpression ? 1 : 2, this.getCurrentPosition());
        this.scribe.enterAlignment(alignment);
        boolean ok = false;
        do {
            try {
                if (positiveExpression != null && this.getCurrentPosition() <= this.nodeOffset(positiveExpression)) {
                    this.scribe.alignFragment(alignment, 0);
                }
                this.scribe.setTailFormatter(new TrailingTokenFormatter(4, node, this.preferences.insert_space_before_colon_in_conditional, this.preferences.insert_space_after_colon_in_conditional));
                if (positiveExpression != null) {
                    positiveExpression.accept(this);
                }
                this.scribe.runTailFormatter();
                if (!(negativeExpression instanceof IASTConditionalExpression)) {
                    if (this.getCurrentPosition() <= this.nodeOffset(negativeExpression)) {
                        this.scribe.alignFragment(alignment, 1);
                    }
                    this.scribe.setTailFormatter(tailFormatter);
                    negativeExpression.accept(this);
                    this.scribe.runTailFormatter();
                }
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(alignment, true);
    }

    private int visit(IASTFunctionCallExpression node) {
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        try {
            node.getFunctionNameExpression().accept(this);
        }
        finally {
            this.scribe.setTailFormatter(tailFormatter);
        }
        IASTInitializerClause[] paramExpr = node.getArguments();
        if (this.peekNextToken() == 1) {
            this.skipNode(node);
        } else {
            this.formatFunctionCallArguments(paramExpr);
        }
        return 1;
    }

    private void formatFunctionCallArguments(IASTInitializerClause[] args) {
        if (this.peekNextToken() != 8 && (args == null || args.length == 0 || this.enclosedInMacroExpansion(args[0]))) {
            return;
        }
        List<Object> expressions = args != null ? Arrays.asList(args) : Collections.emptyList();
        ListOptions options = new ListOptions(this.preferences.alignment_for_arguments_in_method_invocation);
        options.fSeparatorToken = 6;
        options.fSpaceBeforeOpeningParen = this.preferences.insert_space_before_opening_paren_in_method_invocation;
        options.fSpaceAfterOpeningParen = this.preferences.insert_space_after_opening_paren_in_method_invocation;
        options.fSpaceBeforeClosingParen = this.preferences.insert_space_before_closing_paren_in_method_invocation;
        options.fSpaceBetweenEmptyParen = this.preferences.insert_space_between_empty_parens_in_method_invocation;
        options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_method_invocation_arguments;
        options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_method_invocation_arguments;
        options.fTieBreakRule = 1;
        this.formatList(expressions, options, true, false, this.scribe.takeTailFormatter());
    }

    private int visit(IASTExpressionList node) {
        List<IASTExpression> expressions = Arrays.asList(node.getExpressions());
        ListOptions options = new ListOptions(this.preferences.alignment_for_expression_list);
        options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_expression_list;
        options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_expression_list;
        this.formatList(expressions, options, false, false, null);
        return 1;
    }

    private int visit(IASTIdExpression node) {
        node.getName().accept(this);
        return 1;
    }

    private int visit(IASTCastExpression node) {
        Runnable tailFormatter = null;
        switch (node.getOperator()) {
            case 0: {
                this.scribe.printNextToken(8, false);
                if (this.preferences.insert_space_after_opening_paren_in_cast) {
                    this.scribe.space();
                }
                tailFormatter = this.scribe.takeTailFormatter();
                try {
                    node.getTypeId().accept(this);
                }
                finally {
                    this.scribe.setTailFormatter(tailFormatter);
                }
                try {
                    if (node.getTypeId().getTrailingSyntax().getType() == 9) {
                        this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_cast);
                        if (this.preferences.insert_space_after_closing_paren_in_cast) {
                            this.scribe.space();
                        }
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (ExpansionOverlapsBoundaryException exc) {
                    this.scribe.space();
                }
                node.getOperand().accept(this);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.scribe.printNextToken(this.peekNextToken(), false);
                this.scribe.printNextToken(42, this.preferences.insert_space_before_opening_angle_bracket_in_template_arguments);
                if (this.preferences.insert_space_after_opening_angle_bracket_in_template_arguments) {
                    this.scribe.space();
                }
                tailFormatter = this.scribe.takeTailFormatter();
                try {
                    node.getTypeId().accept(this);
                }
                finally {
                    this.scribe.setTailFormatter(tailFormatter);
                }
                this.scribe.printNextToken(46, this.preferences.insert_space_before_closing_angle_bracket_in_template_arguments);
                if (this.preferences.insert_space_before_opening_paren_in_method_invocation) {
                    this.scribe.space();
                }
                this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_method_invocation);
                if (this.preferences.insert_space_after_opening_paren_in_method_invocation) {
                    this.scribe.space();
                }
                tailFormatter = this.scribe.takeTailFormatter();
                try {
                    node.getOperand().accept(this);
                }
                finally {
                    this.scribe.setTailFormatter(tailFormatter);
                }
                this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_method_invocation);
                break;
            }
            default: {
                this.skipToNode(node.getOperand());
            }
        }
        return 1;
    }

    private int visit(IASTTypeIdExpression node) {
        if (this.enclosedInMacroExpansion(node)) {
            return 1;
        }
        this.scribe.printNextToken(this.peekNextToken());
        if (this.peekNextToken() == 48) {
            this.scribe.printNextToken(48);
        }
        this.scribe.printNextToken(8);
        node.getTypeId().accept(this);
        if (this.peekNextToken() == 6) {
            this.scribe.printNextToken(6, this.preferences.insert_space_before_comma_in_method_invocation_arguments);
            this.scribe.printNextToken(this.peekNextToken(), this.preferences.insert_space_after_comma_in_method_invocation_arguments);
            this.scribe.skipToToken(9);
        }
        this.scribe.printNextToken(9);
        return 1;
    }

    private int visit(IASTEqualsInitializer node) {
        if (node.getPropertyInParent() == IASTInitializerList.NESTED_INITIALIZER) {
            assert (false);
        } else {
            Alignment alignment = this.scribe.createAlignment("declarationInitializer", this.preferences.alignment_for_assignment, 2, 1, this.getCurrentPosition());
            Runnable tailFormatter = this.scribe.getTailFormatter();
            this.scribe.enterAlignment(alignment);
            this.scribe.setTailFormatter(tailFormatter);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(alignment, 0);
                    node.getInitializerClause().accept(this);
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(alignment, true);
        }
        return 1;
    }

    private int visit(ICASTDesignatedInitializer node) {
        ICASTDesignator[] designators;
        this.scribe.printComment();
        ICASTDesignator[] iCASTDesignatorArray = designators = node.getDesignators();
        int n = designators.length;
        int n2 = 0;
        while (n2 < n) {
            ICASTDesignator designator = iCASTDesignatorArray[n2];
            designator.accept(this);
            if (this.scribe.printComment()) {
                this.scribe.space();
            }
            ++n2;
        }
        if (this.peekNextToken() == 38) {
            this.scribe.printNextToken(38, this.preferences.insert_space_before_assignment_operator);
            if (this.preferences.insert_space_after_assignment_operator) {
                this.scribe.space();
            }
        }
        Alignment expressionAlignment = this.scribe.createAlignment("designatedInitializer", this.preferences.alignment_for_assignment, 1, this.getCurrentPosition());
        this.scribe.enterAlignment(expressionAlignment);
        boolean ok = false;
        do {
            try {
                this.scribe.alignFragment(expressionAlignment, 0);
                IASTInitializerClause initializer = node.getOperand();
                initializer.accept(this);
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(expressionAlignment, true);
        return 1;
    }

    private int visit(ICPPASTDesignatedInitializer node) {
        ICPPASTDesignator[] designators;
        this.scribe.printComment();
        ICPPASTDesignator[] iCPPASTDesignatorArray = designators = node.getDesignators();
        int n = designators.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTDesignator designator = iCPPASTDesignatorArray[n2];
            designator.accept(this);
            if (this.scribe.printComment()) {
                this.scribe.space();
            }
            ++n2;
        }
        if (this.peekNextToken() == 38) {
            this.scribe.printNextToken(38, this.preferences.insert_space_before_assignment_operator);
            if (this.preferences.insert_space_after_assignment_operator) {
                this.scribe.space();
            }
        }
        Alignment expressionAlignment = this.scribe.createAlignment("designatedInitializer", this.preferences.alignment_for_assignment, 1, this.getCurrentPosition());
        this.scribe.enterAlignment(expressionAlignment);
        boolean ok = false;
        do {
            try {
                this.scribe.alignFragment(expressionAlignment, 0);
                ICPPASTInitializerClause initializer = node.getOperand();
                initializer.accept(this);
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(expressionAlignment, true);
        return 1;
    }

    private int visit(IASTInitializerList node) {
        this.scribe.printComment();
        List<IASTInitializerClause> initializers = Arrays.asList(node.getClauses());
        if (initializers.isEmpty() && this.preferences.keep_empty_initializer_list_on_one_line) {
            this.scribe.printNextToken(12, this.preferences.insert_space_before_opening_brace_in_initializer_list);
            this.scribe.printNextToken(13, this.preferences.insert_space_between_empty_braces_in_initializer_list);
        } else {
            int line = this.scribe.line;
            String brace_position = this.preferences.brace_position_for_initializer_list;
            this.formatLeftCurlyBrace(line, brace_position);
            this.formatOpeningBrace(brace_position, this.preferences.insert_space_before_opening_brace_in_initializer_list);
            if (this.preferences.insert_new_line_after_opening_brace_in_initializer_list) {
                this.scribe.startNewLine();
            }
            if (this.preferences.insert_space_after_opening_brace_in_initializer_list) {
                this.scribe.space();
            }
            ListOptions options = new ListOptions(this.preferences.alignment_for_expressions_in_initializer_list);
            options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_initializer_list;
            options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_initializer_list;
            options.fContinuationIndentation = this.preferences.continuation_indentation_for_initializer_list;
            this.formatList(initializers, options, false, false, null);
            if (this.peekNextToken() == 6) {
                this.scribe.printNextToken(6, options.fSpaceBeforeSeparator);
                if (options.fSpaceAfterSeparator) {
                    this.scribe.space();
                }
            }
            if (this.preferences.insert_new_line_before_closing_brace_in_initializer_list) {
                this.scribe.startNewLine();
            }
            if (this.preferences.insert_space_before_closing_brace_in_initializer_list) {
                this.scribe.space();
            }
            this.formatClosingBrace(brace_position);
        }
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(IASTUnaryExpression node) {
        if (this.enclosedInMacroExpansion(node)) {
            return 1;
        }
        IASTExpression operand = node.getOperand();
        int operator = node.getOperator();
        switch (operator) {
            case 11: {
                this.formatParenthesizedExpression(operand);
                break;
            }
            case 0: 
            case 1: {
                this.scribe.printNextToken(this.peekNextToken(), this.preferences.insert_space_before_prefix_operator);
                if (this.preferences.insert_space_after_prefix_operator) {
                    this.scribe.space();
                }
                operand.accept(this);
                break;
            }
            case 9: 
            case 10: {
                operand.accept(this);
                this.scribe.printNextToken(this.peekNextToken(), this.preferences.insert_space_before_postfix_operator);
                if (!this.preferences.insert_space_after_postfix_operator) break;
                this.scribe.space();
                break;
            }
            case 8: {
                this.scribe.printNextToken(105, this.scribe.printComment());
                if (this.peekNextToken() != 8) {
                    this.scribe.space();
                }
                operand.accept(this);
                break;
            }
            case 16: {
                this.scribe.printNextToken(105, this.scribe.printComment());
                this.scribe.printNextToken(48, this.scribe.printComment());
                this.scribe.printNextToken(8);
                operand.accept(this);
                break;
            }
            case 12: {
                this.scribe.printNextToken(113, this.scribe.printComment());
                if (operand == null) break;
                if (this.peekNextToken() != 8) {
                    this.scribe.space();
                }
                operand.accept(this);
                break;
            }
            case 13: {
                this.scribe.printNextToken(117, this.scribe.printComment());
                if (this.peekNextToken() != 8) {
                    this.scribe.space();
                }
                operand.accept(this);
                break;
            }
            default: {
                int operatorToken = this.peekNextToken();
                boolean forceSpace = Character.isJavaIdentifierStart(this.peekNextChar());
                this.scribe.printNextToken(operatorToken, this.preferences.insert_space_before_unary_operator);
                if (forceSpace || this.preferences.insert_space_after_unary_operator) {
                    this.scribe.space();
                } else if (operatorToken == 1 && this.peekNextToken() != 8) {
                    this.scribe.space();
                }
                operand.accept(this);
            }
        }
        return 1;
    }

    private int visit(IASTBinaryExpression node) {
        if (this.enclosedInMacroExpansion(node)) {
            return 1;
        }
        IASTInitializerClause op2 = node.getOperand2();
        if (op2 == null) {
            op2 = node.getInitOperand2();
        }
        if (this.doNodeLocationsOverlap(node.getOperand1(), op2)) {
            node.getOperand1().accept(this);
            op2.accept(this);
            return 1;
        }
        if (this.isAssignment(node)) {
            return this.formatAssignment(node);
        }
        if (this.isOverloadedLeftShift(node)) {
            return this.formatOverloadedLeftShiftChain(node);
        }
        IASTExpression[] operands = CPPVisitor.getOperandsOfMultiExpression(node);
        Runnable tailFormatter = this.endsWithMacroExpansion(node) ? null : this.scribe.takeTailFormatter();
        Alignment alignment = this.scribe.createAlignment("binaryExpression", this.preferences.alignment_for_binary_expression, 1, operands.length, this.getCurrentPosition());
        this.scribe.enterAlignment(alignment);
        boolean ok = false;
        do {
            try {
                int i = 0;
                while (i < operands.length) {
                    IASTExpression operand = operands[i];
                    if (i > 0 && this.getCurrentPosition() < this.nodeOffset(operand)) {
                        this.scribe.alignFragment(alignment, i);
                        int nextToken = this.peekNextToken();
                        boolean forceSpace = Character.isJavaIdentifierStart(this.peekNextChar());
                        switch (node.getOperator()) {
                            case 30: 
                            case 31: {
                                this.scribe.printNextToken(nextToken, false);
                                break;
                            }
                            default: {
                                this.scribe.printNextToken(nextToken, forceSpace || this.preferences.insert_space_before_binary_operator);
                                if (!forceSpace && !this.preferences.insert_space_after_binary_operator) break;
                                this.scribe.space();
                            }
                        }
                        this.scribe.printTrailingComment();
                    }
                    if (i == alignment.fragmentCount - 1) {
                        this.scribe.setTailFormatter(tailFormatter);
                    }
                    operand.accept(this);
                    this.scribe.restartAtOffset(this.nodeEndOffset(operand));
                    this.scribe.printTrailingComment();
                    ++i;
                }
                this.scribe.runTailFormatter();
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(alignment, true);
        return 1;
    }

    private int formatAssignment(IASTBinaryExpression node) {
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        IASTExpression op1 = node.getOperand1();
        op1.accept(this);
        IASTInitializerClause op2 = node.getOperand2();
        if (op2 == null) {
            op2 = node.getInitOperand2();
        }
        if (this.getCurrentPosition() < this.nodeOffset(op2)) {
            int nextToken = this.peekNextToken();
            boolean forceSpace = Character.isJavaIdentifierStart(this.peekNextChar());
            this.scribe.printNextToken(nextToken, forceSpace || this.preferences.insert_space_before_assignment_operator);
            if (forceSpace || this.preferences.insert_space_after_assignment_operator) {
                this.scribe.space();
            }
        }
        Alignment expressionAlignment = this.scribe.createAlignment("assignmentExpression", this.preferences.alignment_for_assignment, 2, 1, this.getCurrentPosition());
        this.scribe.enterAlignment(expressionAlignment);
        boolean ok = false;
        do {
            try {
                this.scribe.alignFragment(expressionAlignment, 0);
                this.scribe.setTailFormatter(tailFormatter);
                op2 = node.getOperand2();
                if (op2 == null) {
                    op2 = node.getInitOperand2();
                }
                op2.accept(this);
                this.scribe.runTailFormatter();
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(expressionAlignment, true);
        return 1;
    }

    private boolean isAssignment(IASTBinaryExpression node) {
        switch (node.getOperator()) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    private int formatOverloadedLeftShiftChain(IASTBinaryExpression binaryExpression) {
        IASTExpression node;
        ArrayList<IASTExpression> elements = new ArrayList<IASTExpression>();
        do {
            elements.add(binaryExpression.getOperand2());
        } while ((node = binaryExpression.getOperand1()) instanceof IASTBinaryExpression && this.isOverloadedLeftShift(binaryExpression = (IASTBinaryExpression)node));
        Collections.reverse(elements);
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        node.accept(this);
        this.scribe.printComment();
        if (this.preferences.insert_space_before_binary_operator) {
            this.scribe.space();
        }
        Alignment alignment = this.scribe.createAlignment("overloadedLeftShiftChain", this.preferences.alignment_for_overloaded_left_shift_chain, 1, elements.size(), this.getCurrentPosition(), this.preferences.continuation_indentation, false);
        this.scribe.enterAlignment(alignment);
        boolean ok = false;
        do {
            try {
                int i = 0;
                while (i < elements.size()) {
                    node = (IASTExpression)elements.get(i);
                    if (this.getCurrentPosition() < this.nodeOffset(node)) {
                        this.scribe.alignFragment(alignment, i);
                        int token = this.peekNextToken();
                        if (token == 40) {
                            this.scribe.printNextToken(token, this.preferences.insert_space_before_binary_operator);
                            this.scribe.printTrailingComment();
                            if (this.preferences.insert_space_after_binary_operator) {
                                this.scribe.space();
                            }
                        }
                    }
                    if (i == alignment.fragmentCount - 1) {
                        this.scribe.setTailFormatter(tailFormatter);
                    }
                    node.accept(this);
                    ++i;
                }
                this.scribe.runTailFormatter();
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
            catch (ASTProblemException aSTProblemException) {
                // empty catch block
            }
        } while (!ok);
        this.scribe.exitAlignment(alignment, true);
        return 1;
    }

    private boolean isOverloadedLeftShift(IASTBinaryExpression node) {
        return node.getOperator() == 6 && node instanceof ICPPASTBinaryExpression && ((ICPPASTBinaryExpression)node).getOverload() != null;
    }

    private int visit(IASTLiteralExpression node) {
        block11: {
            if (node.getKind() == 3) {
                boolean needSpace = false;
                int line = this.scribe.line;
                boolean indented = false;
                int indentationLevel = this.scribe.indentationLevel;
                int numberOfIndentations = this.scribe.numberOfIndentations;
                try {
                    int[] stringLiterals = new int[]{129, 131, 133};
                    while (true) {
                        this.scribe.printNextToken(stringLiterals, needSpace);
                        int token = this.peekNextToken();
                        if (token != 129 && token != 131 && token != 133) {
                            break block11;
                        }
                        this.scribe.printCommentPreservingNewLines();
                        if (!indented && line != this.scribe.line) {
                            Alignment alignment = this.scribe.currentAlignment;
                            if (alignment != null && (alignment.mode & 2) != 0) {
                                this.scribe.indentationLevel = alignment.breakIndentationLevel;
                            } else if (alignment != null && (alignment.mode & 4) != 0) {
                                indented = true;
                                this.scribe.indent();
                            } else {
                                indented = true;
                                this.scribe.indentForContinuation();
                            }
                        }
                        needSpace = true;
                    }
                }
                finally {
                    this.scribe.indentationLevel = indentationLevel;
                    this.scribe.numberOfIndentations = numberOfIndentations;
                }
            }
            this.scribe.printNextToken(this.peekNextToken());
        }
        return 1;
    }

    private int visit(IASTFieldReference node) {
        IASTName fieldName;
        IASTExpression expr = node.getFieldOwner();
        if (expr != null) {
            Runnable tailFormatter = this.scribe.takeTailFormatter();
            try {
                expr.accept(this);
            }
            finally {
                this.scribe.setTailFormatter(tailFormatter);
            }
        }
        if ((fieldName = node.getFieldName()) != null) {
            Alignment alignment = this.scribe.createAlignment("fieldReference", this.preferences.alignment_for_member_access, 1, 1, this.getCurrentPosition());
            this.scribe.enterAlignment(alignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(alignment, 0);
                    this.scribe.printComment();
                    int token = this.peekNextToken();
                    if (token == 20 || token == 50) {
                        this.scribe.printNextToken(token, false);
                    }
                    this.scribe.printComment();
                    if (node instanceof ICPPASTFieldReference && ((ICPPASTFieldReference)node).isTemplate()) {
                        this.scribe.printNextToken(111);
                        this.scribe.space();
                    }
                    fieldName.accept(this);
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(alignment, true);
        }
        return 1;
    }

    private int visit(IASTArraySubscriptExpression node) {
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        try {
            node.getArrayExpression().accept(this);
            this.scribe.printNextToken(10, this.preferences.insert_space_before_opening_bracket);
            if (this.preferences.insert_space_after_opening_bracket) {
                this.scribe.space();
            }
            node.getArgument().accept(this);
            this.scribe.printNextToken(11, this.preferences.insert_space_before_closing_bracket);
        }
        finally {
            this.scribe.setTailFormatter(tailFormatter);
        }
        return 1;
    }

    private int visit(IASTTypeIdInitializerExpression node) {
        this.scribe.printComment();
        int line = this.scribe.line;
        node.getTypeId().accept(this);
        String brace_position = this.preferences.brace_position_for_initializer_list;
        this.formatLeftCurlyBrace(line, brace_position);
        this.formatOpeningBrace(brace_position, this.preferences.insert_space_before_opening_brace_in_initializer_list);
        if (this.preferences.insert_new_line_after_opening_brace_in_initializer_list) {
            this.scribe.printNewLine();
        }
        if (this.preferences.insert_space_after_opening_brace_in_initializer_list) {
            this.scribe.space();
        }
        node.getInitializer().accept(this);
        if (this.preferences.insert_new_line_before_closing_brace_in_initializer_list) {
            this.scribe.startNewLine();
        }
        if (this.preferences.insert_space_before_closing_brace_in_initializer_list) {
            this.scribe.space();
        }
        this.formatClosingBrace(brace_position);
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(ICPPASTNewExpression node) {
        IASTInitializer newInitializer;
        boolean expectParen;
        if (node.isGlobal()) {
            this.scribe.printNextToken(3);
        }
        this.scribe.printNextToken(92);
        this.scribe.space();
        IASTInitializerClause[] newPlacement = node.getPlacementArguments();
        if (newPlacement != null) {
            Runnable tailFormatter = this.scribe.takeTailFormatter();
            this.formatFunctionCallArguments(newPlacement);
            this.scribe.setTailFormatter(tailFormatter);
        }
        this.scribe.space();
        IASTTypeId typeId = node.getTypeId();
        boolean bl = expectParen = !node.isNewTypeId() && this.peekNextToken() == 8;
        if (expectParen) {
            this.scribe.printNextToken(8, false);
        }
        typeId.accept(this);
        if (expectParen) {
            this.scribe.printNextToken(9);
        }
        if ((newInitializer = node.getInitializer()) != null) {
            this.visit(newInitializer);
        }
        return 1;
    }

    private int visit(ICPPASTDeleteExpression node) {
        if (node.isGlobal()) {
            this.scribe.printNextToken(3);
        }
        this.scribe.printNextToken(72);
        if (node.isVectored()) {
            this.scribe.printNextToken(10, this.preferences.insert_space_before_opening_bracket);
            this.scribe.printNextToken(11, this.preferences.insert_space_between_empty_brackets);
        }
        this.scribe.space();
        node.getOperand().accept(this);
        return 1;
    }

    private int visit(ICPPASTSimpleTypeConstructorExpression node) {
        ICPPASTDeclSpecifier declSpec = node.getDeclSpecifier();
        declSpec.accept(this);
        IASTInitializer initializer = node.getInitializer();
        initializer.accept(this);
        return 1;
    }

    private int visit(IASTContinueStatement node) {
        this.formatLeadingAttributes(node);
        this.scribe.printNextToken(70);
        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(IASTDoStatement node) {
        int token = this.peekNextToken();
        if (token == 73) {
            this.scribe.printNextToken(token);
        }
        int line = this.scribe.line;
        IASTStatement action = node.getBody();
        this.formatAction(line, action, this.preferences.brace_position_for_block);
        if (this.getCurrentPosition() < this.nodeEndOffset(node)) {
            if (this.peekNextToken() == 126) {
                if (this.preferences.insert_new_line_before_while_in_do_statement) {
                    this.scribe.startNewLine();
                }
                this.scribe.printNextToken(126, this.preferences.insert_space_after_closing_brace_in_block);
                this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_while);
                if (this.preferences.insert_space_after_opening_paren_in_while) {
                    this.scribe.space();
                }
                node.getCondition().accept(this);
                this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_while);
            }
            this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        }
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(IASTNullStatement node) {
        if (!this.fHasClauseInitStatement && this.nodeOffset(node) == this.getCurrentPosition()) {
            this.formatAttributes(node, false, false);
            this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
            this.scribe.printTrailingComment();
        }
        return 1;
    }

    private int visit(IASTDeclarationStatement node) {
        node.getDeclaration().accept(this);
        if (!this.fHasClauseInitStatement) {
            this.scribe.startNewLine();
        }
        return 1;
    }

    private int visit(IASTExpressionStatement node) {
        TrailingSemicolonFormatter semicolonFormatter = null;
        semicolonFormatter = new TrailingSemicolonFormatter(node);
        this.scribe.setTailFormatter(semicolonFormatter);
        node.getExpression().accept(this);
        semicolonFormatter.run();
        this.scribe.setTailFormatter(null);
        if (!this.fHasClauseInitStatement) {
            this.scribe.startNewLine();
        }
        return 1;
    }

    private int visit(IASTForStatement node) {
        if (!this.startsWithMacroExpansion(node)) {
            this.scribe.printNextToken(83);
        }
        int line = this.scribe.line;
        IASTStatement initializerStmt = node.getInitializerStatement();
        IASTStatement body = node.getBody();
        Runnable tailFormatter = null;
        if (!this.doNodesHaveSameOffset(node, initializerStmt)) {
            this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_for);
            this.fHasClauseInitStatement = true;
            if (this.preferences.insert_space_after_opening_paren_in_for) {
                this.scribe.space();
            }
            if ("end_of_line".equals(this.preferences.brace_position_for_block) && body instanceof IASTCompoundStatement && !this.startsWithMacroExpansion(body)) {
                tailFormatter = new TrailingTokenFormatter(12, this.nodeOffset(body), this.preferences.insert_space_before_opening_brace_in_block, false);
            }
            tailFormatter = new ClosingParensesisTailFormatter(this.preferences.insert_space_before_closing_paren_in_for, tailFormatter);
        }
        initializerStmt.accept(this);
        if (this.peekNextToken() == 5) {
            this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon_in_for);
        }
        Alignment alignment = this.scribe.createAlignment("for", 16, 1, 2, this.getCurrentPosition());
        this.scribe.enterAlignment(alignment);
        boolean ok = false;
        do {
            try {
                try {
                    IASTDeclaration conditionDecl;
                    this.scribe.alignFragment(alignment, 0);
                    IASTExpression condition = node.getConditionExpression();
                    if (condition != null) {
                        if (this.preferences.insert_space_after_semicolon_in_for) {
                            this.scribe.space();
                        }
                        condition.accept(this);
                    } else if (node instanceof ICPPASTForStatement && (conditionDecl = ((ICPPASTForStatement)node).getConditionDeclaration()) != null) {
                        if (this.preferences.insert_space_after_semicolon_in_for) {
                            this.scribe.space();
                        }
                        conditionDecl.accept(this);
                    }
                    if (this.peekNextToken() == 5) {
                        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon_in_for);
                    }
                    this.scribe.setTailFormatter(tailFormatter);
                    this.scribe.alignFragment(alignment, 1);
                    IASTExpression iterationExpr = node.getIterationExpression();
                    if (iterationExpr != null) {
                        if (this.preferences.insert_space_after_semicolon_in_for) {
                            this.scribe.space();
                        }
                        iterationExpr.accept(this);
                    }
                    if (tailFormatter != null) {
                        this.scribe.runTailFormatter();
                        this.scribe.setTailFormatter(null);
                    }
                }
                finally {
                    this.fHasClauseInitStatement = false;
                }
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(alignment, true);
        if (body instanceof IASTCompoundStatement && !this.startsWithMacroExpansion(body)) {
            if (this.enterNode(body)) {
                if (this.getCurrentPosition() <= this.nodeOffset(body)) {
                    this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_block);
                }
                this.formatBlock((IASTCompoundStatement)body, this.preferences.brace_position_for_block, this.preferences.insert_space_before_opening_brace_in_block, this.preferences.indent_statements_compare_to_block);
                this.exitNode(body);
            }
        } else {
            this.formatAction(line, body, this.preferences.brace_position_for_block);
        }
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(ICPPASTRangeBasedForStatement node) {
        this.scribe.printNextToken(83);
        int line = this.scribe.line;
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_for);
        this.fHasClauseInitStatement = true;
        try {
            if (this.preferences.insert_space_after_opening_paren_in_for) {
                this.scribe.space();
            }
            IASTDeclaration declaration = node.getDeclaration();
            declaration.accept(this);
            this.scribe.printNextToken(4, true);
            IASTInitializerClause initializer = node.getInitializerClause();
            this.scribe.space();
            initializer.accept(this);
        }
        finally {
            this.fHasClauseInitStatement = false;
        }
        if (this.peekNextToken() == 9) {
            this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_for);
        }
        this.formatAction(line, node.getBody(), this.preferences.brace_position_for_block);
        return 1;
    }

    private void beginIfClause() {
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_if);
        if (this.preferences.insert_space_after_opening_paren_in_if) {
            this.scribe.space();
        }
    }

    private int visit(IASTIfStatement node) {
        if (!this.startsWithMacroExpansion(node)) {
            this.scribe.printNextToken(86);
        }
        IASTNode condition = node.getConditionExpression();
        IASTStatement thenStatement = node.getThenClause();
        IASTStatement elseStatement = node.getElseClause();
        this.fExpectSemicolonAfterDeclaration = false;
        try {
            if (node instanceof ICPPASTIfStatement) {
                IASTStatement initStatement;
                ICPPASTIfStatement cppIfStatment = (ICPPASTIfStatement)node;
                if (cppIfStatment.isConstexpr()) {
                    this.scribe.space();
                    this.scribe.printNextToken(5400);
                    this.scribe.space();
                }
                if ((initStatement = cppIfStatment.getInitializerStatement()) != null) {
                    this.beginIfClause();
                    this.fHasClauseInitStatement = true;
                    initStatement.accept(this);
                    if (this.preferences.insert_space_after_semicolon_in_for) {
                        this.scribe.space();
                    }
                }
                if (condition == null) {
                    condition = ((ICPPASTIfStatement)node).getConditionDeclaration();
                }
            }
            if (condition == null || !this.doNodesHaveSameOffset(node, condition)) {
                if (!this.fHasClauseInitStatement) {
                    this.beginIfClause();
                }
                Runnable tailFormatter = null;
                if ("end_of_line".equals(this.preferences.brace_position_for_block) && thenStatement instanceof IASTCompoundStatement && !this.startsWithMacroExpansion(thenStatement)) {
                    tailFormatter = new TrailingTokenFormatter(12, this.nodeOffset(thenStatement), this.preferences.insert_space_before_opening_brace_in_block, false);
                }
                tailFormatter = new ClosingParensesisTailFormatter(this.preferences.insert_space_before_closing_paren_in_if, tailFormatter);
                this.scribe.setTailFormatter(tailFormatter);
                if (condition == null || condition instanceof IASTProblemHolder) {
                    this.scribe.skipToToken(9);
                } else {
                    condition.accept(this);
                }
                this.scribe.runTailFormatter();
                this.scribe.setTailFormatter(null);
            } else if (!(condition instanceof IASTProblemHolder)) {
                condition.accept(this);
            }
        }
        finally {
            this.fHasClauseInitStatement = false;
            this.fExpectSemicolonAfterDeclaration = true;
        }
        boolean thenStatementIsBlock = false;
        if (thenStatement != null) {
            if (condition != null && this.doNodeLocationsOverlap(condition, thenStatement)) {
                thenStatement.accept(this);
            } else if (thenStatement instanceof IASTCompoundStatement && !this.startsWithMacroExpansion(thenStatement)) {
                IASTCompoundStatement block = (IASTCompoundStatement)thenStatement;
                thenStatementIsBlock = true;
                List<IASTStatement> statements = Arrays.asList(block.getStatements());
                if (this.isGuardClause(block, statements) && elseStatement == null && this.preferences.keep_guardian_clause_on_one_line) {
                    if (this.getCurrentPosition() <= this.nodeOffset(thenStatement)) {
                        this.scribe.printNextToken(12, this.preferences.insert_space_before_opening_brace_in_block);
                        this.scribe.space();
                    }
                    statements.get(0).accept(this);
                    this.scribe.printNextToken(13, true);
                    this.scribe.printTrailingComment();
                } else {
                    if (this.getCurrentPosition() <= this.nodeOffset(thenStatement)) {
                        this.formatLeftCurlyBrace(this.scribe.line, this.preferences.brace_position_for_block);
                    }
                    thenStatement.accept(this);
                    if (elseStatement != null && this.preferences.insert_new_line_before_else_in_if_statement) {
                        this.scribe.startNewLine();
                    }
                }
            } else {
                if (this.doNodesHaveSameOffset(node, thenStatement)) {
                    this.enterNode(thenStatement);
                }
                if (elseStatement == null && this.preferences.keep_simple_if_on_one_line) {
                    Alignment compactIfAlignment = this.scribe.createAlignment("compactIf", this.preferences.alignment_for_compact_if, 1, 1, this.getCurrentPosition(), 1, false);
                    this.scribe.enterAlignment(compactIfAlignment);
                    boolean ok = false;
                    do {
                        try {
                            this.scribe.alignFragment(compactIfAlignment, 0);
                            this.scribe.space();
                            thenStatement.accept(this);
                            ok = true;
                        }
                        catch (AlignmentException e) {
                            this.scribe.redoAlignment(e);
                        }
                    } while (!ok);
                    this.scribe.exitAlignment(compactIfAlignment, true);
                } else if (this.preferences.keep_then_statement_on_same_line) {
                    this.scribe.space();
                    thenStatement.accept(this);
                    if (elseStatement != null) {
                        this.scribe.startNewLine();
                    }
                } else if (thenStatement instanceof IASTCompoundStatement && !this.enclosedInMacroExpansion(thenStatement)) {
                    thenStatement.accept(this);
                } else {
                    this.scribe.printTrailingComment();
                    this.scribe.startNewLine();
                    this.scribe.indent();
                    thenStatement.accept(this);
                    if (elseStatement != null) {
                        this.scribe.startNewLine();
                    }
                    this.scribe.unIndent();
                }
            }
        }
        if (elseStatement != null) {
            if (condition != null && this.doNodeLocationsOverlap(condition, elseStatement)) {
                elseStatement.accept(this);
            } else {
                if (this.peekNextToken() == 76) {
                    if (thenStatementIsBlock) {
                        this.scribe.printNextToken(76, this.preferences.insert_space_after_closing_brace_in_block);
                    } else {
                        this.scribe.printNextToken(76, true);
                    }
                }
                if (elseStatement instanceof IASTCompoundStatement && !this.enclosedInMacroExpansion(elseStatement)) {
                    elseStatement.accept(this);
                } else if (elseStatement instanceof IASTIfStatement) {
                    if (!this.preferences.compact_else_if) {
                        this.scribe.startNewLine();
                        this.scribe.indent();
                    }
                    this.scribe.space();
                    elseStatement.accept(this);
                    if (!this.preferences.compact_else_if) {
                        this.scribe.unIndent();
                    }
                } else if (this.preferences.keep_else_statement_on_same_line) {
                    this.scribe.space();
                    elseStatement.accept(this);
                } else {
                    this.scribe.startNewLine();
                    this.scribe.indent();
                    elseStatement.accept(this);
                    this.scribe.unIndent();
                }
            }
        }
        return 1;
    }

    private int visit(ICPPASTQualifiedName node) {
        if (node.isFullyQualified()) {
            this.scribe.printNextToken(3);
        }
        ICPPASTNameSpecifier[] iCPPASTNameSpecifierArray = node.getQualifier();
        int n = iCPPASTNameSpecifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTNameSpecifier nameSpec = iCPPASTNameSpecifierArray[n2];
            nameSpec.accept(this);
            if (this.peekNextToken() == 3) {
                this.scribe.printNextToken(3);
            }
            ++n2;
        }
        if (this.peekNextToken() == 34) {
            this.scribe.printNextToken(34, false);
        }
        node.getLastName().accept(this);
        return 1;
    }

    private int visit(ICPPASTTemplateId node) {
        IASTNode[] templateArguments;
        IASTName name = node.getTemplateName();
        name.accept(this);
        if (this.peekNextToken() == 42) {
            char[] simpleId = name.getSimpleID();
            if (simpleId[simpleId.length - 1] == '<') {
                this.scribe.printNextToken(42, true);
            } else {
                this.scribe.printNextToken(42, this.preferences.insert_space_before_opening_angle_bracket_in_template_arguments);
            }
            if (this.preferences.insert_space_after_opening_angle_bracket_in_template_arguments) {
                this.scribe.space();
            }
        }
        if ((templateArguments = node.getTemplateArguments()).length > 0) {
            ListOptions options = new ListOptions(16);
            options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_template_arguments;
            options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_template_arguments;
            options.fTieBreakRule = 1;
            this.formatList(Arrays.asList(templateArguments), options, false, false, null);
        }
        if (this.peekNextToken() == 44) {
            this.scribe.printComment();
            if (this.preferences.insert_space_before_closing_angle_bracket_in_template_arguments) {
                this.scribe.space();
            }
            return 1;
        }
        int nextToken = this.peekNextToken();
        if (nextToken == 46) {
            this.scribe.printNextToken(46, this.preferences.insert_space_before_closing_angle_bracket_in_template_arguments);
        }
        nextToken = this.peekNextToken();
        if (node.getPropertyInParent() != ICPPASTQualifiedName.SEGMENT_NAME || nextToken == 46) {
            if (nextToken == 8) {
                if (this.preferences.insert_space_before_opening_paren_in_method_invocation) {
                    this.scribe.space();
                }
            } else if (this.preferences.insert_space_after_closing_angle_bracket_in_template_arguments) {
                if (nextToken != 23 && nextToken != 30) {
                    this.scribe.space();
                }
            } else {
                this.scribe.printComment();
                this.scribe.needSpace = false;
                this.scribe.pendingSpace = false;
            }
        }
        return 1;
    }

    @Override
    public int visit(ICPPASTClassVirtSpecifier node) {
        if (node.getKind() == ICPPASTClassVirtSpecifier.SpecifierKind.Final) {
            this.scribe.printNextToken(205);
        }
        return 1;
    }

    private int visit(IASTReturnStatement node) {
        this.formatLeadingAttributes(node);
        this.scribe.printNextToken(103);
        IASTExpression expression = node.getReturnValue();
        if (expression != null) {
            this.scribe.space();
            expression.accept(this);
        }
        if (expression == null && this.peekNextToken() != 5) {
            this.scribe.skipToToken(5);
        }
        if (this.peekNextToken() == 5) {
            this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
            this.scribe.printTrailingComment();
        }
        return 1;
    }

    private int visit(IASTLabelStatement node) {
        int indentationLevel = this.scribe.indentationLevel;
        if (!this.preferences.indent_label_compare_to_statements) {
            this.scribe.indentationLevel = 0;
        }
        this.formatLeadingAttributes(node);
        node.getName().accept(this);
        this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_labeled_statement);
        if (this.preferences.insert_space_after_colon_in_labeled_statement) {
            this.scribe.space();
        }
        if (this.preferences.insert_new_line_after_label) {
            this.scribe.startNewLine();
        }
        this.scribe.indentationLevel = indentationLevel;
        node.getNestedStatement().accept(this);
        return 1;
    }

    private int visit(IASTCaseStatement node) {
        IASTExpression constant = node.getExpression();
        this.formatLeadingAttributes(node);
        if (constant == null) {
            this.scribe.printNextToken(71);
            this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_default);
        } else {
            this.scribe.printNextToken(62);
            this.scribe.space();
            constant.accept(this);
            this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_case);
        }
        return 1;
    }

    private int visit(IASTDefaultStatement node) {
        this.formatLeadingAttributes(node);
        this.scribe.printNextToken(71);
        this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_default);
        return 1;
    }

    private int visit(IASTGotoStatement node) {
        this.formatLeadingAttributes(node);
        this.formatRaw(node);
        return 1;
    }

    private void beginSwitchClause() {
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_switch);
        if (this.preferences.insert_space_after_opening_paren_in_switch) {
            this.scribe.space();
        }
    }

    private int visit(IASTSwitchStatement node) {
        int headerIndent = this.scribe.numberOfIndentations;
        this.formatLeadingAttributes(node);
        if (!this.startsWithMacroExpansion(node)) {
            this.scribe.printNextToken(110);
        }
        IASTNode controller = node.getControllerExpression();
        try {
            if (node instanceof ICPPASTSwitchStatement) {
                ICPPASTSwitchStatement cppSwitchStatement = (ICPPASTSwitchStatement)node;
                IASTStatement initStatement = cppSwitchStatement.getInitializerStatement();
                if (initStatement != null) {
                    this.beginSwitchClause();
                    this.fHasClauseInitStatement = true;
                    initStatement.accept(this);
                    if (this.preferences.insert_space_after_semicolon_in_for) {
                        this.scribe.space();
                    }
                }
                if (controller == null) {
                    controller = cppSwitchStatement.getControllerDeclaration();
                }
            }
            if (!this.doNodesHaveSameOffset(node, controller) && !this.fHasClauseInitStatement) {
                this.beginSwitchClause();
            }
            controller.accept(this);
            if (this.peekNextToken() == 9) {
                this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_switch);
            }
        }
        finally {
            this.fHasClauseInitStatement = false;
        }
        String brace_position = this.preferences.brace_position_for_switch;
        boolean hasOpenBrace = false;
        int braceIndent = -1;
        IASTStatement bodyStmt = node.getBody();
        if (!this.startsWithMacroExpansion(bodyStmt)) {
            boolean insertSpaceBeforeOpeningBrace = this.preferences.insert_space_before_opening_brace_in_switch;
            this.formatAttributes(bodyStmt, insertSpaceBeforeOpeningBrace, false);
            hasOpenBrace = this.peekNextToken() == 12;
            this.formatOpeningBrace(brace_position, insertSpaceBeforeOpeningBrace);
            this.scribe.startNewLine();
            braceIndent = this.scribe.numberOfIndentations;
            if (braceIndent > headerIndent) {
                this.scribe.unIndent();
            }
            if (this.preferences.indent_switchstatements_compare_to_switch) {
                this.scribe.indent();
            }
        }
        List<IASTStatement> statements = bodyStmt instanceof IASTCompoundStatement ? Arrays.asList(((IASTCompoundStatement)bodyStmt).getStatements()) : Collections.singletonList(bodyStmt);
        if (!this.enterNode(bodyStmt)) {
            return 1;
        }
        int statementsLength = statements.size();
        if (statementsLength != 0) {
            boolean wasACase = false;
            boolean wasAStatement = false;
            int i = 0;
            while (i < statementsLength) {
                IASTStatement statement = statements.get(i);
                if (this.doNodeLocationsOverlap(controller, statement)) {
                    statement.accept(this);
                } else {
                    if (statement instanceof IASTCaseStatement || statement instanceof IASTDefaultStatement) {
                        if (wasACase) {
                            this.scribe.startNewLine();
                        }
                        if ((wasACase || wasAStatement) && this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.unIndent();
                        }
                        statement.accept(this);
                        this.scribe.printTrailingComment();
                        wasACase = true;
                        wasAStatement = false;
                        if (this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.indent();
                        }
                    } else if (statement instanceof IASTBreakStatement) {
                        if (this.preferences.indent_breaks_compare_to_cases) {
                            if (!this.preferences.indent_switchstatements_compare_to_cases) {
                                this.scribe.indent();
                            }
                        } else if ((wasACase || wasAStatement) && this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.unIndent();
                        }
                        if (wasACase) {
                            this.scribe.startNewLine();
                        }
                        statement.accept(this);
                        if (this.preferences.indent_breaks_compare_to_cases) {
                            if (!this.preferences.indent_switchstatements_compare_to_cases) {
                                this.scribe.unIndent();
                            }
                        } else if (this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.indent();
                        }
                        wasACase = false;
                        wasAStatement = true;
                    } else if (statement instanceof IASTCompoundStatement && !this.startsWithMacroExpansion(statement)) {
                        IASTStatement nextStatement;
                        String bracePosition;
                        if (wasACase) {
                            if (this.preferences.indent_switchstatements_compare_to_cases) {
                                this.scribe.unIndent();
                            }
                            bracePosition = this.preferences.brace_position_for_block_in_case;
                            try {
                                this.enterNode(statement);
                                this.formatBlock((IASTCompoundStatement)statement, bracePosition, this.preferences.insert_space_after_colon_in_case, this.preferences.indent_statements_compare_to_block);
                                this.exitNode(statement);
                            }
                            catch (ASTProblemException e) {
                                if (i < statementsLength - 1) {
                                    nextStatement = statements.get(i + 1);
                                    this.skipToNode(nextStatement);
                                }
                                this.exitNode(statement);
                            }
                            if (this.preferences.indent_switchstatements_compare_to_cases) {
                                this.scribe.indent();
                            }
                        } else {
                            bracePosition = this.preferences.brace_position_for_block;
                            try {
                                this.enterNode(statement);
                                this.formatBlock((IASTCompoundStatement)statement, bracePosition, this.preferences.insert_space_before_opening_brace_in_block, this.preferences.indent_statements_compare_to_block);
                                this.exitNode(statement);
                            }
                            catch (ASTProblemException e) {
                                if (i < statementsLength - 1) {
                                    nextStatement = statements.get(i + 1);
                                    this.skipToNode(nextStatement);
                                }
                                this.exitNode(statement);
                            }
                        }
                        wasAStatement = true;
                        wasACase = false;
                    } else {
                        block55: {
                            this.scribe.startNewLine();
                            try {
                                statement.accept(this);
                            }
                            catch (ASTProblemException e) {
                                if (i >= statementsLength - 1) break block55;
                                IASTStatement nextStatement = statements.get(i + 1);
                                this.skipToNode(nextStatement);
                            }
                        }
                        wasAStatement = true;
                        wasACase = false;
                    }
                    if (!wasACase) {
                        this.scribe.startNewLine();
                    }
                    this.scribe.printComment();
                }
                ++i;
            }
            if ((wasACase || wasAStatement) && this.preferences.indent_switchstatements_compare_to_cases) {
                this.scribe.unIndent();
            }
        }
        if (!this.startsWithMacroExpansion(bodyStmt)) {
            if (this.preferences.indent_switchstatements_compare_to_switch) {
                this.scribe.unIndent();
            }
            if (this.scribe.numberOfIndentations < braceIndent) {
                this.scribe.indent();
            }
            this.scribe.startNewLine();
            if (hasOpenBrace) {
                this.formatClosingBrace(brace_position);
            }
        }
        this.exitNode(bodyStmt);
        return 1;
    }

    private int visit(IASTWhileStatement node) {
        IASTDeclaration conditionDecl;
        IASTExpression condition;
        this.scribe.printNextToken(126);
        int line = this.scribe.line;
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_while);
        if (this.preferences.insert_space_after_opening_paren_in_while) {
            this.scribe.space();
        }
        if ((condition = node.getCondition()) != null) {
            condition.accept(this);
        } else if (node instanceof ICPPASTWhileStatement && (conditionDecl = ((ICPPASTWhileStatement)node).getConditionDeclaration()) != null) {
            conditionDecl.accept(this);
        }
        if (this.peekNextToken() == 9) {
            this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_while);
        }
        this.formatAction(line, node.getBody(), this.preferences.brace_position_for_block);
        return 1;
    }

    private int visit(IASTProblemStatement node) {
        throw new ASTProblemException(node.getProblem());
    }

    private int visit(IASTProblemExpression node) {
        throw new ASTProblemException(node.getProblem());
    }

    private int visit(IASTProblemDeclaration node) {
        throw new ASTProblemException(node.getProblem());
    }

    private void formatRaw(IASTNode node) {
        this.scribe.printComment();
        this.skipNode(node);
    }

    private void exitAlignments() {
        while (this.scribe.currentAlignment != null) {
            this.scribe.exitAlignment(this.scribe.currentAlignment, true);
        }
    }

    private boolean enterNode(IASTNode node) {
        int currentPosition = this.getCurrentPosition();
        IASTFileLocation nodeLocation = this.getFileLocation(node);
        int nodeEndOffset = -1;
        if (nodeLocation != null && currentPosition > (nodeEndOffset = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength())) {
            return false;
        }
        this.scribe.enterNode();
        if (node instanceof IASTProblemHolder) {
            return false;
        }
        IASTNodeLocation[] locations = node.getNodeLocations();
        if (locations.length == 0) {
            return true;
        }
        if (!this.fInsideMacroArguments && locations[0] instanceof IASTMacroExpansionLocation) {
            IASTPreprocessorMacroExpansion macroExpansion;
            IASTFileLocation macroLocation;
            int macroOffset;
            IASTMacroExpansionLocation location = (IASTMacroExpansionLocation)locations[0];
            if (locations.length <= 2 && (node instanceof IASTStatement || node instanceof IASTExpression) && (macroOffset = (macroLocation = (macroExpansion = location.getExpansion()).getFileLocation()).getNodeOffset()) >= currentPosition && !this.scribe.shouldSkip(macroOffset) && (nodeEndOffset == macroOffset + macroLocation.getNodeLength() || locations.length == 2 && this.isSemicolonLocation(locations[1])) && this.isFunctionStyleMacroExpansion(macroExpansion)) {
                if (locations.length == 2 && this.isSemicolonLocation(locations[1])) {
                    this.scribe.setTailFormatter(new TrailingTokenFormatter(5, locations[1].getNodeOffset(), this.preferences.insert_space_before_semicolon, false));
                }
                this.formatFunctionStyleMacroExpansion(macroExpansion);
                return false;
            }
            IASTFileLocation expansionLocation = location.asFileLocation();
            int startOffset = expansionLocation.getNodeOffset();
            int endOffset = startOffset + expansionLocation.getNodeLength();
            this.scribe.skipRange(startOffset, endOffset);
            if (locations.length == 1 && endOffset <= currentPosition) {
                this.scribe.restartAtOffset(endOffset);
                this.continueNode(node.getParent());
                return false;
            }
        } else if (nodeLocation != null) {
            this.scribe.restartAtOffset(nodeLocation.getNodeOffset());
        }
        return true;
    }

    private IASTFileLocation getFileLocation(IASTNode node) {
        return this.fInsideMacroArguments ? ((ASTNode)node).getImageLocation() : node.getFileLocation();
    }

    private void exitNode(IASTNode node) {
        if (node instanceof IASTProblemHolder) {
            return;
        }
        if (this.scribe.skipRange()) {
            IASTFileLocation fileLocation = this.getFileLocation(node);
            if (fileLocation != null) {
                int nodeEndOffset = fileLocation.getNodeOffset() + fileLocation.getNodeLength();
                this.scribe.restartAtOffset(nodeEndOffset);
            }
        } else if (this.scribe.currentAlignmentException == null) {
            this.skipNode(node);
        }
        this.continueNode(node.getParent());
    }

    private void continueNode(IASTNode node) {
        if (node instanceof IASTProblemHolder || node instanceof IASTTranslationUnit) {
            return;
        }
        IASTFileLocation fileLocation = this.getFileLocation(node);
        if (fileLocation == null) {
            return;
        }
        int nodeOffset = fileLocation.getNodeOffset();
        int nodeEndOffset = nodeOffset + fileLocation.getNodeLength();
        int currentOffset = this.getCurrentPosition();
        if (currentOffset > nodeEndOffset) {
            return;
        }
        if (!this.fInsideMacroArguments) {
            IASTNodeLocation[] locations = node.getNodeLocations();
            int i = 0;
            while (i < locations.length) {
                IASTNodeLocation nodeLocation = locations[i];
                if (nodeLocation instanceof IASTMacroExpansionLocation) {
                    IASTFileLocation expansionLocation = nodeLocation.asFileLocation();
                    int startOffset = expansionLocation.getNodeOffset();
                    int endOffset = startOffset + expansionLocation.getNodeLength();
                    if (currentOffset <= startOffset) break;
                    if (currentOffset < endOffset || currentOffset == endOffset && i == locations.length - 1) {
                        this.scribe.skipRange(startOffset, endOffset);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private int getNextTokenOffset() {
        this.localScanner.resetTo(this.getCurrentPosition(), this.scribe.scannerEndPosition);
        this.localScanner.getNextToken();
        return this.localScanner.getCurrentTokenStartPosition();
    }

    private void skipNode(IASTNode node) {
        int currentOffset;
        int endOffset;
        int restLength;
        IASTFileLocation fileLocation = this.getFileLocation(node);
        if (fileLocation != null && fileLocation.getNodeLength() > 0 && (restLength = (endOffset = fileLocation.getNodeOffset() + fileLocation.getNodeLength()) - (currentOffset = this.getCurrentPosition())) > 0) {
            this.scribe.printRaw(currentOffset, restLength);
        }
    }

    private void skipToNode(IASTNode node) {
        int currentOffset;
        int startOffset;
        int restLength;
        IASTFileLocation fileLocation = this.getFileLocation(node);
        if (fileLocation != null && (restLength = (startOffset = fileLocation.getNodeOffset()) - (currentOffset = this.getCurrentPosition())) > 0) {
            this.scribe.printRaw(currentOffset, restLength);
        }
    }

    private void skipNonWhitespaceToNode(IASTNode node) {
        IASTFileLocation fileLocation = this.getFileLocation(node);
        if (fileLocation != null) {
            int currentOffset;
            int restLength;
            int startOffset = fileLocation.getNodeOffset();
            int nextTokenOffset = this.getNextTokenOffset();
            if (nextTokenOffset < startOffset && (restLength = startOffset - (currentOffset = this.getCurrentPosition())) > 0) {
                this.scribe.printRaw(currentOffset, restLength);
            }
        }
    }

    private void formatParenthesizedExpression(IASTExpression operand) {
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_parenthesized_expression);
        if (this.preferences.insert_space_after_opening_paren_in_parenthesized_expression) {
            this.scribe.space();
        }
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        try {
            if (operand != null) {
                operand.accept(this);
            }
        }
        finally {
            this.scribe.setTailFormatter(tailFormatter);
        }
        if (this.peekNextToken() != 9 && !this.enclosedInMacroExpansion(operand)) {
            this.scribe.skipToToken(9);
        }
        if (this.peekNextToken() == 9) {
            this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_parenthesized_expression);
        }
    }

    private void formatAction(int line, IASTStatement stmt, String brace_position) {
        if (stmt != null) {
            if (stmt instanceof IASTCompoundStatement && !this.startsWithMacroExpansion(stmt)) {
                this.formatLeftCurlyBrace(line, brace_position);
                if (this.enterNode(stmt)) {
                    this.formatBlock((IASTCompoundStatement)stmt, brace_position, this.preferences.insert_space_before_opening_brace_in_block, this.preferences.indent_statements_compare_to_block);
                    this.exitNode(stmt);
                }
            } else if (stmt instanceof IASTNullStatement) {
                this.scribe.indent();
                if (this.preferences.put_empty_statement_on_new_line) {
                    this.scribe.startNewLine();
                }
                stmt.accept(this);
                this.scribe.unIndent();
            } else {
                boolean indented = false;
                if (this.getCurrentPosition() <= this.nodeOffset(stmt)) {
                    this.scribe.printTrailingComment();
                    this.scribe.startNewLine();
                    this.scribe.indent();
                    indented = true;
                }
                stmt.accept(this);
                if (indented) {
                    this.scribe.unIndent();
                }
            }
        }
    }

    private boolean isEmptyStatement(IASTNode node) {
        IASTNodeLocation[] locations = node.getNodeLocations();
        if (locations.length == 1 && node instanceof ASTNode) {
            ASTNode statement = (ASTNode)node;
            IASTFileLocation fileLocation = locations[0].asFileLocation();
            return fileLocation.getNodeLength() == 1 && fileLocation.getNodeOffset() == statement.getOffset();
        }
        return false;
    }

    private boolean startsWithMacroExpansion(IASTNode node) {
        if (this.fInsideMacroArguments) {
            return false;
        }
        IASTNodeLocation[] locations = node.getNodeLocations();
        if (!(node instanceof IASTProblemHolder) && locations.length != 0 && locations[0] instanceof IASTMacroExpansionLocation) {
            IASTFileLocation expansionLocation = locations[0].asFileLocation();
            IASTFileLocation fileLocation = this.getFileLocation(node);
            return expansionLocation.getNodeOffset() == fileLocation.getNodeOffset();
        }
        return false;
    }

    private boolean endsWithMacroExpansion(IASTNode node) {
        if (this.fInsideMacroArguments) {
            return false;
        }
        IASTNodeLocation[] locations = node.getNodeLocations();
        return !(node instanceof IASTProblemHolder) && locations.length != 0 && locations[locations.length - 1] instanceof IASTMacroExpansionLocation;
    }

    private boolean enclosedInMacroExpansion(IASTNode node) {
        if (this.fInsideMacroArguments) {
            return false;
        }
        IASTNodeLocation[] locations = node.getNodeLocations();
        return locations.length == 1 && locations[0] instanceof IASTMacroExpansionLocation;
    }

    private boolean withinMacroExpansion(IASTNode node, int offset) {
        IASTNodeLocation[] locations;
        if (this.fInsideMacroArguments) {
            return false;
        }
        IASTFileLocation loc = this.getFileLocation(node);
        if (loc == null || offset < loc.getNodeOffset() || offset >= loc.getNodeOffset() + loc.getNodeLength()) {
            return false;
        }
        IASTNodeLocation[] iASTNodeLocationArray = locations = node.getNodeLocations();
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNodeLocation location = iASTNodeLocationArray[n2];
            IASTFileLocation fileLocation = location.asFileLocation();
            if (fileLocation != null) {
                int nodeOffset = fileLocation.getNodeOffset();
                int endOffset = nodeOffset + fileLocation.getNodeLength();
                if (offset >= nodeOffset && offset < endOffset) {
                    return location instanceof IASTMacroExpansionLocation;
                }
            }
            ++n2;
        }
        return true;
    }

    private int getCurrentPosition() {
        return this.scribe.scanner.getCurrentPosition();
    }

    private boolean looksLikeStatement(IASTMacroExpansionLocation location) {
        int c;
        IASTFileLocation fileLocation = location.asFileLocation();
        if (fileLocation == null) {
            return false;
        }
        int pos = fileLocation.getNodeOffset() + fileLocation.getNodeLength();
        this.localScanner.resetTo(pos, this.scribe.scannerEndPosition);
        Token token = this.localScanner.nextToken();
        if (token == null || token.getType() != 5) {
            return false;
        }
        this.localScanner.resetTo(pos, token.getOffset());
        while ((c = this.localScanner.getNextChar()) != -1) {
            if (c != 10) continue;
            return false;
        }
        return true;
    }

    private boolean doNodeLocationsOverlap(IASTNode node1, IASTNode node2) {
        IASTFileLocation loc1 = this.getFileLocation(node1);
        IASTFileLocation loc2 = this.getFileLocation(node2);
        return loc1.getNodeOffset() + loc1.getNodeLength() > loc2.getNodeOffset() && loc1.getNodeOffset() < loc2.getNodeOffset() + loc2.getNodeLength();
    }

    private boolean doNodesHaveSameOffset(IASTNode node1, IASTNode node2) {
        return this.nodeOffset(node1) == this.nodeOffset(node2);
    }

    private int nodeOffset(IASTNode node) {
        return this.getFileLocation(node).getNodeOffset();
    }

    private int nodeEndOffset(IASTNode node) {
        IASTFileLocation loc = this.getFileLocation(node);
        return loc.getNodeOffset() + loc.getNodeLength();
    }

    private void formatBlock(IASTCompoundStatement block, String block_brace_position, boolean insertSpaceBeforeOpeningBrace, boolean indentStatements) {
        this.formatBlockOpening(block, block_brace_position, insertSpaceBeforeOpeningBrace);
        this.formatOpenedBlock(block, block_brace_position, indentStatements);
    }

    private void formatBlockOpening(IASTCompoundStatement block, String block_brace_position, boolean insertSpaceBeforeOpeningBrace) {
        if (this.startsWithMacroExpansion(block)) {
            if (!this.looksLikeStatement((IASTMacroExpansionLocation)block.getNodeLocations()[0])) {
                this.scribe.startNewLine();
                this.scribe.printComment();
            }
        } else if (this.getCurrentPosition() <= this.nodeOffset(block)) {
            this.formatOpeningBrace(block_brace_position, insertSpaceBeforeOpeningBrace);
        }
    }

    private void formatOpenedBlock(IASTCompoundStatement block, String block_brace_position, boolean indentStatements) {
        boolean startsWithStatementLikeMacro = this.startsWithMacroExpansion(block) && this.looksLikeStatement((IASTMacroExpansionLocation)block.getNodeLocations()[0]);
        boolean endsWithMacroExpansion = this.endsWithMacroExpansion(block);
        IASTStatement[] statements = block.getStatements();
        int statementsLength = statements.length;
        if (statementsLength != 0) {
            if (!startsWithStatementLikeMacro) {
                this.scribe.startNewLine();
                if (indentStatements) {
                    this.scribe.indent();
                }
            }
            this.formatStatements(Arrays.asList(statements), !endsWithMacroExpansion);
        } else if (!startsWithStatementLikeMacro) {
            if (this.preferences.insert_new_line_in_empty_block) {
                this.scribe.startNewLine();
            }
            if (indentStatements) {
                this.scribe.indent();
            }
        }
        this.scribe.printComment();
        if (indentStatements && !startsWithStatementLikeMacro) {
            this.scribe.unIndent();
        }
        if (!endsWithMacroExpansion) {
            this.formatClosingBrace(block_brace_position);
        } else if (!this.startsWithMacroExpansion(block) && "next_line_shifted".equals(block_brace_position)) {
            this.scribe.unIndent();
        }
    }

    private void formatLeftCurlyBrace(int line, String bracePosition) {
        this.scribe.formatBrace = true;
        try {
            this.scribe.printComment();
            if ("next_line_on_wrap".equals(bracePosition) && (this.scribe.line > line || this.scribe.column >= this.preferences.page_width)) {
                this.scribe.startNewLine();
            }
        }
        finally {
            this.scribe.formatBrace = false;
        }
    }

    private void formatOpeningBrace(String bracePosition, boolean insertSpaceBeforeBrace) {
        if ("next_line".equals(bracePosition)) {
            this.scribe.startNewLine();
        } else if ("next_line_shifted".equals(bracePosition)) {
            this.scribe.startNewLine();
            this.scribe.indent();
        }
        int token = this.peekNextToken();
        if (token == 12) {
            this.scribe.printNextToken(token, insertSpaceBeforeBrace);
        }
        this.scribe.printTrailingComment();
    }

    private void formatClosingBrace(String brace_position) {
        int token = this.peekNextToken();
        if (token == 13) {
            this.scribe.printNextToken(token);
        }
        this.scribe.printTrailingComment();
        if ("next_line_shifted".equals(brace_position)) {
            this.scribe.unIndent();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void formatStatements(List<IASTStatement> statements, boolean insertNewLineAfterLastStatement) {
        statementsLength = statements.size();
        if (statementsLength > 1) {
            firstStatement = statements.get(0);
            try {
                firstStatement.accept(this);
            }
            catch (ASTProblemException e) {
                this.skipToNode(statements.get(1));
            }
            indentLevel = this.scribe.indentationLevel;
            i = 1;
            while (i < statementsLength - 1) {
                block14: {
                    statement = statements.get(i);
                    if (!(statement instanceof IASTNullStatement && !this.isEmptyStatement(statement) || this.doNodeLocationsOverlap(statement, statements.get(i - 1)))) {
                        this.scribe.startNewLine();
                    }
                    if (this.enterNode(statement)) {
                        try {
                            statement.accept(this);
                            break block14;
                        }
                        catch (RuntimeException e) {
                            if (i >= statementsLength - 1) {
                                throw e;
                            }
                            this.reportFormattingProblem(e);
                            this.exitAlignments();
                            this.skipToNode(statements.get(i + 1));
                            ** while (this.scribe.indentationLevel < indentLevel)
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.scribe.indent();
                            continue;
                        }
lbl30:
                        // 2 sources

                        while (this.scribe.indentationLevel > indentLevel) {
                            this.scribe.unIndent();
                        }
                    }
                }
                ++i;
            }
            statement = statements.get(statementsLength - 1);
            if (!(statement instanceof IASTNullStatement || this.startsWithMacroExpansion(statement) && this.looksLikeStatement((IASTMacroExpansionLocation)statement.getNodeLocations()[0]))) {
                this.scribe.startNewLine();
            }
            statement.accept(this);
        } else {
            statement = statements.get(0);
            statement.accept(this);
        }
        if (insertNewLineAfterLastStatement) {
            this.scribe.startNewLine();
        }
    }

    private boolean commentStartsBlock(int start, int end) {
        this.localScanner.resetTo(start, end);
        if (this.localScanner.getNextToken() == 12) {
            switch (this.localScanner.getNextToken()) {
                case 1001: 
                case 1002: {
                    return true;
                }
            }
        }
        return false;
    }

    private char peekNextChar() {
        char[] text;
        if (this.peekNextToken() != 1006 && (text = this.localScanner.getCurrentTokenSource()).length > 0) {
            return text[0];
        }
        return '\u0000';
    }

    private int peekTokenAtPosition(int pos) {
        this.localScanner.resetTo(pos, this.scribe.scannerEndPosition);
        int token = this.localScanner.getNextToken();
        while (token == 1002 || token == 1001) {
            token = this.localScanner.getNextToken();
        }
        return token;
    }

    private int peekNextToken() {
        return this.peekNextToken(false);
    }

    private Position getInactivePosAt(int offset) {
        for (Position position : this.fInactivePreprocessorPositions) {
            if (!position.includes(offset)) continue;
            return position;
        }
        return null;
    }

    private int peekNextToken(boolean ignoreSkip) {
        if (!ignoreSkip && this.scribe.shouldSkip(this.getCurrentPosition())) {
            return 1006;
        }
        this.localScanner.resetTo(this.getCurrentPosition(), this.scribe.scannerEndPosition);
        int token = this.localScanner.getNextToken();
        int currentStart = this.localScanner.getCurrentTokenStartPosition();
        Position p = this.getInactivePosAt(currentStart);
        while (token == 1002 || token == 1001 || p != null) {
            token = this.localScanner.getNextToken();
            currentStart = this.localScanner.getCurrentTokenStartPosition();
            p = this.getInactivePosAt(currentStart);
        }
        return token;
    }

    private boolean isSemicolonLocation(IASTNodeLocation location) {
        return location instanceof IASTFileLocation && location.getNodeLength() == 1 && this.peekTokenAtPosition(location.getNodeOffset()) == 5 && this.localScanner.getCurrentTokenEndPosition() + 1 == location.getNodeOffset() + location.getNodeLength();
    }

    private boolean isSemicolonAtPosition(int pos) {
        return this.peekTokenAtPosition(pos) == 5 && this.localScanner.getCurrentTokenStartPosition() == pos;
    }

    private boolean isGuardClause(IASTCompoundStatement block, List<IASTStatement> statements) {
        int blockLength;
        IASTFileLocation fileLocation = block.getFileLocation();
        if (fileLocation == null) {
            return false;
        }
        int blockStartPosition = this.nodeOffset(block);
        if (this.commentStartsBlock(blockStartPosition, blockLength = block.getFileLocation().getNodeLength())) {
            return false;
        }
        int statementsLength = statements.size();
        if (statementsLength != 1) {
            return false;
        }
        return statements.get(0) instanceof IASTReturnStatement;
    }

    private List<InactivePosition> collectNoFormatCodePositions(IASTTranslationUnit translationUnit) {
        IASTComment[] commentsStmts;
        if (translationUnit == null || !this.preferences.use_fomatter_comment_tag) {
            return Collections.emptyList();
        }
        String fileName = translationUnit.getFilePath();
        if (fileName == null) {
            return Collections.emptyList();
        }
        ArrayList<InactivePosition> positions = new ArrayList<InactivePosition>();
        int inactiveCodeStart = -1;
        boolean inInactiveCode = false;
        IASTComment[] iASTCommentArray = commentsStmts = translationUnit.getComments();
        int n = commentsStmts.length;
        int n2 = 0;
        while (n2 < n) {
            IASTFileLocation nodeLocation;
            IASTComment commentStmt = iASTCommentArray[n2];
            IASTComment statement = commentStmt;
            if (statement.isPartOfTranslationUnitFile() && (nodeLocation = statement.getFileLocation()) != null) {
                String comment = new String(statement.getComment());
                int offPos = comment.lastIndexOf(this.preferences.comment_formatter_off_tag);
                int onPos = comment.lastIndexOf(this.preferences.comment_formatter_on_tag);
                if (offPos != -1 && offPos > onPos) {
                    if (!inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    }
                } else if (onPos != -1 && onPos > offPos) {
                    if (inInactiveCode) {
                        int inactiveCodeEnd = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        positions.add(new InactivePosition(inactiveCodeStart, inactiveCodeEnd - inactiveCodeStart, false));
                    }
                    inInactiveCode = false;
                }
            }
            ++n2;
        }
        if (inInactiveCode) {
            positions.add(new InactivePosition(inactiveCodeStart, translationUnit.getFileLocation().getNodeLength(), false));
            inInactiveCode = false;
        }
        return positions;
    }

    private static List<InactivePosition> collectInactiveCodePositions(IASTTranslationUnit translationUnit) {
        IASTPreprocessorStatement[] preprocStmts;
        if (translationUnit == null) {
            return Collections.emptyList();
        }
        String fileName = translationUnit.getFilePath();
        if (fileName == null) {
            return Collections.emptyList();
        }
        ArrayList<InactivePosition> positions = new ArrayList<InactivePosition>();
        int inactiveCodeStart = -1;
        boolean inInactiveCode = false;
        Stack<Boolean> inactiveCodeStack = new Stack<Boolean>();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = preprocStmts = translationUnit.getAllPreprocessorStatements();
        int n = preprocStmts.length;
        int n2 = 0;
        while (n2 < n) {
            IASTFileLocation nodeLocation;
            IASTPreprocessorStatement preprocStmt = iASTPreprocessorStatementArray[n2];
            IASTPreprocessorStatement statement = preprocStmt;
            if (statement.isPartOfTranslationUnitFile() && (nodeLocation = statement.getFileLocation()) != null) {
                int inactiveCodeEnd;
                if (statement instanceof IASTPreprocessorIfStatement) {
                    IASTPreprocessorIfStatement ifStmt = (IASTPreprocessorIfStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfdefStatement) {
                    IASTPreprocessorIfdefStatement ifdefStmt = (IASTPreprocessorIfdefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifdefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfndefStatement) {
                    IASTPreprocessorIfndefStatement ifndefStmt = (IASTPreprocessorIfndefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifndefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorElseStatement) {
                    IASTPreprocessorElseStatement elseStmt = (IASTPreprocessorElseStatement)statement;
                    if (!elseStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    } else if (elseStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = nodeLocation.getNodeOffset();
                        positions.add(new InactivePosition(inactiveCodeStart, inactiveCodeEnd - inactiveCodeStart, true));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorElifStatement) {
                    IASTPreprocessorElifStatement elifStmt = (IASTPreprocessorElifStatement)statement;
                    if (!elifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    } else if (elifStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = nodeLocation.getNodeOffset();
                        positions.add(new InactivePosition(inactiveCodeStart, inactiveCodeEnd - inactiveCodeStart, true));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorEndifStatement) {
                    try {
                        boolean wasInInactiveCode = (Boolean)inactiveCodeStack.pop();
                        if (inInactiveCode && !wasInInactiveCode) {
                            inactiveCodeEnd = nodeLocation.getNodeOffset();
                            positions.add(new InactivePosition(inactiveCodeStart, inactiveCodeEnd - inactiveCodeStart, true));
                        }
                        inInactiveCode = wasInInactiveCode;
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        return positions;
    }

    private boolean hasMemberInitializers(IASTFunctionDefinition node) {
        return node instanceof ICPPASTFunctionDefinition && ((ICPPASTFunctionDefinition)node).getMemberInitializers().length > 0;
    }

    private int findTokenWithinNode(int tokenType, IASTNode node) {
        IASTFileLocation location = this.getFileLocation(node);
        int endOffset = location.getNodeOffset() + location.getNodeLength();
        return this.scribe.findToken(tokenType, endOffset);
    }

    private int findTokenAfterNodeOrTokenRange(int tokenType, Object nodeOrTokenRange) {
        int startOffset;
        if (nodeOrTokenRange instanceof IASTNode) {
            IASTFileLocation location = this.getFileLocation((IASTNode)nodeOrTokenRange);
            startOffset = location.getNodeOffset() + location.getNodeLength();
        } else {
            startOffset = ((TokenRange)nodeOrTokenRange).getEndOffset();
        }
        return this.scribe.findToken(tokenType, startOffset, this.scribe.scannerEndPosition - 1);
    }

    private static class ASTProblemException
    extends RuntimeException {
        ASTProblemException(IASTProblem problem) {
            super(problem.getMessageWithLocation());
        }
    }

    private class ClosingParensesisTailFormatter
    implements Runnable {
        private final boolean spaceBeforeClosingParen;
        private final Runnable continuationFormatter;
        private final int parenPosition;
        private final int token;

        public ClosingParensesisTailFormatter(boolean spaceBeforeClosingParen, Runnable tailFormatter, int token) {
            this.spaceBeforeClosingParen = spaceBeforeClosingParen;
            this.continuationFormatter = tailFormatter;
            this.token = token;
            this.parenPosition = CodeFormatterVisitor.this.scribe.findToken(token);
        }

        public ClosingParensesisTailFormatter(boolean spaceBeforeClosingParen, Runnable tailFormatter) {
            this.spaceBeforeClosingParen = spaceBeforeClosingParen;
            this.continuationFormatter = tailFormatter;
            this.token = 9;
            this.parenPosition = CodeFormatterVisitor.this.scribe.findToken(9);
        }

        @Override
        public void run() {
            int offset = ((CodeFormatterVisitor)CodeFormatterVisitor.this).scribe.scanner.getCurrentPosition();
            if (this.parenPosition >= 0 && offset <= this.parenPosition) {
                if (offset < this.parenPosition) {
                    CodeFormatterVisitor.this.scribe.restartAtOffset(this.parenPosition);
                }
                CodeFormatterVisitor.this.scribe.undoSpace();
                CodeFormatterVisitor.this.scribe.printNextToken(this.token, this.spaceBeforeClosingParen);
            }
            if (this.continuationFormatter != null) {
                this.continuationFormatter.run();
            }
        }
    }

    private class FunctionDeclaratorTailFormatter
    implements Runnable {
        private final IASTFunctionDeclarator node;
        private final Runnable continuationFormatter;

        public FunctionDeclaratorTailFormatter(IASTFunctionDeclarator node, Runnable tailFormatter) {
            this.node = node;
            this.continuationFormatter = tailFormatter;
        }

        @Override
        public void run() {
            boolean needSpace = CodeFormatterVisitor.this.skipConstVolatileRestrict(true);
            needSpace = CodeFormatterVisitor.this.skipMutableConstexpr() || needSpace;
            int token = CodeFormatterVisitor.this.peekNextToken();
            if (token == 20) {
                CodeFormatterVisitor.this.scribe.printNextToken(token, CodeFormatterVisitor.this.preferences.insert_space_before_lambda_return);
                if (CodeFormatterVisitor.this.preferences.insert_space_after_lambda_return) {
                    CodeFormatterVisitor.this.scribe.space();
                }
                if (this.node.getParent() instanceof ICPPASTLambdaExpression) {
                    IASTTypeId returnValue = ((ICPPASTFunctionDeclarator)this.node).getTrailingReturnType();
                    returnValue.accept(CodeFormatterVisitor.this);
                    CodeFormatterVisitor.this.scribe.printTrailingComment();
                    CodeFormatterVisitor.this.scribe.space();
                }
                token = CodeFormatterVisitor.this.peekNextToken();
                needSpace = true;
            }
            if (token == 30 || token == 29) {
                CodeFormatterVisitor.this.scribe.printNextToken(token, true);
                token = CodeFormatterVisitor.this.peekNextToken();
                needSpace = true;
            }
            if (token == 113 || token == 1) {
                IASTTypeId[] exceptionSpecification;
                if (this.node instanceof ICPPASTFunctionDeclarator && (exceptionSpecification = ((ICPPASTFunctionDeclarator)this.node).getExceptionSpecification()) != null && token == 113) {
                    CodeFormatterVisitor.this.formatExceptionSpecification(exceptionSpecification);
                }
                if (CodeFormatterVisitor.this.peekNextToken() == 1) {
                    Alignment alignment = CodeFormatterVisitor.this.scribe.createAlignment("trailingText", 16, 1, ((CodeFormatterVisitor)CodeFormatterVisitor.this).scribe.scanner.getCurrentPosition());
                    CodeFormatterVisitor.this.scribe.enterAlignment(alignment);
                    boolean ok = false;
                    do {
                        try {
                            CodeFormatterVisitor.this.scribe.alignFragment(alignment, 0);
                            CodeFormatterVisitor.this.scribe.printTrailingComment();
                            CodeFormatterVisitor.this.scribe.space();
                            if (this.continuationFormatter != null) {
                                this.continuationFormatter.run();
                            }
                            CodeFormatterVisitor.this.skipNode(this.node);
                            ok = true;
                        }
                        catch (AlignmentException e) {
                            CodeFormatterVisitor.this.scribe.redoAlignment(e);
                        }
                    } while (!ok);
                    CodeFormatterVisitor.this.scribe.exitAlignment(alignment, true);
                }
            } else {
                if (needSpace && CodeFormatterVisitor.this.scribe.printComment()) {
                    CodeFormatterVisitor.this.scribe.space();
                }
                CodeFormatterVisitor.this.skipNode(this.node);
                if (this.continuationFormatter != null) {
                    this.continuationFormatter.run();
                }
            }
        }
    }

    private static class ListOptions {
        final int fMode;
        int fSeparatorToken = 6;
        boolean fSpaceBeforeSeparator;
        boolean fSpaceAfterSeparator = true;
        boolean fSpaceAfterOpeningParen;
        boolean fSpaceBeforeClosingParen;
        boolean fSpaceBetweenEmptyParen;
        boolean fSpaceBeforeOpeningParen;
        int fContinuationIndentation = -1;
        int fTieBreakRule = 2;
        ICPPASTLambdaExpression.CaptureDefault captureDefault;
        int rightToken;
        int leftToken;

        ListOptions(int mode) {
            this.fMode = mode;
            this.captureDefault = ICPPASTLambdaExpression.CaptureDefault.UNSPECIFIED;
            this.rightToken = 9;
            this.leftToken = 8;
        }
    }

    private static class TokenRange {
        private int offset;
        private int endOffset;

        TokenRange(int offset, int endOffset) {
            this.offset = offset;
            this.endOffset = endOffset;
        }

        int getOffset() {
            return this.offset;
        }

        int getEndOffset() {
            return this.endOffset;
        }

        int getLength() {
            return this.endOffset - this.offset;
        }
    }

    private class TrailingSemicolonFormatter
    extends TrailingTokenFormatter {
        TrailingSemicolonFormatter(IASTNode node) {
            super(5, CodeFormatterVisitor.getLastNodeCharacterPosition(node), CodeFormatterVisitor.this.fHasClauseInitStatement ? CodeFormatterVisitor.this.preferences.insert_space_before_semicolon_in_for : CodeFormatterVisitor.this.preferences.insert_space_before_semicolon, false);
        }
    }

    private class TrailingTokenFormatter
    implements Runnable {
        private final int tokenType;
        private final int tokenPosition;
        private final boolean spaceBeforeToken;
        private final boolean spaceAfterToken;

        TrailingTokenFormatter(int tokenType, int tokenPosition, boolean spaceBeforeToken, boolean spaceAfterToken) {
            this.tokenType = tokenType;
            this.tokenPosition = tokenPosition;
            this.spaceBeforeToken = spaceBeforeToken;
            this.spaceAfterToken = spaceAfterToken;
        }

        TrailingTokenFormatter(int tokenType, IASTNode containingNode, boolean spaceBeforeToken, boolean spaceAfterToken) {
            this(tokenType, codeFormatterVisitor.findTokenWithinNode(tokenType, containingNode), spaceBeforeToken, spaceAfterToken);
        }

        @Override
        public void run() {
            int token;
            int offset = ((CodeFormatterVisitor)CodeFormatterVisitor.this).scribe.scanner.getCurrentPosition();
            if (this.tokenPosition < 0 || offset > this.tokenPosition) {
                return;
            }
            if (offset < this.tokenPosition) {
                CodeFormatterVisitor.this.scribe.restartAtOffset(this.tokenPosition);
            }
            if ((token = CodeFormatterVisitor.this.peekNextToken()) == this.tokenType) {
                CodeFormatterVisitor.this.scribe.undoSpace();
                CodeFormatterVisitor.this.scribe.printNextToken(this.tokenType, this.spaceBeforeToken);
                CodeFormatterVisitor.this.scribe.printTrailingComment();
                if (this.spaceAfterToken) {
                    CodeFormatterVisitor.this.scribe.space();
                }
            }
        }
    }
}

