/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerexperience.cloudcode.intellij.auth;

import androidx.annotation.VisibleForTesting;
import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.AuthorizationCodeFlowWithState;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.GoogleLoginCredential;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.GoogleLoginService1pImpl;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.GoogleLoginStateStore;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.IntellijLoginClient;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.OAuthLocalServerByoidReceiver;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.StsClientParametersAuthentication;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.StsTokenInfoResponseHolder;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.ParameterName;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J9\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\n0\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0007J\n\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\b\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020#X\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginServiceByoidImpl;", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginService1pImpl;", "intellijLoginClient", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/IntellijLoginClient;", "<init>", "(Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/IntellijLoginClient;)V", "oAuthScopes", "", "", "logInWithLocalServer", "", "onComplete", "Lkotlin/Function0;", "onAuthUrl", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "url", "createAuthorizedUrl", "baseUrl", "providerName", "queryByoidEmail", "createStsRequest", "Lcom/google/api/client/http/HttpResponse;", "credentials", "Lcom/google/api/client/googleapis/auth/oauth2/GoogleCredential;", "createStsUrl", "Lcom/google/api/client/http/GenericUrl;", "accessToken", "createCredentials", "getOauth2RootUrl", "tokenServerUrl", "Ljava/net/URL;", "userInfoUrl", "logger", "Ljava/util/logging/Logger;", "getLogger$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib", "()Ljava/util/logging/Logger;", "setLogger$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib", "(Ljava/util/logging/Logger;)V", "java.com.google.cloud.developerexperience.cloudcode.intellij.auth_google_auth_intellij_lib"})
@SourceDebugExtension(value={"SMAP\nGoogleLoginServiceByoidImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleLoginServiceByoidImpl.kt\ncom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginServiceByoidImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1#2:210\n*E\n"})
public class GoogleLoginServiceByoidImpl
extends GoogleLoginService1pImpl {
    @NotNull
    private final Set<String> oAuthScopes;
    @NotNull
    private Logger logger;

    /*
     * WARNING - void declaration
     */
    public GoogleLoginServiceByoidImpl(@NotNull IntellijLoginClient intellijLoginClient) {
        void $this$oAuthScopes_u24lambda_u240;
        HashSet hashSet;
        Intrinsics.checkNotNullParameter((Object)intellijLoginClient, (String)"intellijLoginClient");
        super(intellijLoginClient);
        HashSet hashSet2 = hashSet = new HashSet();
        GoogleLoginServiceByoidImpl googleLoginServiceByoidImpl = this;
        boolean bl = false;
        $this$oAuthScopes_u24lambda_u240.add("https://www.googleapis.com/auth/cloud-platform");
        Set set = Collections.unmodifiableSet(hashSet);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(...)");
        googleLoginServiceByoidImpl.oAuthScopes = set;
        Logger logger = Logger.getLogger(this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @Override
    public void logInWithLocalServer(@NotNull Function0<Unit> onComplete, @NotNull Function1<? super @ParameterName(name="url") String, Unit> onAuthUrl) throws IOException {
        String string;
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        Intrinsics.checkNotNullParameter(onAuthUrl, (String)"onAuthUrl");
        OAuthLocalServerByoidReceiver receiver = new OAuthLocalServerByoidReceiver(null, 0, this.getIntellijLoginClient$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib().getLandingPages().getSuccessPage(), this.getIntellijLoginClient$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib().getLandingPages().getFailurePage(), 3, null);
        String string2 = this.getIntellijLoginClient$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib().getByoidAuthUrl();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = this.getIntellijLoginClient$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib().getByoidProviderName()) == null) {
            string = "";
        }
        String byoidAuthServerEncodedUrl = this.createAuthorizedUrl(string2, string);
        AuthorizationCodeFlow authFlow = new AuthorizationCodeFlow.Builder(BearerToken.authorizationHeaderAccessMethod(), (HttpTransport)this.getNetHttpTransport$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib(), (JsonFactory)this.getGsonFactory$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib(), new GenericUrl(this.tokenServerUrl()), (HttpExecuteInterceptor)new StsClientParametersAuthentication(this.getIntellijLoginClient$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib().getOAuthClientId(), this.getIntellijLoginClient$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib().getOAuthClientNotSoSecret()), this.getIntellijLoginClient$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib().getOAuthClientId(), byoidAuthServerEncodedUrl).setScopes((Collection)this.oAuthScopes).enablePKCE().build();
        String string3 = new BigInteger(130, new SecureRandom()).toString(32);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String state = string3;
        receiver.setState(state);
        Intrinsics.checkNotNull((Object)authFlow);
        Credential credentials = new AuthorizationCodeFlowWithState(authFlow, receiver, state, onAuthUrl).authorize(null);
        GoogleLoginStateStore googleLoginStateStore = this.getGoogleLoginStateStore();
        Intrinsics.checkNotNull((Object)credentials);
        googleLoginStateStore.updateAndSaveUserCredentials(credentials);
        this.getGoogleLoginStateStore().updateAndSaveEmail(this.queryByoidEmail());
        receiver.stop();
        onComplete.invoke();
    }

    @VisibleForTesting
    @NotNull
    public final String createAuthorizedUrl(@NotNull String baseUrl, @NotNull String providerName) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
        String encodedProviderName = URLEncoder.encode(((Object)StringsKt.trim((CharSequence)providerName)).toString(), StandardCharsets.UTF_8.toString());
        return ((Object)StringsKt.trim((CharSequence)baseUrl)).toString() + "?provider_name=" + encodedProviderName;
    }

    /*
     * WARNING - void declaration
     */
    private final String queryByoidEmail() {
        String string;
        try {
            InputStreamReader inputStreamReader;
            GoogleCredential credentials = this.createCredentials();
            HttpResponse response = this.createStsRequest(credentials);
            Type type = new TypeToken<StsTokenInfoResponseHolder>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            Type responseData2 = type;
            Gson gson = this.getGson$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib();
            InputStream inputStream = response.getContent();
            if (inputStream != null) {
                void it;
                InputStream inputStream2 = inputStream;
                Gson gson2 = gson;
                boolean bl = false;
                inputStreamReader = new InputStreamReader((InputStream)it, StandardCharsets.UTF_8);
                gson = gson2;
            } else {
                inputStreamReader = null;
            }
            Object object = gson.fromJson((Reader)inputStreamReader, responseData2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            StsTokenInfoResponseHolder tokenInfoResponseHolder = (StsTokenInfoResponseHolder)object;
            string = tokenInfoResponseHolder.getUsername();
        }
        catch (Exception e) {
            this.getLogger$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib().log(Level.WARNING, "Failed to retrieve email after Google service sign-in", e);
            return "user";
        }
        return string;
    }

    private final HttpResponse createStsRequest(GoogleCredential credentials) {
        HttpRequest httpRequest;
        String string = credentials.getAccessToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAccessToken(...)");
        GenericUrl url = this.createStsUrl(string);
        HttpRequest $this$createStsRequest_u24lambda_u242 = httpRequest = this.getRequestFactory$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib(credentials).buildPostRequest(url, (HttpContent)new EmptyContent());
        boolean bl = false;
        $this$createStsRequest_u24lambda_u242.setInterceptor((HttpExecuteInterceptor)new StsClientParametersAuthentication(this.getIntellijLoginClient$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib().getOAuthClientId(), this.getIntellijLoginClient$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib().getOAuthClientNotSoSecret()));
        HttpRequest request = httpRequest;
        HttpResponse response = request.execute();
        Intrinsics.checkNotNull((Object)response);
        return response;
    }

    private final GenericUrl createStsUrl(String accessToken) {
        GenericUrl url = new GenericUrl(this.userInfoUrl());
        url.set("token_type_hint", (Object)"urn:ietf:params:oauth:token-type:access_token");
        url.set("token", (Object)accessToken);
        return url;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public GoogleCredential createCredentials() {
        Long l;
        GoogleCredential googleCredential;
        GoogleLoginCredential credentials = this.getLoginCredentials();
        GoogleCredential $this$createCredentials_u24lambda_u244 = googleCredential = new GoogleCredential.Builder().setJsonFactory((JsonFactory)this.getGsonFactory$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib()).setTransport((HttpTransport)this.getNetHttpTransport$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib()).setTokenServerUrl(new GenericUrl(this.tokenServerUrl())).setClientAuthentication((HttpExecuteInterceptor)new StsClientParametersAuthentication(this.getIntellijLoginClient$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib().getOAuthClientId(), this.getIntellijLoginClient$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib().getOAuthClientNotSoSecret())).build();
        boolean bl = false;
        GoogleLoginCredential googleLoginCredential = credentials;
        $this$createCredentials_u24lambda_u244.setAccessToken(googleLoginCredential != null ? googleLoginCredential.getAccessToken() : null);
        GoogleLoginCredential googleLoginCredential2 = credentials;
        $this$createCredentials_u24lambda_u244.setRefreshToken(googleLoginCredential2 != null ? googleLoginCredential2.getRefreshToken() : null);
        GoogleCredential googleCredential2 = $this$createCredentials_u24lambda_u244;
        Object object = credentials;
        if (object != null && (object = ((GoogleLoginCredential)object).getAccessTokenExpiryTimeInSeconds()) != null) {
            void it;
            long l2 = ((Number)object).longValue();
            GoogleCredential googleCredential3 = googleCredential2;
            boolean bl2 = false;
            l = (long)(it * (long)1000);
            googleCredential2 = googleCredential3;
        } else {
            l = null;
        }
        googleCredential2.setExpirationTimeMilliseconds(l);
        GoogleCredential googleCredential4 = googleCredential;
        Intrinsics.checkNotNullExpressionValue((Object)googleCredential4, (String)"apply(...)");
        return googleCredential4;
    }

    @Override
    @NotNull
    public String getOauth2RootUrl() {
        return "https://sts.googleapis.com/";
    }

    private final URL tokenServerUrl() {
        return new URL(new URL(this.getOauth2RootUrl()), "v1/oauthtoken");
    }

    private final URL userInfoUrl() {
        return new URL(new URL(this.getOauth2RootUrl()), "v1/introspect");
    }

    @Override
    @NotNull
    public Logger getLogger$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib() {
        return this.logger;
    }

    public void setLogger$java_com_google_cloud_developerexperience_cloudcode_intellij_auth_google_auth_intellij_lib(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"<set-?>");
        this.logger = logger;
    }
}

