/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.symtable;

import com.intellij.openapi.util.Pair;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a8\u0006\u0006"}, d2={"printAttributes", "", "Lcom/intellij/rml/dfa/impl/symtable/SymbolTable;", "attributePrinter", "Lkotlin/Function1;", "Lcom/intellij/rml/dfa/attributes/Attribute;", "intellij.rml.dfa.impl"})
public final class SymbolTableKt {
    @NotNull
    public static final String printAttributes(@NotNull SymbolTable $this$printAttributes, @NotNull Function1<? super Attribute, String> attributePrinter) {
        Intrinsics.checkNotNullParameter((Object)$this$printAttributes, (String)"<this>");
        Intrinsics.checkNotNullParameter(attributePrinter, (String)"attributePrinter");
        StringBuilder builder = new StringBuilder();
        for (DomainType domainType : $this$printAttributes.getAvailableDomainTypes()) {
            String caption = domainType + ": " + $this$printAttributes.getAttributesInfo(domainType);
            builder.append(caption).append("\n");
            int n = ((CharSequence)caption).length();
            for (int i = 0; i < n; ++i) {
                builder.append("=");
            }
            builder.append("\n");
            if (domainType.isIntegerType()) {
                builder.append("Integer domain type\n");
            } else {
                for (Attribute attribute : $this$printAttributes.getAttributes(domainType)) {
                    builder.append((String)attributePrinter.invoke((Object)attribute));
                    if ($this$printAttributes.getAttributeSources() != null) {
                        Map<Attribute, Pair<String, String>>[] mapArray = $this$printAttributes.getAttributeSources();
                        Intrinsics.checkNotNull(mapArray);
                        if (!(mapArray.length == 0)) {
                            Map<Attribute, Pair<String, String>>[] mapArray2 = $this$printAttributes.getAttributeSources();
                            Intrinsics.checkNotNull(mapArray2);
                            Pair<String, String> source = mapArray2[domainType.getIndex()].get(attribute);
                            if (source != null) {
                                builder.append(": ").append((String)source.first).append(" ").append((String)source.second);
                            }
                        }
                    }
                    builder.append("\n");
                }
            }
            builder.append("\n");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

