/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.Expr;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;

public class ExprRelCompare
extends Expr {
    public static final int LESS = 0;
    public static final int LESSEQU = 1;
    public static final int GREATER = 2;
    public static final int GREATEREQU = 3;
    public static final int EQU = 4;
    public static final int UNEQU = 5;
    private final int opCode;
    private final String left;
    private String right;
    private boolean rightBool;

    public ExprRelCompare(int opCode, String left2, String right2, Context context) {
        super(context);
        this.opCode = opCode;
        this.left = left2;
        this.right = right2;
    }

    public ExprRelCompare(int opCode, String left2, boolean rightBool, Context context) {
        super(context);
        this.opCode = opCode;
        this.left = left2;
        this.rightBool = rightBool;
    }

    @Override
    public int interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable) {
        IRelation leftRel = variablesManager.getRelation(this.left, cancellation);
        IRelation rightRel = this.right != null ? variablesManager.getRelation(this.right, cancellation).fastRename(leftRel.getDomains(), cancellation) : relationsManager.makeEmptyRelation(leftRel.getDomains(), this.rightBool);
        boolean equ = leftRel.equals(rightRel);
        return switch (this.opCode) {
            case 0 -> {
                if (!equ && rightRel.contains(leftRel, cancellation)) {
                    yield 1;
                }
                yield 0;
            }
            case 1 -> {
                if (rightRel.contains(leftRel, cancellation)) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> {
                if (!equ && leftRel.contains(rightRel, cancellation)) {
                    yield 1;
                }
                yield 0;
            }
            case 3 -> {
                if (leftRel.contains(rightRel, cancellation)) {
                    yield 1;
                }
                yield 0;
            }
            case 4 -> {
                if (equ) {
                    yield 1;
                }
                yield 0;
            }
            case 5 -> {
                if (!equ) {
                    yield 1;
                }
                yield 0;
            }
            default -> throw new DfaInternalException(Messages.getString(ExprRelCompare.class.getName() + "-0"));
        };
    }

    @Override
    public String toLongString() {
        return "ExprRelCompare{opCode=" + this.opCode + ", left='" + this.left + "', right='" + this.right + "', rightBool=" + this.rightBool + "}";
    }
}

