/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import android.compat.annotation.UnsupportedAppUsage;
import android.icu.text.DateFormatSymbols;
import android.icu.util.Calendar;
import android.icu.util.GregorianCalendar;
import com.android.layoutlib.bridge.android.AndroidLocale;
import dalvik.system.VMRuntime;
import java.util.HashMap;
import java.util.Locale;
import libcore.util.Objects;
import sun.util.locale.provider.CalendarDataUtility;

public class LocaleData {
    private static final Locale LOCALE_EN_US_POSIX = new Locale("en", "US", "POSIX");
    public static final long USE_REAL_ROOT_LOCALE = 159047832L;
    private static final HashMap<String, LocaleData> localeDataCache = new HashMap();
    @UnsupportedAppUsage
    public Integer firstDayOfWeek;
    @UnsupportedAppUsage
    public Integer minimalDaysInFirstWeek;
    public String[] amPm;
    public String[] eras;
    public String[] longMonthNames;
    @UnsupportedAppUsage
    public String[] shortMonthNames;
    public String[] tinyMonthNames;
    public String[] longStandAloneMonthNames;
    @UnsupportedAppUsage
    public String[] shortStandAloneMonthNames;
    public String[] tinyStandAloneMonthNames;
    public String[] longWeekdayNames;
    public String[] shortWeekdayNames;
    public String[] tinyWeekdayNames;
    @UnsupportedAppUsage
    public String[] longStandAloneWeekdayNames;
    @UnsupportedAppUsage
    public String[] shortStandAloneWeekdayNames;
    public String[] tinyStandAloneWeekdayNames;
    @UnsupportedAppUsage
    public String today = "Today";
    @UnsupportedAppUsage
    public String tomorrow = "Tomorrow";
    @UnsupportedAppUsage
    public char zeroDigit = (char)48;
    @UnsupportedAppUsage
    public String timeFormat_hm = "h:mm a";
    @UnsupportedAppUsage
    public String timeFormat_Hm = "HH:mm";

    private LocaleData() {
    }

    @UnsupportedAppUsage
    public static Locale mapInvalidAndNullLocales(Locale locale) {
        if (locale == null) {
            return AndroidLocale.getDefault();
        }
        if ("und".equals(locale.toLanguageTag())) {
            return Locale.ROOT;
        }
        return locale;
    }

    public static Locale getCompatibleLocaleForBug159514442(Locale locale) {
        int targetSdkVersion;
        if (Locale.ROOT.equals(locale) && (targetSdkVersion = VMRuntime.getRuntime().getTargetSdkVersion()) <= 29) {
            locale = LOCALE_EN_US_POSIX;
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static LocaleData get(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        locale = LocaleData.getCompatibleLocaleForBug159514442(locale);
        String languageTag = locale.toLanguageTag();
        HashMap<String, LocaleData> hashMap = localeDataCache;
        synchronized (hashMap) {
            LocaleData localeData = localeDataCache.get(languageTag);
            if (localeData != null) {
                return localeData;
            }
        }
        LocaleData newLocaleData = LocaleData.initLocaleData(locale);
        HashMap<String, LocaleData> hashMap2 = localeDataCache;
        synchronized (hashMap2) {
            LocaleData localeData = localeDataCache.get(languageTag);
            if (localeData != null) {
                return localeData;
            }
            localeDataCache.put(languageTag, newLocaleData);
            return newLocaleData;
        }
    }

    public String toString() {
        return Objects.toString(this);
    }

    public static LocaleData initLocaleData(Locale locale) {
        LocaleData localeData = new LocaleData();
        localeData.initializeDateFormatData(locale);
        localeData.initializeCalendarData(locale);
        return localeData;
    }

    private void initializeDateFormatData(Locale locale) {
        DateFormatSymbols dfs = new DateFormatSymbols(GregorianCalendar.class, locale);
        this.longMonthNames = dfs.getMonths(0, 1);
        this.shortMonthNames = dfs.getMonths(0, 0);
        this.tinyMonthNames = dfs.getMonths(0, 2);
        this.longWeekdayNames = dfs.getWeekdays(0, 1);
        this.shortWeekdayNames = dfs.getWeekdays(0, 0);
        this.tinyWeekdayNames = dfs.getWeekdays(0, 2);
        this.longStandAloneMonthNames = dfs.getMonths(1, 1);
        this.shortStandAloneMonthNames = dfs.getMonths(1, 0);
        this.tinyStandAloneMonthNames = dfs.getMonths(1, 2);
        this.longStandAloneWeekdayNames = dfs.getWeekdays(1, 1);
        this.shortStandAloneWeekdayNames = dfs.getWeekdays(1, 0);
        this.tinyStandAloneWeekdayNames = dfs.getWeekdays(1, 2);
        this.amPm = dfs.getAmPmStrings();
        this.eras = dfs.getEras();
    }

    private void initializeCalendarData(Locale locale) {
        Calendar calendar = Calendar.getInstance(locale);
        this.firstDayOfWeek = CalendarDataUtility.retrieveFirstDayOfWeek((Locale)locale, (int)calendar.getFirstDayOfWeek());
        this.minimalDaysInFirstWeek = calendar.getMinimalDaysInFirstWeek();
    }

    static {
        LocaleData.get(Locale.ROOT);
        LocaleData.get(Locale.US);
        LocaleData.get(AndroidLocale.getDefault());
    }
}

