/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.suggestions;

import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.BaseTextContrastFixSuggestionProducer;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.MaterialDesignColor;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.SetViewAttributeFixSuggestion;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.ContrastUtils;
import com.google.common.collect.UnmodifiableIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

class TextColorFixSuggestionProducer
extends BaseTextContrastFixSuggestionProducer {
    private static final String VIEW_ATTRIBUTE_TEXT_COLOR = "textColor";
    private static final String VIEW_ATTRIBUTE_TEXT_COLOR_HINT = "textColorHint";

    TextColorFixSuggestionProducer() {
    }

    @Override
    protected @Nullable SetViewAttributeFixSuggestion produceTextContrastFixSuggestion(int checkResultId, ViewHierarchyElement element, ResultMetadata metadata) {
        switch (checkResultId) {
            case 8: 
            case 11: 
            case 12: 
            case 15: {
                return TextColorFixSuggestionProducer.produceTextColorFixSuggestion(element, metadata);
            }
        }
        return null;
    }

    private static @Nullable SetViewAttributeFixSuggestion produceTextColorFixSuggestion(ViewHierarchyElement element, ResultMetadata resultMetadata) {
        Integer bestColorCandidate = TextColorFixSuggestionProducer.findBestTextColorCandidate(TextColorFixSuggestionProducer.getTextColor(resultMetadata), TextColorFixSuggestionProducer.getBackgroundColor(resultMetadata), TextColorFixSuggestionProducer.getRequiredContrastRatio(resultMetadata));
        String viewAttribute = TextUtils.isEmpty(element.getText()) ? VIEW_ATTRIBUTE_TEXT_COLOR_HINT : VIEW_ATTRIBUTE_TEXT_COLOR;
        return bestColorCandidate == null ? null : TextColorFixSuggestionProducer.createSetViewAttributeFixSuggestion(viewAttribute, bestColorCandidate);
    }

    private static @Nullable Integer findBestTextColorCandidate(int textColor, int backgroundColor, double requiredContrastRatio) {
        double minColorDistance = Double.MAX_VALUE;
        Integer bestColorCandidate = null;
        for (MaterialDesignColor designColor : MaterialDesignColor.values()) {
            UnmodifiableIterator unmodifiableIterator = designColor.getColorMap().values().iterator();
            while (unmodifiableIterator.hasNext()) {
                double colorDistance;
                int testColor = (Integer)unmodifiableIterator.next();
                if (ContrastUtils.calculateContrastRatio(testColor, backgroundColor) < requiredContrastRatio || !(minColorDistance > (colorDistance = ContrastUtils.colorDifference(testColor, textColor)))) continue;
                minColorDistance = colorDistance;
                bestColorCandidate = testColor;
            }
        }
        return bestColorCandidate;
    }
}

