/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.suggestions;

import com.google.android.apps.common.testing.accessibility.framework.suggestions.FixSuggestion;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import java.util.Locale;

@Beta
public class CompoundFixSuggestions
implements FixSuggestion {
    private final ImmutableList<FixSuggestion> fixSuggestions;

    public CompoundFixSuggestions(ImmutableList<FixSuggestion> fixSuggestions) {
        Preconditions.checkArgument((fixSuggestions.size() > 1 ? 1 : 0) != 0, (Object)"The fix suggestion list must contain at least 2 fix suggestions");
        this.fixSuggestions = fixSuggestions;
    }

    public ImmutableList<FixSuggestion> getFixSuggestions() {
        return this.fixSuggestions;
    }

    @Override
    public CharSequence getRawDescription(Locale locale) {
        String description = "";
        for (int i = 0; i < this.fixSuggestions.size(); ++i) {
            description = description + ((FixSuggestion)this.fixSuggestions.get(i)).getRawDescription(locale);
            if (i >= this.fixSuggestions.size() - 1) continue;
            description = description + StandardSystemProperty.LINE_SEPARATOR.value();
        }
        return description;
    }
}

