/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.replacements;

import com.google.android.apps.common.testing.accessibility.framework.replacements.Span;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AndroidFrameworkProtos;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Spans {

    public static class ForegroundColorSpan
    extends Span {
        public static final String ANDROID_CLASS_NAME = "android.text.style.ForegroundColorSpan";
        private final int foregroundColor;

        public ForegroundColorSpan(int start, int end, int flags, int color2) {
            super(ANDROID_CLASS_NAME, start, end, flags);
            this.foregroundColor = color2;
        }

        public ForegroundColorSpan(AndroidFrameworkProtos.SpanProto proto) {
            super(proto);
            this.foregroundColor = proto.getForegroundColor();
        }

        public int getForegroundColor() {
            return this.foregroundColor;
        }

        @Override
        public AndroidFrameworkProtos.SpanProto toProto() {
            return (AndroidFrameworkProtos.SpanProto)this.toProtoBuilder(AndroidFrameworkProtos.SpanProto.SpanType.FOREGROUND_COLOR).setForegroundColor(this.foregroundColor).build();
        }

        @Override
        protected Span copyWithAdjustedPosition(int newStart, int newEnd) {
            return new ForegroundColorSpan(newStart, newEnd, this.getFlags(), this.foregroundColor);
        }
    }

    public static class BackgroundColorSpan
    extends Span {
        public static final String ANDROID_CLASS_NAME = "android.text.style.BackgroundColorSpan";
        private final int backgroundColor;

        public BackgroundColorSpan(int start, int end, int flags, int color2) {
            super(ANDROID_CLASS_NAME, start, end, flags);
            this.backgroundColor = color2;
        }

        public BackgroundColorSpan(AndroidFrameworkProtos.SpanProto proto) {
            super(proto);
            this.backgroundColor = proto.getBackgroundColor();
        }

        public int getBackgroundColor() {
            return this.backgroundColor;
        }

        @Override
        public AndroidFrameworkProtos.SpanProto toProto() {
            return (AndroidFrameworkProtos.SpanProto)this.toProtoBuilder(AndroidFrameworkProtos.SpanProto.SpanType.BACKGROUND_COLOR).setBackgroundColor(this.backgroundColor).build();
        }

        @Override
        protected Span copyWithAdjustedPosition(int newStart, int newEnd) {
            return new BackgroundColorSpan(newStart, newEnd, this.getFlags(), this.backgroundColor);
        }
    }

    public static class UnderlineSpan
    extends Span {
        public static final String ANDROID_CLASS_NAME = "android.text.style.UnderlineSpan";

        public UnderlineSpan(String spanClass, int start, int end, int flags) {
            super(spanClass, start, end, flags);
        }

        public UnderlineSpan(AndroidFrameworkProtos.SpanProto proto) {
            super(proto);
        }

        @Override
        public AndroidFrameworkProtos.SpanProto toProto() {
            return (AndroidFrameworkProtos.SpanProto)this.toProtoBuilder(AndroidFrameworkProtos.SpanProto.SpanType.UNDERLINE).build();
        }

        @Override
        protected Span copyWithAdjustedPosition(int newStart, int newEnd) {
            return new UnderlineSpan(this.getSpanClassName(), newStart, newEnd, this.getFlags());
        }
    }

    public static class StyleSpan
    extends Span {
        public static final String ANDROID_CLASS_NAME = "android.text.style.StyleSpan";
        private final int style;

        public StyleSpan(String spanClass, int start, int end, int flags, int style2) {
            super(spanClass, start, end, flags);
            this.style = style2;
        }

        public StyleSpan(AndroidFrameworkProtos.SpanProto proto) {
            super(proto);
            this.style = proto.getStyle();
        }

        public int getStyle() {
            return this.style;
        }

        @Override
        public AndroidFrameworkProtos.SpanProto toProto() {
            return (AndroidFrameworkProtos.SpanProto)this.toProtoBuilder(AndroidFrameworkProtos.SpanProto.SpanType.STYLE).setStyle(this.style).build();
        }

        @Override
        protected Span copyWithAdjustedPosition(int newStart, int newEnd) {
            return new StyleSpan(this.getSpanClassName(), newStart, newEnd, this.getFlags(), this.style);
        }
    }

    public static class URLSpan
    extends ClickableSpan {
        public static final String ANDROID_CLASS_NAME = "android.text.style.URLSpan";
        private final @Nullable String url;

        public URLSpan(String spanClass, int start, int end, int flags, @Nullable String url) {
            super(spanClass, start, end, flags);
            this.url = url;
        }

        public URLSpan(AndroidFrameworkProtos.SpanProto proto) {
            super(proto);
            this.url = proto.getUrl();
        }

        public @Nullable String getUrl() {
            return this.url;
        }

        @Override
        public AndroidFrameworkProtos.SpanProto toProto() {
            AndroidFrameworkProtos.SpanProto.Builder builder = this.toProtoBuilder(AndroidFrameworkProtos.SpanProto.SpanType.URL);
            String url = this.getUrl();
            if (url != null) {
                builder.setUrl(url);
            }
            return (AndroidFrameworkProtos.SpanProto)builder.build();
        }

        @Override
        protected Span copyWithAdjustedPosition(int newStart, int newEnd) {
            return new URLSpan(this.getSpanClassName(), newStart, newEnd, this.getFlags(), this.url);
        }
    }

    public static class ClickableSpan
    extends Span {
        public static final String ANDROID_CLASS_NAME = "android.text.style.ClickableSpan";

        public ClickableSpan(String spanClass, int start, int end, int flags) {
            super(spanClass, start, end, flags);
        }

        public ClickableSpan(AndroidFrameworkProtos.SpanProto proto) {
            super(proto);
        }

        @Override
        public AndroidFrameworkProtos.SpanProto toProto() {
            return (AndroidFrameworkProtos.SpanProto)this.toProtoBuilder(AndroidFrameworkProtos.SpanProto.SpanType.CLICKABLE).build();
        }

        @Override
        protected Span copyWithAdjustedPosition(int newStart, int newEnd) {
            return new ClickableSpan(this.getSpanClassName(), newStart, newEnd, this.getFlags());
        }
    }
}

