/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.replacements;

import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AndroidFrameworkProtos;
import com.google.errorprone.annotations.Immutable;

@Immutable
public class Span {
    private final String spanClassName;
    private final int start;
    private final int end;
    private final int flags;

    public Span(String spanClassName, int start, int end, int flags) {
        this.spanClassName = spanClassName;
        this.start = start;
        this.end = end;
        this.flags = flags;
    }

    public Span(AndroidFrameworkProtos.SpanProto proto) {
        this.spanClassName = proto.getSpanClassName();
        this.start = proto.getStart();
        this.end = proto.getEnd();
        this.flags = proto.getFlags();
    }

    public String getSpanClassName() {
        return this.spanClassName;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getFlags() {
        return this.flags;
    }

    public AndroidFrameworkProtos.SpanProto toProto() {
        return (AndroidFrameworkProtos.SpanProto)this.toProtoBuilder(AndroidFrameworkProtos.SpanProto.SpanType.UNKNOWN).build();
    }

    protected AndroidFrameworkProtos.SpanProto.Builder toProtoBuilder(AndroidFrameworkProtos.SpanProto.SpanType type) {
        return AndroidFrameworkProtos.SpanProto.newBuilder().setSpanClassName(this.spanClassName).setStart(this.start).setEnd(this.end).setFlags(this.flags).setType(type);
    }

    protected Span copyWithAdjustedPosition(int newStart, int newEnd) {
        return new Span(this.spanClassName, newStart, newEnd, this.flags);
    }
}

