/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.replacements;

import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AndroidFrameworkProtos;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
public class Rect {
    public static final Rect EMPTY = new Rect(0, 0, 0, 0);
    private static final Pattern FLATTENED_PATTERN = Pattern.compile("(-?\\d+) (-?\\d+) (-?\\d+) (-?\\d+)");
    private final int left;
    private final int top;
    private final int right;
    private final int bottom;

    public Rect(int left, int top, int right, int bottom) {
        this.left = Math.min(left, right);
        this.top = Math.min(top, bottom);
        this.right = Math.max(left, right);
        this.bottom = Math.max(top, bottom);
    }

    public Rect(AndroidFrameworkProtos.RectProto rectProto) {
        this(rectProto.getLeft(), rectProto.getTop(), rectProto.getRight(), rectProto.getBottom());
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getWidth() {
        return this.right - this.left;
    }

    public int getHeight() {
        return this.bottom - this.top;
    }

    public int area() {
        return this.getWidth() * this.getHeight();
    }

    public boolean contains(Rect r) {
        return !this.isEmpty() && this.left <= r.left && this.top <= r.top && this.right >= r.right && this.bottom >= r.bottom;
    }

    public boolean contains(int x, int y) {
        return !this.isEmpty() && x >= this.left && x < this.right && y >= this.top && y < this.bottom;
    }

    public boolean isEmpty() {
        return this.left == this.right || this.top == this.bottom;
    }

    public Rect union(Rect r) {
        return this.isEmpty() ? r : this.union(r.left, r.top, r.right, r.bottom);
    }

    public Rect union(int left, int top, int right, int bottom) {
        if (right <= left || bottom <= top) {
            return this;
        }
        if (this.isEmpty()) {
            return new Rect(left, top, right, bottom);
        }
        return new Rect(Math.min(left, this.left), Math.min(top, this.top), Math.max(right, this.right), Math.max(bottom, this.bottom));
    }

    public Rect intersect(Rect r) {
        if (!Rect.intersects(this, r)) {
            return EMPTY;
        }
        return new Rect(Math.max(this.left, r.getLeft()), Math.max(this.top, r.getTop()), Math.min(this.right, r.getRight()), Math.min(this.bottom, r.getBottom()));
    }

    public AndroidFrameworkProtos.RectProto toProto() {
        return (AndroidFrameworkProtos.RectProto)AndroidFrameworkProtos.RectProto.newBuilder().setLeft(this.left).setTop(this.top).setRight(this.right).setBottom(this.bottom).build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Rect.class != o.getClass()) {
            return false;
        }
        Rect r = (Rect)o;
        return this.left == r.left && this.top == r.top && this.right == r.right && this.bottom == r.bottom;
    }

    public int hashCode() {
        int result = this.left;
        result = 31 * result + this.top;
        result = 31 * result + this.right;
        result = 31 * result + this.bottom;
        return result;
    }

    public String toString() {
        return "Rect(" + this.left + ", " + this.top + " - " + this.right + ", " + this.bottom + ")";
    }

    public String toShortString() {
        return "[" + this.left + ',' + this.top + "][" + this.right + ',' + this.bottom + ']';
    }

    public String flattenToString() {
        return Integer.toString(this.left) + ' ' + this.top + ' ' + this.right + ' ' + this.bottom;
    }

    public static @Nullable Rect unflattenFromString(@Nullable String str) {
        if (TextUtils.isEmpty(str)) {
            return null;
        }
        Matcher matcher = FLATTENED_PATTERN.matcher(str);
        if (matcher.matches()) {
            return new Rect(Integer.parseInt((String)Preconditions.checkNotNull((Object)matcher.group(1))), Integer.parseInt((String)Preconditions.checkNotNull((Object)matcher.group(2))), Integer.parseInt((String)Preconditions.checkNotNull((Object)matcher.group(3))), Integer.parseInt((String)Preconditions.checkNotNull((Object)matcher.group(4))));
        }
        return null;
    }

    public static boolean intersects(Rect a, Rect b) {
        return a.top < b.bottom && b.top < a.bottom && a.left < b.right && b.left < a.right;
    }
}

