/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.matcher;

import com.android.layoutlib.hamcrest.Description;
import com.android.layoutlib.hamcrest.FeatureMatcher;
import com.android.layoutlib.hamcrest.Matcher;
import com.android.layoutlib.hamcrest.Matchers;
import com.android.layoutlib.hamcrest.TypeSafeDiagnosingMatcher;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ElementMatchers {
    private ElementMatchers() {
    }

    public static Matcher<ViewHierarchyElement> withText(String string2) {
        return ElementMatchers.withText(Matchers.is((Object)string2));
    }

    public static Matcher<ViewHierarchyElement> withText(Matcher<String> stringMatcher) {
        return new WithStringFeatureMatcher(stringMatcher, "text", ViewHierarchyElement::getText);
    }

    public static Matcher<ViewHierarchyElement> withContentDescription(String string2) {
        return ElementMatchers.withContentDescription(Matchers.is((Object)string2));
    }

    public static Matcher<ViewHierarchyElement> withContentDescription(Matcher<String> stringMatcher) {
        return new WithStringFeatureMatcher(stringMatcher, "contentDescription", ViewHierarchyElement::getContentDescription);
    }

    public static Matcher<ViewHierarchyElement> withTestTag(String string2) {
        return ElementMatchers.withTestTag(Matchers.is((Object)string2));
    }

    public static Matcher<ViewHierarchyElement> withTestTag(Matcher<String> stringMatcher) {
        return new WithStringFeatureMatcher(stringMatcher, "testTag", ViewHierarchyElement::getTestTag);
    }

    public static Matcher<ViewHierarchyElement> withClassName(String string2) {
        return ElementMatchers.withClassName(Matchers.is((Object)string2));
    }

    public static Matcher<ViewHierarchyElement> withClassName(Matcher<String> stringMatcher) {
        return new WithStringFeatureMatcher(stringMatcher, "className", ViewHierarchyElement::getClassName);
    }

    public static Matcher<ViewHierarchyElement> isClickable() {
        return new WithBooleanFeatureMatcher(Matchers.is((Object)true), "clickable", ViewHierarchyElement::isClickable);
    }

    public static Matcher<ViewHierarchyElement> withChild(Matcher<ViewHierarchyElement> childMatcher) {
        return new WithChildMatcher((Matcher)Preconditions.checkNotNull(childMatcher));
    }

    private static class WithStringFeatureMatcher
    extends FeatureMatcher<ViewHierarchyElement, String> {
        private final Function<ViewHierarchyElement, @Nullable CharSequence> extractor;

        private WithStringFeatureMatcher(Matcher<String> stringMatcher, String fetureName, Function<ViewHierarchyElement, @Nullable CharSequence> extractor) {
            super(stringMatcher, "Element with " + fetureName, fetureName);
            this.extractor = extractor;
        }

        @Override
        protected @Nullable String featureValueOf(ViewHierarchyElement element) {
            CharSequence value = (CharSequence)this.extractor.apply((Object)element);
            return value == null ? null : value.toString();
        }
    }

    private static class WithBooleanFeatureMatcher
    extends FeatureMatcher<ViewHierarchyElement, Boolean> {
        private final Function<ViewHierarchyElement, @Nullable Boolean> extractor;

        private WithBooleanFeatureMatcher(Matcher<@Nullable Boolean> booleanMatcher, String fetureName, Function<ViewHierarchyElement, @Nullable Boolean> extractor) {
            super(booleanMatcher, "Element with " + fetureName, fetureName);
            this.extractor = extractor;
        }

        @Override
        protected @Nullable Boolean featureValueOf(ViewHierarchyElement element) {
            return (Boolean)this.extractor.apply((Object)element);
        }
    }

    private static class WithChildMatcher
    extends TypeSafeDiagnosingMatcher<ViewHierarchyElement> {
        private final Matcher<ViewHierarchyElement> childMatcher;

        private WithChildMatcher(Matcher<ViewHierarchyElement> childMatcher) {
            this.childMatcher = childMatcher;
        }

        @Override
        public void describeTo(Description description) {
            description.appendText("Element has child matching: ").appendDescriptionOf(this.childMatcher);
        }

        @Override
        protected boolean matchesSafely(ViewHierarchyElement element, Description mismatchDescription) {
            int count = element.getChildViewCount();
            if (count == 0) {
                mismatchDescription.appendText("Element has no children");
                return false;
            }
            for (int i = 0; i < count; ++i) {
                if (!this.childMatcher.matches(element.getChildView(i))) continue;
                return true;
            }
            mismatchDescription.appendText("mismatches were: [");
            boolean isPastFirst = false;
            for (int i = 0; i < count; ++i) {
                if (isPastFirst) {
                    mismatchDescription.appendText(", ");
                }
                this.childMatcher.describeMismatch(element.getChildView(i), mismatchDescription);
                isPastFirst = true;
            }
            mismatchDescription.appendText("]");
            return false;
        }
    }
}

