/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Span;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Spans;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LinkPurposeUnclearCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_ENGLISH_LOCALE_ONLY = 1;
    public static final int RESULT_ID_NOT_TEXT_VIEW = 2;
    public static final int RESULT_ID_LINK_TEXT_NOT_DESCRIPTIVE = 3;
    public static final String KEY_LINK_TEXT = "KEY_LINK_TEXT";
    private static final ImmutableList<String> ENGLISH_STOPWORDS = ImmutableList.of((Object)"click", (Object)"tap", (Object)"go", (Object)"here", (Object)"learn", (Object)"more", (Object)"this", (Object)"page", (Object)"link", (Object)"about");
    private static final Pattern WORD_PATTERN = Pattern.compile("\\w+");

    @Override
    protected @Nullable String getHelpTopic() {
        return "9663312";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.CONTENT_LABELING;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        if (!LinkPurposeUnclearCheck.isEnglish(hierarchy)) {
            results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, null, 1, null));
            return results;
        }
        List<? extends ViewHierarchyElement> viewsToEval = LinkPurposeUnclearCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            if (!viewHierarchyElement.checkInstanceOf("android.widget.TextView")) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 2, null));
                continue;
            }
            SpannableString text = viewHierarchyElement.getText();
            if (text == null) continue;
            for (Span span : text.getSpans()) {
                CharSequence linkText;
                if (!(span instanceof Spans.ClickableSpan) || !LinkPurposeUnclearCheck.hasOnlyStopwords(linkText = text.subSequence(span.getStart(), span.getEnd()))) continue;
                HashMapResultMetadata resultMetadata = new HashMapResultMetadata();
                resultMetadata.putString(KEY_LINK_TEXT, linkText.toString());
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, viewHierarchyElement, 3, resultMetadata));
            }
        }
        return results;
    }

    @VisibleForTesting
    static boolean hasOnlyStopwords(CharSequence linkText) {
        Matcher m = WORD_PATTERN.matcher(linkText);
        while (m.find()) {
            if (LinkPurposeUnclearCheck.isStopword(m.group())) continue;
            return false;
        }
        return true;
    }

    private static boolean isStopword(String term) {
        for (String word : ENGLISH_STOPWORDS) {
            if (!Ascii.equalsIgnoreCase((CharSequence)word, (CharSequence)term)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = LinkPurposeUnclearCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        Preconditions.checkNotNull((Object)metadata);
        switch (resultId) {
            case 3: {
                return String.format(locale, StringManager.getString(locale, "result_message_link_text_not_descriptive"), metadata.getString(KEY_LINK_TEXT));
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = LinkPurposeUnclearCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        switch (resultId) {
            case 3: {
                return StringManager.getString(locale, "result_message_brief_link_text_not_descriptive");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_link_test");
    }

    private static @Nullable String generateMessageForResultId(Locale locale, int resultId) {
        switch (resultId) {
            case 1: {
                return StringManager.getString(locale, "result_message_english_locale_only");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_text_view");
            }
        }
        return null;
    }
}

