/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Span;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Spans;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Uri;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClickableSpanCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_NO_DETERMINED_TYPE = 1;
    public static final int RESULT_ID_NOT_TEXT_VIEW = 2;
    public static final int RESULT_ID_NULL_URL = 3;
    public static final int RESULT_ID_RELATIVE_LINK = 4;
    public static final int RESULT_ID_CLICKABLE_SPAN = 5;
    public static final int RESULT_ID_VERSION_NOT_APPLICABLE = 6;
    private static final int APPLICABLE_UNTIL_ANDROID_SDK_VERSION = 26;

    @Override
    protected String getHelpTopic() {
        return "6378148";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.IMPLEMENTATION;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        if (hierarchy.getDeviceState().getSdkVersion() >= 26) {
            results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, null, 6, null));
            return results;
        }
        List<? extends ViewHierarchyElement> viewsToEval = ClickableSpanCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            if (!viewHierarchyElement.checkInstanceOf("android.widget.TextView")) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 2, null));
                continue;
            }
            SpannableString text = viewHierarchyElement.getText();
            if (text == null) continue;
            for (Span span : text.getSpans()) {
                if (span instanceof Spans.URLSpan) {
                    String url = ((Spans.URLSpan)span).getUrl();
                    if (url == null) {
                        results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, viewHierarchyElement, 3, null));
                        continue;
                    }
                    try {
                        Uri uri = new Uri(url);
                        if (!uri.isRelative()) continue;
                        results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, viewHierarchyElement, 4, null));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue;
                }
                if (!(span instanceof Spans.ClickableSpan)) continue;
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, viewHierarchyElement, 5, null));
            }
        }
        return results;
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        return ClickableSpanCheck.generateMessageForResult(locale, resultId);
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        return ClickableSpanCheck.generateMessageForResult(locale, resultId);
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_clickablespan");
    }

    private static String generateMessageForResult(Locale locale, int resultId) {
        switch (resultId) {
            case 6: {
                return String.format(locale, StringManager.getString(locale, "result_message_sdk_version_not_applicable"), "8.0");
            }
            case 1: {
                return StringManager.getString(locale, "result_message_clickablespan_no_determined_type");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_text_view");
            }
            case 3: 
            case 4: {
                return StringManager.getString(locale, "result_message_urlspan_invalid_url");
            }
            case 5: {
                return StringManager.getString(locale, "result_message_urlspan_not_clickablespan");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }
}

