/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.proto.AccessibilityEvaluationProtos;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AccessibilityCheckResult {
    private final Class<? extends AccessibilityCheck> checkClass;
    private final AccessibilityCheckResultType type;
    private final @Nullable CharSequence message;

    public AccessibilityCheckResult(Class<? extends AccessibilityCheck> checkClass, AccessibilityCheckResultType type, @Nullable CharSequence message) {
        this.checkClass = checkClass;
        this.type = type;
        this.message = message;
    }

    public Class<? extends AccessibilityCheck> getSourceCheckClass() {
        return this.checkClass;
    }

    public AccessibilityCheckResultType getType() {
        return this.type;
    }

    @Deprecated
    public CharSequence getMessage() {
        return this.getMessage(Locale.ENGLISH);
    }

    public CharSequence getMessage(Locale locale) {
        return (CharSequence)Preconditions.checkNotNull((Object)this.message, (Object)"No message was provided");
    }

    public String toString() {
        return String.format("AccessibilityCheckResult %s %s \"%s\"", new Object[]{this.type, this.checkClass, this.message});
    }

    public static enum AccessibilityCheckResultType {
        ERROR(AccessibilityEvaluationProtos.ResultTypeProto.ERROR),
        WARNING(AccessibilityEvaluationProtos.ResultTypeProto.WARNING),
        INFO(AccessibilityEvaluationProtos.ResultTypeProto.INFO),
        RESOLVED(AccessibilityEvaluationProtos.ResultTypeProto.RESOLVED),
        NOT_RUN(AccessibilityEvaluationProtos.ResultTypeProto.NOT_RUN),
        SUPPRESSED(AccessibilityEvaluationProtos.ResultTypeProto.SUPPRESSED);

        private static final Map<Integer, AccessibilityCheckResultType> PROTO_NUMBER_MAP;
        final int protoNumber;

        private AccessibilityCheckResultType(AccessibilityEvaluationProtos.ResultTypeProto proto) {
            this.protoNumber = proto.getNumber();
        }

        public static AccessibilityCheckResultType fromProto(AccessibilityEvaluationProtos.ResultTypeProto proto) {
            AccessibilityCheckResultType type = PROTO_NUMBER_MAP.get(proto.getNumber());
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Failed to create AccessibilityCheckResultType from proto with unknown value: %s", (int)proto.getNumber());
            return (AccessibilityCheckResultType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        }

        public AccessibilityEvaluationProtos.ResultTypeProto toProto() {
            return AccessibilityEvaluationProtos.ResultTypeProto.forNumber(this.protoNumber);
        }

        static {
            PROTO_NUMBER_MAP = new HashMap<Integer, AccessibilityCheckResultType>();
            for (AccessibilityCheckResultType type : AccessibilityCheckResultType.values()) {
                PROTO_NUMBER_MAP.put(type.protoNumber, type);
            }
        }
    }
}

