/*
 * Decompiled with CFR 0.152.
 */
package com.android.telephony;

import android.net.Uri;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.android.internal.telephony.util.TelephonyUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Rlog {
    private static final boolean USER_BUILD = TelephonyUtils.IS_USER;

    private Rlog() {
    }

    private static int log(int priority, String tag, String msg) {
        return Log.logToRadioBuffer(priority, tag, msg);
    }

    public static int v(String tag, String msg) {
        return Rlog.log(2, tag, msg);
    }

    public static int v(String tag, String msg, Throwable tr) {
        return Rlog.log(2, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int d(String tag, String msg) {
        return Rlog.log(3, tag, msg);
    }

    public static int d(String tag, String msg, Throwable tr) {
        return Rlog.log(3, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int i(String tag, String msg) {
        return Rlog.log(4, tag, msg);
    }

    public static int i(String tag, String msg, Throwable tr) {
        return Rlog.log(4, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int w(String tag, String msg) {
        return Rlog.log(5, tag, msg);
    }

    public static int w(String tag, String msg, Throwable tr) {
        return Rlog.log(5, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int w(String tag, Throwable tr) {
        return Rlog.log(5, tag, Log.getStackTraceString(tr));
    }

    public static int e(String tag, String msg) {
        return Rlog.log(6, tag, msg);
    }

    public static int e(String tag, String msg, Throwable tr) {
        return Rlog.log(6, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int println(int priority, String tag, String msg) {
        return Rlog.log(priority, tag, msg);
    }

    public static boolean isLoggable(String tag, int level) {
        return Log.isLoggable(tag, level);
    }

    public static String pii(String tag, Object pii) {
        String val = String.valueOf(pii);
        if (pii == null || TextUtils.isEmpty(val) || Rlog.isLoggable(tag, 2)) {
            return val;
        }
        return "[" + Rlog.secureHash(val.getBytes()) + "]";
    }

    public static String pii(boolean enablePiiLogging, Object pii) {
        String val = String.valueOf(pii);
        if (pii == null || TextUtils.isEmpty(val) || enablePiiLogging) {
            return val;
        }
        return "[" + Rlog.secureHash(val.getBytes()) + "]";
    }

    public static String piiHandle(Object pii) {
        StringBuilder sb = new StringBuilder();
        if (pii instanceof Uri) {
            Uri uri = (Uri)pii;
            String scheme = uri.getScheme();
            if (!TextUtils.isEmpty(scheme)) {
                sb.append(scheme).append(":");
            }
            String textToObfuscate = uri.getSchemeSpecificPart();
            if ("tel".equals(scheme)) {
                Rlog.obfuscatePhoneNumber(sb, textToObfuscate);
            } else if ("sip".equals(scheme)) {
                for (int i = 0; i < textToObfuscate.length(); ++i) {
                    int c = textToObfuscate.charAt(i);
                    if (c != 64 && c != 46) {
                        c = 42;
                    }
                    sb.append((char)c);
                }
            } else {
                sb.append("***");
            }
        } else if (pii instanceof String) {
            String number = (String)pii;
            Rlog.obfuscatePhoneNumber(sb, number);
        }
        return sb.toString();
    }

    private static void obfuscatePhoneNumber(StringBuilder sb, String phoneNumber) {
        int numDigitsToLog = USER_BUILD ? 0 : 2;
        int numDigitsToObfuscate = Rlog.getDialableCount(phoneNumber) - numDigitsToLog;
        for (int i = 0; i < phoneNumber.length(); ++i) {
            char c = phoneNumber.charAt(i);
            boolean isDialable = PhoneNumberUtils.isDialable(c);
            if (isDialable) {
                --numDigitsToObfuscate;
            }
            sb.append(isDialable && numDigitsToObfuscate >= 0 ? "*" : Character.valueOf(c));
        }
    }

    private static int getDialableCount(String toCount) {
        int numDialable = 0;
        for (char c : toCount.toCharArray()) {
            if (!PhoneNumberUtils.isDialable(c)) continue;
            ++numDialable;
        }
        return numDialable;
    }

    private static String secureHash(byte[] input) {
        MessageDigest messageDigest;
        if (USER_BUILD) {
            return "****";
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            return "####";
        }
        byte[] result = messageDigest.digest(input);
        return Base64.encodeToString(result, 11);
    }
}

