/*
 * Decompiled with CFR 0.152.
 */
package com.android.ondevicepersonalization.internal.util;

import android.annotation.NonNull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;

public class ExceptionInfo
implements Serializable {
    private ArrayList<ExceptionInfoElement> mElements;

    ExceptionInfo(Throwable t, int maxDepth) {
        Objects.requireNonNull(t);
        this.mElements = new ArrayList();
        for (int count = 0; t != null && count < maxDepth; t = t.getCause(), ++count) {
            this.mElements.add(new ExceptionInfoElement(t));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] toByteArray(Throwable t, int maxDepth) {
        if (t == null) {
            return null;
        }
        try {
            ExceptionInfo info = new ExceptionInfo(t, maxDepth);
            try (ByteArrayOutputStream bs = new ByteArrayOutputStream();){
                byte[] byArray;
                try (ObjectOutputStream os = new ObjectOutputStream(bs);){
                    os.writeObject(info);
                    byArray = bs.toByteArray();
                }
                return byArray;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Exception fromByteArray(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try (ByteArrayInputStream bs = new ByteArrayInputStream(bytes);){
            Exception exception;
            try (ObjectInputStream os = new ObjectInputStream(bs);){
                ExceptionInfo info = (ExceptionInfo)os.readObject();
                exception = info.toException();
            }
            return exception;
        }
        catch (Exception e) {
            return null;
        }
    }

    Exception toException() {
        try {
            Exception e = null;
            for (int i = this.mElements.size() - 1; i >= 0; --i) {
                ExceptionInfoElement element = this.mElements.get(i);
                Exception tmp = new Exception(element.mExceptionClass + ": " + element.mMessage, e);
                tmp.setStackTrace(element.mStackTrace);
                e = tmp;
            }
            return e;
        }
        catch (Exception e) {
            return null;
        }
    }

    static class ExceptionInfoElement
    implements Serializable {
        String mExceptionClass;
        String mMessage;
        StackTraceElement[] mStackTrace;

        ExceptionInfoElement(@NonNull Throwable t) {
            Objects.requireNonNull(t);
            this.mExceptionClass = t.getClass().getName();
            this.mMessage = t.getMessage();
            this.mStackTrace = t.getStackTrace();
        }
    }
}

