/*
 * Decompiled with CFR 0.152.
 */
package com.android.ondevicepersonalization.internal.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.ondevicepersonalization.internal.util.BaseOdpParceledListSlice;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ByteArrayParceledListSlice
extends BaseOdpParceledListSlice<byte[]> {
    @NonNull
    public static final Parcelable.Creator<byte[]> BYTE_ARRAY_CREATOR = new Parcelable.Creator<byte[]>(){

        @Override
        public byte[] createFromParcel(Parcel in) {
            byte[] arr = new byte[in.readInt()];
            in.readByteArray(arr);
            return arr;
        }

        public byte[][] newArray(int size) {
            return new byte[size][];
        }
    };
    @Nullable
    public static final Parcelable.ClassLoaderCreator<ByteArrayParceledListSlice> CREATOR = new Parcelable.ClassLoaderCreator<ByteArrayParceledListSlice>(){

        @Override
        public ByteArrayParceledListSlice createFromParcel(Parcel in) {
            return new ByteArrayParceledListSlice(in, null);
        }

        @Override
        public ByteArrayParceledListSlice createFromParcel(Parcel in, ClassLoader loader) {
            return new ByteArrayParceledListSlice(in, loader);
        }

        public ByteArrayParceledListSlice[] newArray(int size) {
            return new ByteArrayParceledListSlice[size];
        }
    };

    public ByteArrayParceledListSlice(@Nullable List<byte[]> list) {
        super(list);
    }

    private ByteArrayParceledListSlice(@Nullable Parcel in, @Nullable ClassLoader loader) {
        super(in, loader);
    }

    public static ByteArrayParceledListSlice create(Object[] inputData) {
        ArrayList<byte[]> byteArrayList = new ArrayList<byte[]>();
        for (int i = 0; i < inputData.length; ++i) {
            Object obj = inputData[i];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                byteArrayList.add(baos.toByteArray());
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't convert inference input at index " + i, e);
            }
        }
        return new ByteArrayParceledListSlice((List<byte[]>)byteArrayList);
    }

    @Nullable
    public static ByteArrayParceledListSlice emptyList() {
        return new ByteArrayParceledListSlice(Collections.emptyList());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeElement(@Nullable byte[] parcelable, @Nullable Parcel reply, int callFlags) {
        reply.writeInt(parcelable.length);
        reply.writeByteArray(parcelable);
    }

    @Override
    @NonNull
    public List<byte[]> getList() {
        return super.getList();
    }

    @Override
    public void writeParcelableCreator(@Nullable byte[] parcelable, @Nullable Parcel dest) {
    }

    @Override
    @Nullable
    public Parcelable.Creator<?> readParcelableCreator(@Nullable Parcel from, @Nullable ClassLoader loader) {
        return BYTE_ARRAY_CREATOR;
    }
}

