/*
 * Decompiled with CFR 0.152.
 */
package com.android.ondevicepersonalization.internal.util;

import android.annotation.ColorInt;
import android.annotation.FloatRange;
import android.annotation.IntRange;
import android.annotation.NonNull;
import android.annotation.Size;
import java.lang.annotation.Annotation;

public class AnnotationValidations {
    private AnnotationValidations() {
    }

    public static void validate(Class<IntRange> annotation, IntRange ignored, int value, String paramName1, long param1, String paramName2, long param2) {
        AnnotationValidations.validate(annotation, ignored, value, paramName1, param1);
        AnnotationValidations.validate(annotation, ignored, value, paramName2, param2);
    }

    public static void validate(Class<IntRange> annotation, IntRange ignored, int value, String paramName, long param) {
        switch (paramName) {
            case "from": {
                if ((long)value >= param) break;
                AnnotationValidations.invalid(annotation, value, paramName, param);
                break;
            }
            case "to": {
                if ((long)value <= param) break;
                AnnotationValidations.invalid(annotation, value, paramName, param);
            }
        }
    }

    public static void validate(Class<IntRange> annotation, IntRange ignored, long value, String paramName1, long param1, String paramName2, long param2) {
        AnnotationValidations.validate(annotation, ignored, value, paramName1, param1);
        AnnotationValidations.validate(annotation, ignored, value, paramName2, param2);
    }

    public static void validate(Class<IntRange> annotation, IntRange ignored, long value, String paramName, long param) {
        switch (paramName) {
            case "from": {
                if (value >= param) break;
                AnnotationValidations.invalid(annotation, value, paramName, param);
                break;
            }
            case "to": {
                if (value <= param) break;
                AnnotationValidations.invalid(annotation, value, paramName, param);
            }
        }
    }

    public static void validate(Class<FloatRange> annotation, FloatRange ignored, float value, String paramName1, float param1, String paramName2, float param2) {
        AnnotationValidations.validate(annotation, ignored, value, paramName1, param1);
        AnnotationValidations.validate(annotation, ignored, value, paramName2, param2);
    }

    public static void validate(Class<FloatRange> annotation, FloatRange ignored, float value, String paramName, float param) {
        switch (paramName) {
            case "from": {
                if (!(value < param)) break;
                AnnotationValidations.invalid(annotation, Float.valueOf(value), paramName, Float.valueOf(param));
                break;
            }
            case "to": {
                if (!(value > param)) break;
                AnnotationValidations.invalid(annotation, Float.valueOf(value), paramName, Float.valueOf(param));
            }
        }
    }

    public static void validate(Class<NonNull> annotation, NonNull ignored, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
    }

    public static void validate(Class<Size> annotation, Size ignored, int value, String paramName1, int param1, String paramName2, int param2) {
        AnnotationValidations.validate(annotation, ignored, value, paramName1, param1);
        AnnotationValidations.validate(annotation, ignored, value, paramName2, param2);
    }

    public static void validate(Class<Size> annotation, Size ignored, int value, String paramName, int param) {
        switch (paramName) {
            case "value": {
                if (param == -1 || value == param) break;
                AnnotationValidations.invalid(annotation, value, paramName, param);
                break;
            }
            case "min": {
                if (value >= param) break;
                AnnotationValidations.invalid(annotation, value, paramName, param);
                break;
            }
            case "max": {
                if (value <= param) break;
                AnnotationValidations.invalid(annotation, value, paramName, param);
                break;
            }
            case "multiple": {
                if (value % param == 0) break;
                AnnotationValidations.invalid(annotation, value, paramName, param);
            }
        }
    }

    @Deprecated
    public static void validate(Class<? extends Annotation> annotation, Annotation ignored, Object value, Object ... params) {
    }

    @Deprecated
    public static void validate(Class<? extends Annotation> annotation, Annotation ignored, Object value) {
    }

    @Deprecated
    public static void validate(Class<? extends Annotation> annotation, Annotation ignored, int value, Object ... params) {
    }

    public static void validate(Class<? extends Annotation> annotation, Annotation ignored, int value) {
        if (("android.annotation".equals(annotation.getPackageName()) && annotation.getSimpleName().endsWith("Res") || ColorInt.class.equals(annotation)) && value < 0) {
            AnnotationValidations.invalid(annotation, (Object)value);
        }
    }

    public static void validate(Class<? extends Annotation> annotation, Annotation ignored, long value) {
        if ("android.annotation".equals(annotation.getPackageName()) && annotation.getSimpleName().endsWith("Long") && value < 0L) {
            AnnotationValidations.invalid(annotation, (Object)value);
        }
    }

    private static void invalid(Class<? extends Annotation> annotation, Object value) {
        AnnotationValidations.invalid("@" + annotation.getSimpleName(), value);
    }

    private static void invalid(Class<? extends Annotation> annotation, Object value, String paramName, Object param) {
        String paramPrefix = "value".equals(paramName) ? "" : paramName + " = ";
        AnnotationValidations.invalid("@" + annotation.getSimpleName() + "(" + paramPrefix + param + ")", value);
    }

    private static void invalid(String valueKind, Object value) {
        throw new IllegalStateException("Invalid " + valueKind + ": " + value);
    }
}

